/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf.internal.debug.ui.model;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.debug.ui.IDebugView;
import org.eclipse.debug.ui.IDetailPane;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.resource.FontDescriptor;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.DocumentEvent;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentListener;
import org.eclipse.jface.text.ITextPresentationListener;
import org.eclipse.jface.text.TextPresentation;
import org.eclipse.jface.text.source.SourceViewer;
import org.eclipse.jface.text.source.SourceViewerConfiguration;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.tcf.internal.debug.ui.model.IDetailsProvider;
import org.eclipse.tcf.internal.debug.ui.model.StyledStringBuffer;
import org.eclipse.tcf.internal.debug.ui.model.TCFNode;
import org.eclipse.tcf.protocol.Protocol;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.IWorkbenchPartSite;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TCFDetailPane
implements IDetailPane,
IPropertyChangeListener {
    public static final String ID = "org.eclipse.tcf.debug.DetailPaneFactory";
    public static final String NAME = "TCF Detail Pane";
    public static final String DESC = "TCF Detail Pane";
    private static final String DETAIL_COPY_ACTION = String.valueOf(IDebugView.COPY_ACTION) + ".DetailPane";
    private static final String DETAIL_SELECT_ALL_ACTION = String.valueOf(IDebugView.SELECT_ALL_ACTION) + ".DetailPane";
    private SourceViewer source_viewer;
    private Display display;
    private int generation;
    private IWorkbenchPartSite part_site;
    private final Document document = new Document();
    private final ArrayList<StyleRange> style_ranges = new ArrayList();
    private final HashMap<RGB, Color> colors = new HashMap();
    private final Map<String, IAction> action_map = new HashMap<String, IAction>();
    private final List<String> selection_actions = new ArrayList<String>();
    private StyledStringBuffer doc_buffer;
    private Font mono_font;
    private final ITextPresentationListener presentation_listener = new ITextPresentationListener(){

        public void applyTextPresentation(TextPresentation presentation) {
            for (StyleRange r : TCFDetailPane.this.style_ranges) {
                presentation.addStyleRange(r);
            }
        }
    };

    private void createActions() {
        DetailPaneAction action = null;
        action = new DetailPaneAction("Select &All", 7);
        action.setActionDefinitionId("org.eclipse.ui.edit.selectAll");
        this.action_map.put(DETAIL_SELECT_ALL_ACTION, (IAction)action);
        action = new DetailPaneAction("&Copy", 4);
        action.setActionDefinitionId("org.eclipse.ui.edit.copy");
        this.action_map.put(DETAIL_COPY_ACTION, (IAction)action);
        this.selection_actions.add(DETAIL_COPY_ACTION);
        this.updateSelectionDependentActions();
    }

    private IAction getAction(String id) {
        return this.action_map.get(id);
    }

    private void setGlobalAction(String id, IAction action) {
        if (this.part_site instanceof IViewSite) {
            ((IViewSite)this.part_site).getActionBars().setGlobalActionHandler(id, action);
        }
    }

    private void createDetailContextMenu(Control menuControl) {
        if (this.part_site == null) {
            return;
        }
        MenuManager manager = new MenuManager();
        manager.setRemoveAllWhenShown(true);
        manager.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager mgr) {
                TCFDetailPane.this.fillDetailContextMenu(mgr);
            }
        });
        Menu menu = manager.createContextMenu(menuControl);
        menuControl.setMenu(menu);
        this.part_site.registerContextMenu(ID, manager, this.source_viewer.getSelectionProvider());
    }

    private void fillDetailContextMenu(IMenuManager menu) {
        menu.add(this.getAction(DETAIL_COPY_ACTION));
        menu.add(this.getAction(DETAIL_SELECT_ALL_ACTION));
        menu.add((IContributionItem)new Separator());
        menu.add((IContributionItem)new Separator("additions"));
    }

    private void updateAction(String id) {
        IAction action = this.getAction(id);
        if (action instanceof DetailPaneAction) {
            ((DetailPaneAction)action).update();
        }
    }

    private void updateSelectionDependentActions() {
        for (String id : this.selection_actions) {
            this.updateAction(id);
        }
    }

    public Control createControl(Composite parent) {
        assert (this.source_viewer == null);
        this.source_viewer = new SourceViewer(parent, null, 768);
        this.source_viewer.configure(new SourceViewerConfiguration());
        this.source_viewer.setDocument((IDocument)this.document);
        this.source_viewer.setEditable(false);
        this.source_viewer.addTextPresentationListener(this.presentation_listener);
        Control control = this.source_viewer.getControl();
        GridData gd = new GridData(1808);
        control.setLayoutData((Object)gd);
        this.display = control.getDisplay();
        this.createActions();
        this.document.addDocumentListener(new IDocumentListener(){

            public void documentAboutToBeChanged(DocumentEvent event) {
            }

            public void documentChanged(DocumentEvent event) {
                TCFDetailPane.this.updateSelectionDependentActions();
            }
        });
        this.source_viewer.getSelectionProvider().addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                TCFDetailPane.this.updateSelectionDependentActions();
            }
        });
        this.source_viewer.getControl().addFocusListener((FocusListener)new FocusAdapter(){

            public void focusGained(FocusEvent e) {
                if (TCFDetailPane.this.part_site != null) {
                    TCFDetailPane.this.part_site.setSelectionProvider(TCFDetailPane.this.source_viewer.getSelectionProvider());
                }
                TCFDetailPane.this.setGlobalAction(IDebugView.SELECT_ALL_ACTION, TCFDetailPane.this.getAction(DETAIL_SELECT_ALL_ACTION));
                TCFDetailPane.this.setGlobalAction(IDebugView.COPY_ACTION, TCFDetailPane.this.getAction(DETAIL_COPY_ACTION));
                if (TCFDetailPane.this.part_site instanceof IViewSite) {
                    ((IViewSite)TCFDetailPane.this.part_site).getActionBars().updateActionBars();
                }
            }

            public void focusLost(FocusEvent e) {
                if (TCFDetailPane.this.part_site != null) {
                    TCFDetailPane.this.part_site.setSelectionProvider(null);
                }
                TCFDetailPane.this.setGlobalAction(IDebugView.SELECT_ALL_ACTION, null);
                TCFDetailPane.this.setGlobalAction(IDebugView.COPY_ACTION, null);
                if (TCFDetailPane.this.part_site instanceof IViewSite) {
                    ((IViewSite)TCFDetailPane.this.part_site).getActionBars().updateActionBars();
                }
            }
        });
        this.createDetailContextMenu((Control)this.source_viewer.getTextWidget());
        JFaceResources.getFontRegistry().addListener((IPropertyChangeListener)this);
        return control;
    }

    public void display(IStructuredSelection selection) {
        if (this.source_viewer == null) {
            return;
        }
        ++this.generation;
        final int g = this.generation;
        final ArrayList<TCFNode> nodes = new ArrayList<TCFNode>();
        if (selection != null) {
            for (Object next : selection) {
                if (!(next instanceof TCFNode)) continue;
                nodes.add((TCFNode)next);
            }
        }
        Protocol.invokeLater((Runnable)new Runnable(){

            public void run() {
                if (g != TCFDetailPane.this.generation) {
                    return;
                }
                final StyledStringBuffer s = TCFDetailPane.this.getDetailText(nodes, this);
                if (s == null) {
                    return;
                }
                TCFDetailPane.this.display.asyncExec(new Runnable(){

                    public void run() {
                        if (g != TCFDetailPane.this.generation) {
                            return;
                        }
                        TCFDetailPane.this.doc_buffer = s;
                        TCFDetailPane.this.document.set(TCFDetailPane.this.getStyleRanges(s));
                    }
                });
            }
        });
    }

    private StyledStringBuffer getDetailText(ArrayList<TCFNode> nodes, Runnable done) {
        StyledStringBuffer bf = new StyledStringBuffer();
        for (TCFNode n : nodes) {
            if (!(n instanceof IDetailsProvider) || ((IDetailsProvider)((Object)n)).getDetailText(bf, done)) continue;
            return null;
        }
        return bf;
    }

    private String getStyleRanges(StyledStringBuffer s) {
        this.style_ranges.clear();
        for (StyledStringBuffer.Style x : s.getStyle()) {
            StyleRange r = new StyleRange(x.pos, x.len, this.getColor(x.fg), this.getColor(x.bg), x.font);
            if ((x.font & 4) != 0) {
                r.fontStyle &= 0xFFFFFFFB;
                r.font = this.getMonospacedFont();
            }
            this.style_ranges.add(r);
        }
        return s.toString();
    }

    private Color getColor(RGB rgb) {
        if (rgb == null) {
            return null;
        }
        Color c = this.colors.get(rgb);
        if (c == null) {
            c = new Color((Device)this.display, rgb);
            this.colors.put(rgb, c);
        }
        return c;
    }

    private Font getMonospacedFont() {
        if (this.mono_font == null) {
            FontData[] fd = this.source_viewer.getControl().getFont().getFontData();
            FontDescriptor d = JFaceResources.getFontDescriptor((String)"org.eclipse.debug.ui.DetailPaneFont");
            if (fd != null && fd.length > 0) {
                d = d.setHeight(fd[0].getHeight());
            }
            this.mono_font = d.createFont((Device)this.display);
        }
        return this.mono_font;
    }

    public void propertyChange(PropertyChangeEvent event) {
        for (Color c : this.colors.values()) {
            c.dispose();
        }
        this.colors.clear();
        if (this.mono_font != null) {
            this.mono_font.dispose();
            this.mono_font = null;
            if (this.doc_buffer != null) {
                this.document.set(this.getStyleRanges(this.doc_buffer));
            }
        }
    }

    public void dispose() {
        JFaceResources.getFontRegistry().removeListener((IPropertyChangeListener)this);
        if (this.mono_font != null) {
            this.mono_font.dispose();
            this.mono_font = null;
        }
        for (Color c : this.colors.values()) {
            c.dispose();
        }
        this.colors.clear();
        if (this.source_viewer == null) {
            return;
        }
        ++this.generation;
        if (this.source_viewer.getControl() != null) {
            this.source_viewer.getControl().dispose();
        }
        this.source_viewer = null;
        this.selection_actions.clear();
        this.action_map.clear();
    }

    public String getDescription() {
        return "TCF Detail Pane";
    }

    public String getID() {
        return ID;
    }

    public String getName() {
        return "TCF Detail Pane";
    }

    public void init(IWorkbenchPartSite part_site) {
        this.part_site = part_site;
    }

    public boolean setFocus() {
        if (this.source_viewer == null) {
            return false;
        }
        this.source_viewer.getTextWidget().setFocus();
        return true;
    }

    private class DetailPaneAction
    extends Action {
        final int op_code;

        DetailPaneAction(String text, int op_code) {
            super(text);
            this.op_code = op_code;
        }

        void update() {
            this.setEnabled(TCFDetailPane.this.source_viewer != null && TCFDetailPane.this.source_viewer.canDoOperation(this.op_code));
        }

        public void run() {
            if (!this.isEnabled()) {
                return;
            }
            TCFDetailPane.this.source_viewer.doOperation(this.op_code);
        }
    }
}

