/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf.internal.rse.shells;

import java.io.IOException;
import java.io.OutputStream;
import org.eclipse.tcf.internal.rse.shells.TCFTerminalShell;
import org.eclipse.tcf.protocol.IToken;
import org.eclipse.tcf.services.IStreams;
import org.eclipse.tcf.util.TCFTask;

public class TCFTerminalOutputStream
extends OutputStream {
    private final TCFTerminalShell terminal;
    private final IStreams streams;
    private final String os_id;
    private boolean connected = true;

    public TCFTerminalOutputStream(TCFTerminalShell terminal, IStreams streams, String os_id) throws IOException {
        if (streams == null) {
            throw new IOException("istream is null");
        }
        this.terminal = terminal;
        this.streams = streams;
        this.os_id = os_id;
    }

    public synchronized void write(final byte[] b, final int off, final int len) throws IOException {
        if (!this.connected) {
            throw new IOException("stream is not connected!");
        }
        new TCFTask<Object>(){

            public void run() {
                TCFTerminalOutputStream.this.streams.write(TCFTerminalOutputStream.this.os_id, b, off, len, new IStreams.DoneWrite(){

                    public void doneWrite(IToken token, Exception error) {
                        if (error != null) {
                            this.error(error);
                        } else {
                            this.done(this);
                        }
                    }
                });
            }
        }.getIO();
    }

    public synchronized void write(int b) throws IOException {
        byte[] buf = new byte[]{(byte)b};
        this.write(buf, 0, 1);
    }

    public void close() throws IOException {
        if (!this.connected) {
            return;
        }
        this.connected = false;
        new TCFTask<Object>(){

            public void run() {
                TCFTerminalOutputStream.this.streams.eos(TCFTerminalOutputStream.this.os_id, new IStreams.DoneEOS(){

                    public void doneEOS(IToken token, Exception error) {
                        if (error != null) {
                            this.error(error);
                            return;
                        }
                        TCFTerminalOutputStream.this.streams.disconnect(TCFTerminalOutputStream.this.os_id, new IStreams.DoneDisconnect(){

                            public void doneDisconnect(IToken token, Exception error) {
                                if (error != null) {
                                    this.error(error);
                                    return;
                                }
                                TCFTerminalOutputStream.this.terminal.onOutputStreamClosed();
                                this.done(this);
                            }
                        });
                    }
                });
            }
        }.getIO();
    }
}

