/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf.te.launch.ui.internal.handler;

import java.util.ArrayList;
import org.eclipse.core.expressions.IEvaluationContext;
import org.eclipse.core.runtime.Platform;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationType;
import org.eclipse.debug.core.ILaunchMode;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.debug.ui.actions.LaunchAction;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.tcf.te.launch.core.lm.LaunchConfigHelper;
import org.eclipse.tcf.te.launch.ui.model.LaunchNode;
import org.eclipse.ui.actions.CompoundContributionItem;
import org.eclipse.ui.handlers.IHandlerService;
import org.eclipse.ui.menus.IWorkbenchContribution;
import org.eclipse.ui.services.IServiceLocator;

public class LaunchLaunchConfigurationContributionItem
extends CompoundContributionItem
implements IWorkbenchContribution {
    private boolean enabled = true;
    private IServiceLocator serviceLocator;

    public LaunchLaunchConfigurationContributionItem() {
    }

    public LaunchLaunchConfigurationContributionItem(String id) {
        super(id);
    }

    public void initialize(IServiceLocator serviceLocator) {
        this.serviceLocator = serviceLocator;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    protected IContributionItem[] getContributionItems() {
        ArrayList<ActionContributionItem> items;
        block4: {
            LaunchNode node;
            IHandlerService service = (IHandlerService)this.serviceLocator.getService(IHandlerService.class);
            IEvaluationContext state = service.getCurrentState();
            ISelection selection = (ISelection)state.getVariable("selection");
            IStructuredSelection iss = (IStructuredSelection)selection;
            Object obj = iss.getFirstElement();
            items = new ArrayList<ActionContributionItem>();
            if (obj instanceof LaunchNode && (node = (LaunchNode)((Object)obj)).getLaunchConfiguration() != null) {
                try {
                    String[] stringArray = LaunchConfigHelper.getLaunchConfigTypeModes((ILaunchConfigurationType)node.getLaunchConfigurationType(), (boolean)false);
                    int n = stringArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        String mode = stringArray[n2];
                        ILaunchMode launchMode = DebugPlugin.getDefault().getLaunchManager().getLaunchMode(mode);
                        LaunchAction action = new LaunchAction(node.getLaunchConfiguration(), mode);
                        action.setText(launchMode.getLabel());
                        action.setImageDescriptor(DebugUITools.getLaunchGroup((ILaunchConfiguration)node.getLaunchConfiguration(), (String)mode).getImageDescriptor());
                        action.setEnabled(node.isValidFor(mode));
                        items.add(new ActionContributionItem((IAction)action));
                        ++n2;
                    }
                }
                catch (Exception e) {
                    if (!Platform.inDebugMode()) break block4;
                    e.printStackTrace();
                }
            }
        }
        this.enabled = !items.isEmpty();
        return items.toArray(new IContributionItem[items.size()]);
    }
}

