/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf.te.launch.ui.internal.handler;

import java.util.Map;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExecutableExtension;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationType;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.debug.ui.ILaunchGroup;
import org.eclipse.debug.ui.ILaunchShortcut;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.tcf.te.launch.core.lm.LaunchManager;
import org.eclipse.tcf.te.launch.core.lm.interfaces.ILaunchManagerDelegate;
import org.eclipse.tcf.te.launch.core.lm.interfaces.ILaunchSpecification;
import org.eclipse.tcf.te.launch.core.selection.interfaces.ILaunchSelection;
import org.eclipse.tcf.te.launch.ui.activator.UIPlugin;
import org.eclipse.tcf.te.launch.ui.selection.LaunchSelectionManager;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.handlers.HandlerUtil;

public class LaunchShortcutHandler
extends AbstractHandler
implements ILaunchShortcut,
IExecutableExtension {
    private String mode = null;
    private String typeId = null;

    public void launch(ISelection selection, String mode) {
        Assert.isNotNull((Object)this.typeId);
        ILaunchConfigurationType launchConfigType = DebugPlugin.getDefault().getLaunchManager().getLaunchConfigurationType(this.typeId);
        try {
            ILaunchSpecification launchSpec;
            ILaunchSelection launchSelection = LaunchSelectionManager.getInstance().getLaunchSelection(launchConfigType, mode, null);
            ILaunchManagerDelegate delegate = LaunchManager.getInstance().getLaunchManagerDelegate(launchConfigType, mode);
            if (delegate != null && launchSelection != null && (launchSpec = delegate.getLaunchSpecification(launchConfigType.getIdentifier(), launchSelection)) != null) {
                ILaunchConfiguration[] launchConfigs = DebugPlugin.getDefault().getLaunchManager().getLaunchConfigurations(launchConfigType);
                ILaunchConfiguration config = (launchConfigs = delegate.getMatchingLaunchConfigurations(launchSpec, launchConfigs)) != null && launchConfigs.length > 0 ? launchConfigs[0] : null;
                config = LaunchManager.getInstance().createOrUpdateLaunchConfiguration(config, launchSpec);
                ILaunchGroup launchGroup = DebugUITools.getLaunchGroup((ILaunchConfiguration)config, (String)mode);
                DebugUITools.openLaunchConfigurationDialogOnGroup((Shell)UIPlugin.getDefault().getWorkbench().getActiveWorkbenchWindow().getShell(), (IStructuredSelection)new StructuredSelection((Object)config), (String)launchGroup.getIdentifier());
            }
        }
        catch (Exception exception) {
            DebugUITools.openLaunchConfigurationDialogOnGroup((Shell)UIPlugin.getDefault().getWorkbench().getActiveWorkbenchWindow().getShell(), null, null);
        }
    }

    public void launch(IEditorPart editor, String mode) {
        this.launch((ISelection)null, mode);
    }

    public void setInitializationData(IConfigurationElement config, String propertyName, Object data) throws CoreException {
        if (data != null && data instanceof Map) {
            String launchTypeId;
            String launchMode = (String)((Map)data).get("mode");
            if (launchMode != null) {
                this.mode = launchMode;
            }
            if ((launchTypeId = (String)((Map)data).get("typeId")) != null) {
                this.typeId = launchTypeId;
            }
        }
    }

    public Object execute(ExecutionEvent event) throws ExecutionException {
        Assert.isNotNull((Object)this.mode);
        ISelection selection = HandlerUtil.getCurrentSelection((ExecutionEvent)event);
        this.launch(selection, this.mode);
        return null;
    }
}

