/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf.te.runtime.utils.net;

import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class IPAddressUtil {
    public static final int HOSTMAP_IPV6 = 1;
    public static final int HOSTMAP_IPV4 = 2;
    public static final int HOSTMAP_NAME = 4;
    public static final int HOSTMAP_ADDR = 8;
    public static final int HOSTMAP_CANONICALNAME = 16;
    public static final int HOSTMAP_CANONICALADDR = 32;
    public static final int HOSTMAP_MULTICAST = 64;
    public static final int HOSTMAP_LOOPBACK = 128;
    public static final int HOSTMAP_LINKLOCAL = 256;
    public static final int HOSTMAP_SITELOCAL = 512;
    public static final int HOSTMAP_GLOBAL = 1024;
    public static final int HOSTMAP_ANY_UNICAST = 1920;
    private final Map<String, Integer> fLocalHostAddresses = new HashMap<String, Integer>();
    private final Set<String> fNonLocalHostAddresses = new HashSet<String>();
    private String fCanonicalAddress = null;

    IPAddressUtil() {
        this.initializeHostCache();
    }

    private synchronized void initializeHostCache() {
        this.addLocalAddressesByInterface();
        try {
            InetAddress localHostJava = InetAddress.getLocalHost();
            this.addHostName(localHostJava.getHostName());
        }
        catch (UnknownHostException unknownHostException) {}
        this.addHostName("localhost");
        this.getCanonicalAddress();
    }

    private synchronized void addLocalAddressesByInterface() {
        Enumeration<NetworkInterface> interfaces = null;
        try {
            interfaces = NetworkInterface.getNetworkInterfaces();
        }
        catch (SocketException socketException) {}
        while (interfaces != null && interfaces.hasMoreElements()) {
            NetworkInterface iface = interfaces.nextElement();
            Enumeration<InetAddress> addresses = iface.getInetAddresses();
            while (addresses.hasMoreElements()) {
                InetAddress addr = addresses.nextElement();
                this.addLocalAddress(addr);
            }
        }
    }

    private synchronized void addLocalAddress(InetAddress addr) {
        int addrtype = addr.isLoopbackAddress() ? 128 : (addr.isLinkLocalAddress() ? 256 : (addr.isSiteLocalAddress() ? 512 : (addr.isMulticastAddress() ? 64 : 1024)));
        addrtype = addr.getAddress().length == 4 ? (addrtype |= 2) : (addrtype |= 1);
        String addrAsString = addr.getHostAddress();
        this.fLocalHostAddresses.put(addrAsString, addrtype | 8);
        if ((addrtype & 0x340) == 0) {
            String addrAsNameCan = addr.getCanonicalHostName().toLowerCase();
            String addrAsName = addr.getHostName().toLowerCase();
            if (!addrAsNameCan.equals(addrAsString)) {
                if ((addrtype & 0x80) == 0) {
                    this.fLocalHostAddresses.put(addrAsNameCan, addrtype | 4 | 0x10);
                    this.fLocalHostAddresses.put(addrAsString, addrtype | 8 | 0x20);
                } else {
                    this.fLocalHostAddresses.put(addrAsNameCan, addrtype | 4);
                }
            }
            if (!addrAsName.equals(addrAsString) && !addrAsName.equals(addrAsNameCan)) {
                this.fLocalHostAddresses.put(addrAsName, addrtype | 4);
            }
        }
    }

    private synchronized boolean addHostAddress(InetAddress addr, String hostName) {
        Integer entryType;
        if (addr == null) {
            this.fNonLocalHostAddresses.add(hostName);
            return false;
        }
        String hostAddr = addr.getHostAddress();
        if (!this.fLocalHostAddresses.containsKey(hostAddr) && addr.isLoopbackAddress()) {
            this.addLocalAddress(addr);
        }
        if ((entryType = this.fLocalHostAddresses.get(hostAddr)) != null) {
            if (!this.fLocalHostAddresses.containsKey(hostName)) {
                int addrtype = entryType & 0xFFFFFFD7;
                this.fLocalHostAddresses.put(hostName, addrtype | 4);
            }
            return true;
        }
        this.fNonLocalHostAddresses.add(hostName);
        this.fNonLocalHostAddresses.add(hostAddr);
        return false;
    }

    public boolean addHostName(String hostName) {
        hostName = hostName.toLowerCase();
        try {
            InetAddress addr = InetAddress.getByName(hostName);
            return this.addHostAddress(addr, hostName);
        }
        catch (UnknownHostException unknownHostException) {
            return this.addHostAddress(null, hostName);
        }
    }

    public synchronized String[] getLocalHostAddresses(int typesToGet) {
        if ((typesToGet & 8) != 0) {
            typesToGet |= 0x20;
        }
        if ((typesToGet & 4) != 0) {
            typesToGet |= 0x10;
        }
        ArrayList<String> addresses = new ArrayList<String>(this.fLocalHostAddresses.size());
        for (Map.Entry<String, Integer> entry : this.fLocalHostAddresses.entrySet()) {
            int addrtype = entry.getValue();
            if ((addrtype & typesToGet) != addrtype) continue;
            if ((addrtype & 0x80) != 0) {
                addresses.add(0, entry.getKey());
                continue;
            }
            addresses.add(entry.getKey());
        }
        return addresses.toArray(new String[addresses.size()]);
    }

    public synchronized String getIPv4LoopbackAddress() {
        if (this.isLocalHost("127.0.0.1")) {
            return "127.0.0.1";
        }
        Integer key = this.fLocalHostAddresses.get("localhost");
        if (key != null && (key & 2) != 0) {
            return "localhost";
        }
        int typemask = 1930;
        String[] candidates = this.getLocalHostAddresses(typemask);
        if (candidates.length == 0) {
            this.addLocalAddressesByInterface();
            candidates = this.getLocalHostAddresses(typemask);
        }
        return candidates.length > 0 ? candidates[0] : null;
    }

    public synchronized String getCanonicalAddress() {
        if (this.fCanonicalAddress == null) {
            Iterator<Map.Entry<String, Integer>> it = this.fLocalHostAddresses.entrySet().iterator();
            String bestAddress = null;
            int bestAddrType = 0;
            while (it.hasNext()) {
                Map.Entry<String, Integer> curEntry = it.next();
                int curAddrType = curEntry.getValue();
                if (curAddrType <= bestAddrType) continue;
                bestAddress = curEntry.getKey();
                bestAddrType = curAddrType;
            }
            this.fCanonicalAddress = bestAddress;
        }
        return this.fCanonicalAddress;
    }

    public synchronized String[] getCanonicalHostNames() {
        int typeMask = 1042;
        String[] canonicalNames = IPAddressUtil.getInstance().getLocalHostAddresses(typeMask);
        if (canonicalNames.length == 0) {
            canonicalNames = IPAddressUtil.getInstance().getLocalHostAddresses(typeMask |= 4);
        }
        return canonicalNames;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isLocalHost(String host) {
        if (host == null) {
            return false;
        }
        String hostLower = host.toLowerCase();
        IPAddressUtil iPAddressUtil = this;
        synchronized (iPAddressUtil) {
            block7: {
                block6: {
                    if (!this.fLocalHostAddresses.containsKey(hostLower)) break block6;
                    return true;
                }
                if (!this.fNonLocalHostAddresses.contains(hostLower)) break block7;
                return false;
            }
        }
        return this.addHostName(hostLower);
    }

    public boolean isSameHost(String h1, String h2) {
        if (h1 == null) {
            return h2 == null;
        }
        if (h2 == null) {
            return false;
        }
        if ((h1 = h1.trim()).equalsIgnoreCase(h2 = h2.trim())) {
            return true;
        }
        return this.isLocalHost(h1) && this.isLocalHost(h2);
    }

    public static IPAddressUtil getInstance() {
        return LazyHolder.instance;
    }

    private static class LazyHolder {
        public static IPAddressUtil instance = new IPAddressUtil();

        private LazyHolder() {
        }
    }
}

