/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf.te.tcf.core.concurrent;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import org.eclipse.core.runtime.Assert;
import org.eclipse.tcf.protocol.Protocol;
import org.eclipse.tcf.te.tcf.core.concurrent.Rendezvous;
import org.eclipse.tcf.te.tcf.core.concurrent.interfaces.IProxyDescriptor;
import org.eclipse.tcf.te.tcf.core.concurrent.internal.DefaultProxyDescriptor;

public class BlockingCallProxy
implements InvocationHandler {
    private static final long DEFAULT_TIMEOUT = 60000L;
    private long timeout = 60000L;
    private IProxyDescriptor proxyDescriptor;
    Object delegate;

    public static <T> T newInstance(Class<T> proxyInterface, T delegate) {
        return BlockingCallProxy.newInstance(proxyInterface, DefaultProxyDescriptor.getProxyDescriptor(proxyInterface), delegate);
    }

    public static <T> T newInstance(Class<T> proxyInterface, IProxyDescriptor proxyDescriptor, T delegate) {
        Assert.isTrue((proxyInterface != null && delegate != null ? 1 : 0) != 0);
        ClassLoader classLoader = proxyInterface.getClassLoader();
        BlockingCallProxy handler = new BlockingCallProxy(proxyDescriptor, delegate);
        return (T)Proxy.newProxyInstance(classLoader, new Class[]{proxyInterface}, (InvocationHandler)handler);
    }

    private BlockingCallProxy(IProxyDescriptor proxyDescriptor, Object delegate) {
        this.delegate = delegate;
        this.proxyDescriptor = proxyDescriptor;
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        Assert.isTrue((!Protocol.isDispatchThread() ? 1 : 0) != 0);
        Rendezvous rendezvous = this.prepareArguments(method, args);
        if (this.proxyDescriptor.isDispatchMethod(method)) {
            return this.dispatchCall(method, args, rendezvous);
        }
        return this.directCall(method, args, rendezvous);
    }

    private Rendezvous prepareArguments(Method method, Object[] args) {
        int index;
        if (this.proxyDescriptor.isProxyMethod(method) && (index = this.proxyDescriptor.getCallbackIndex(method)) != -1) {
            Rendezvous rendezvous = new Rendezvous();
            Class<?>[] aTypes = method.getParameterTypes();
            args[index] = Proxy.newProxyInstance(aTypes[index].getClassLoader(), new Class[]{aTypes[index]}, (InvocationHandler)new DoneHandler(rendezvous, args[index]));
            return rendezvous;
        }
        return null;
    }

    private Object directCall(Method method, Object[] args, Rendezvous rendezvous) throws Throwable {
        Object ret = method.invoke(this.delegate, args);
        if (rendezvous != null) {
            rendezvous.waiting(this.timeout);
        }
        return ret;
    }

    private Object dispatchCall(final Method method, final Object[] args, Rendezvous rendezvous) throws Throwable {
        final Object[] returns = new Object[1];
        final Exception[] exceptions = new Exception[1];
        Protocol.invokeAndWait((Runnable)new Runnable(){

            @Override
            public void run() {
                try {
                    returns[0] = method.invoke(BlockingCallProxy.this.delegate, args);
                }
                catch (Exception e) {
                    exceptions[0] = e;
                }
            }
        });
        if (rendezvous != null) {
            rendezvous.waiting(this.timeout);
        }
        if (exceptions[0] != null) {
            throw exceptions[0];
        }
        return returns[0];
    }

    private static class DoneHandler
    implements InvocationHandler {
        private Object done;
        private Rendezvous rendezvous;

        public DoneHandler(Rendezvous rendezvous, Object done) {
            this.rendezvous = rendezvous;
            this.done = done;
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            Object result = method.invoke(this.done, args);
            this.rendezvous.arrive();
            return result;
        }
    }
}

