/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf.te.tcf.filesystem.core.internal.callbacks;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.tcf.protocol.IToken;
import org.eclipse.tcf.services.IFileSystem;
import org.eclipse.tcf.te.runtime.interfaces.callback.ICallback;
import org.eclipse.tcf.te.tcf.filesystem.core.activator.CorePlugin;
import org.eclipse.tcf.te.tcf.filesystem.core.internal.callbacks.CallbackBase;
import org.eclipse.tcf.te.tcf.filesystem.core.model.FSTreeNode;

public class QueryDoneRoots
extends CallbackBase
implements IFileSystem.DoneRoots {
    FSTreeNode parentNode;
    ICallback callback;

    public QueryDoneRoots(ICallback callback, FSTreeNode parentNode) {
        this.callback = callback;
        this.parentNode = parentNode;
    }

    public void doneRoots(IToken token, IFileSystem.FileSystemException error, IFileSystem.DirEntry[] entries) {
        if (error == null) {
            if (entries.length > 0) {
                IFileSystem.DirEntry[] dirEntryArray = entries;
                int n = entries.length;
                int n2 = 0;
                while (n2 < n) {
                    IFileSystem.DirEntry entry = dirEntryArray[n2];
                    FSTreeNode node = new FSTreeNode(this.parentNode, entry, true);
                    this.parentNode.addChild(node);
                    ++n2;
                }
            } else {
                this.parentNode.clearChildren();
            }
        }
        if (this.callback != null) {
            IStatus status = error == null ? Status.OK_STATUS : new Status(4, CorePlugin.getUniqueIdentifier(), this.getErrorMessage((Throwable)error), (Throwable)error);
            this.callback.done((Object)this, status);
        }
    }
}

