/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf.te.tcf.filesystem.core.internal.operations;

import org.eclipse.tcf.protocol.IToken;
import org.eclipse.tcf.services.IFileSystem;
import org.eclipse.tcf.te.tcf.filesystem.core.internal.exceptions.TCFFileSystemException;
import org.eclipse.tcf.te.tcf.filesystem.core.internal.operations.OpCreate;
import org.eclipse.tcf.te.tcf.filesystem.core.model.FSModel;
import org.eclipse.tcf.te.tcf.filesystem.core.model.FSTreeNode;
import org.eclipse.tcf.te.tcf.filesystem.core.nls.Messages;

public class OpCreateFile
extends OpCreate {
    public OpCreateFile(FSTreeNode folder, String name) {
        super(folder, name);
    }

    @Override
    protected void create(IFileSystem service) throws TCFFileSystemException {
        String path = this.folder.getLocation(true);
        if (!path.endsWith("/")) {
            path = String.valueOf(path) + "/";
        }
        path = String.valueOf(path) + this.name;
        final IFileSystem.FileSystemException[] errors = new IFileSystem.FileSystemException[1];
        final IFileSystem.IFileHandle[] handles = new IFileSystem.IFileHandle[1];
        service.open(path, 26, null, new IFileSystem.DoneOpen(){

            public void doneOpen(IToken token, IFileSystem.FileSystemException error, IFileSystem.IFileHandle hdl) {
                errors[0] = error;
                handles[0] = hdl;
            }
        });
        if (errors[0] != null) {
            TCFFileSystemException exception = new TCFFileSystemException(errors[0].toString());
            exception.initCause((Throwable)errors[0]);
            throw exception;
        }
        if (handles[0] == null) {
            throw new TCFFileSystemException(Messages.TcfURLConnection_NoFileHandleReturned);
        }
        service.close(handles[0], new IFileSystem.DoneClose(){

            public void doneClose(IToken token, IFileSystem.FileSystemException error) {
            }
        });
    }

    @Override
    protected FSTreeNode newTreeNode() {
        return FSModel.createFileNode(this.name, this.folder);
    }
}

