/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf.te.tcf.filesystem.core.services;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.ConnectException;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.osgi.util.NLS;
import org.eclipse.tcf.protocol.IChannel;
import org.eclipse.tcf.protocol.IPeer;
import org.eclipse.tcf.protocol.IToken;
import org.eclipse.tcf.protocol.Protocol;
import org.eclipse.tcf.services.IFileSystem;
import org.eclipse.tcf.te.runtime.interfaces.callback.ICallback;
import org.eclipse.tcf.te.runtime.services.interfaces.filetransfer.IFileTransferItem;
import org.eclipse.tcf.te.runtime.utils.ProgressHelper;
import org.eclipse.tcf.te.runtime.utils.StatusHelper;
import org.eclipse.tcf.te.tcf.core.Tcf;
import org.eclipse.tcf.te.tcf.core.concurrent.BlockingCallProxy;
import org.eclipse.tcf.te.tcf.core.interfaces.IChannelManager;
import org.eclipse.tcf.te.tcf.filesystem.core.internal.exceptions.TCFChannelException;
import org.eclipse.tcf.te.tcf.filesystem.core.nls.Messages;
import org.eclipse.tcf.util.TCFFileInputStream;
import org.eclipse.tcf.util.TCFFileOutputStream;

public class FileTransferService {
    public static void transfer(IPeer peer, IChannel channel, IFileTransferItem item, IProgressMonitor monitor, ICallback callback) {
        block6: {
            boolean ownChannel = false;
            try {
                if (channel == null) {
                    ownChannel = true;
                    channel = FileTransferService.openChannel(peer);
                }
                IFileSystem fileSystem = FileTransferService.getBlockingFileSystem(channel);
                Assert.isNotNull((Object)fileSystem);
                if (item.getDirection() == 2) {
                    FileTransferService.transferToHost(peer, fileSystem, item, monitor, callback);
                } else {
                    FileTransferService.transferToTarget(peer, fileSystem, item, monitor, callback);
                }
                if (ownChannel) {
                    FileTransferService.closeChannel(peer, channel);
                }
            }
            catch (Exception e) {
                if (callback == null) break block6;
                callback.done((Object)peer, StatusHelper.getStatus((Throwable)e));
            }
        }
    }

    protected static void transfer(IPeer peer, IFileTransferItem item, IProgressMonitor monitor, ICallback callback) {
        block4: {
            if (!item.isEnabled()) {
                if (callback != null) {
                    callback.done((Object)peer, Status.OK_STATUS);
                }
                return;
            }
            try {
                IChannel channel = FileTransferService.openChannel(peer);
                FileTransferService.transfer(peer, channel, item, monitor, callback);
                FileTransferService.closeChannel(peer, channel);
            }
            catch (Exception e) {
                if (callback == null) break block4;
                callback.done((Object)peer, StatusHelper.getStatus((Throwable)e));
            }
        }
    }

    protected static void transferToHost(IPeer peer, IFileSystem fileSystem, IFileTransferItem item, IProgressMonitor monitor, ICallback callback) {
        IStatus result;
        block55: {
            long mtime;
            TCFFileInputStream inStream;
            IPath hostPath;
            block57: {
                result = Status.OK_STATUS;
                hostPath = item.getHostPath();
                IPath targetPath = item.getTargetPath();
                FilterOutputStream outStream = null;
                inStream = null;
                final IFileSystem.IFileHandle[] handle = new IFileSystem.IFileHandle[1];
                final IFileSystem.FileSystemException[] error = new IFileSystem.FileSystemException[1];
                final IFileSystem.FileAttrs[] attrs = new IFileSystem.FileAttrs[1];
                item.getHostPath().removeLastSegments(1).toFile().mkdirs();
                if (hostPath.toFile().isDirectory()) {
                    hostPath = item.getHostPath().append(targetPath.lastSegment());
                }
                mtime = -1L;
                try {
                    fileSystem.open(targetPath.toString(), 1, null, new IFileSystem.DoneOpen(){

                        public void doneOpen(IToken token, IFileSystem.FileSystemException e, IFileSystem.IFileHandle h) {
                            error[0] = e;
                            handle[0] = h;
                        }
                    });
                    if (error[0] != null) {
                        throw error[0];
                    }
                    fileSystem.fstat(handle[0], new IFileSystem.DoneStat(){

                        public void doneStat(IToken token, IFileSystem.FileSystemException e, IFileSystem.FileAttrs a) {
                            error[0] = e;
                            attrs[0] = a;
                        }
                    });
                    if (error[0] != null) {
                        throw error[0];
                    }
                    mtime = attrs[0].mtime;
                    outStream = new BufferedOutputStream(new FileOutputStream(hostPath.toFile()));
                    inStream = new TCFFileInputStream(handle[0]);
                    ProgressHelper.setSubTaskName((IProgressMonitor)monitor, (String)("Transfer '" + targetPath.toString() + "' to '" + hostPath.toOSString() + "'"));
                    long bytesTotal = attrs[0].size;
                    FileTransferService.copy((InputStream)inStream, outStream, bytesTotal, monitor);
                }
                catch (OperationCanceledException operationCanceledException) {
                    result = Status.CANCEL_STATUS;
                    if (outStream != null) {
                        try {
                            outStream.close();
                            outStream = null;
                        }
                        catch (IOException iOException) {}
                    }
                    if (inStream != null) {
                        try {
                            inStream.close();
                            inStream = null;
                        }
                        catch (IOException iOException) {}
                    }
                    if (result.isOK()) {
                        if (mtime >= 0L) {
                            hostPath.toFile().setLastModified(mtime);
                        }
                    } else if (result.getSeverity() == 4 || result.getSeverity() == 8) {
                        try {
                            hostPath.toFile().delete();
                        }
                        catch (Throwable throwable) {}
                    }
                    break block55;
                }
                catch (Exception e) {
                    block56: {
                        try {
                            result = StatusHelper.getStatus((Throwable)e);
                            if (outStream == null) break block56;
                        }
                        catch (Throwable throwable) {
                            if (outStream != null) {
                                try {
                                    outStream.close();
                                    outStream = null;
                                }
                                catch (IOException iOException) {}
                            }
                            if (inStream != null) {
                                try {
                                    inStream.close();
                                    inStream = null;
                                }
                                catch (IOException iOException) {}
                            }
                            if (result.isOK()) {
                                if (mtime >= 0L) {
                                    hostPath.toFile().setLastModified(mtime);
                                }
                            } else if (result.getSeverity() == 4 || result.getSeverity() == 8) {
                                try {
                                    hostPath.toFile().delete();
                                }
                                catch (Throwable throwable2) {}
                            }
                            throw throwable;
                        }
                        try {
                            outStream.close();
                            outStream = null;
                        }
                        catch (IOException iOException) {}
                    }
                    if (inStream != null) {
                        try {
                            inStream.close();
                            inStream = null;
                        }
                        catch (IOException iOException) {}
                    }
                    if (result.isOK()) {
                        if (mtime >= 0L) {
                            hostPath.toFile().setLastModified(mtime);
                        }
                    } else if (result.getSeverity() == 4 || result.getSeverity() == 8) {
                        try {
                            hostPath.toFile().delete();
                        }
                        catch (Throwable throwable) {}
                    }
                    break block55;
                }
                if (outStream == null) break block57;
                try {
                    outStream.close();
                    outStream = null;
                }
                catch (IOException iOException) {}
            }
            if (inStream != null) {
                try {
                    inStream.close();
                    inStream = null;
                }
                catch (IOException iOException) {}
            }
            if (result.isOK()) {
                if (mtime >= 0L) {
                    hostPath.toFile().setLastModified(mtime);
                }
            } else if (result.getSeverity() == 4 || result.getSeverity() == 8) {
                try {
                    hostPath.toFile().delete();
                }
                catch (Throwable throwable) {}
            }
        }
        callback.done((Object)peer, result);
    }

    protected static void transferToTarget(IPeer peer, IFileSystem fileSystem, IFileTransferItem item, IProgressMonitor monitor, ICallback callback) {
        IStatus result;
        block34: {
            BufferedInputStream inStream;
            IPath targetPath;
            block36: {
                result = Status.OK_STATUS;
                targetPath = item.getTargetPath();
                IPath hostPath = item.getHostPath();
                inStream = null;
                TCFFileOutputStream outStream = null;
                final IFileSystem.IFileHandle[] handle = new IFileSystem.IFileHandle[1];
                final IFileSystem.FileSystemException[] error = new IFileSystem.FileSystemException[1];
                final IFileSystem.FileAttrs[] attrs = new IFileSystem.FileAttrs[1];
                fileSystem.stat(targetPath.toString(), new IFileSystem.DoneStat(){

                    public void doneStat(IToken token, IFileSystem.FileSystemException e, IFileSystem.FileAttrs a) {
                        error[0] = e;
                        attrs[0] = a;
                    }
                });
                if (error[0] != null || attrs[0] != null && attrs[0].isDirectory()) {
                    targetPath = targetPath.append(item.getHostPath().lastSegment());
                }
                try {
                    fileSystem.open(targetPath.toString(), 26, null, new IFileSystem.DoneOpen(){

                        public void doneOpen(IToken token, IFileSystem.FileSystemException e, IFileSystem.IFileHandle h) {
                            error[0] = e;
                            handle[0] = h;
                        }
                    });
                    if (error[0] != null) {
                        throw error[0];
                    }
                    inStream = new BufferedInputStream(new FileInputStream(hostPath.toFile()));
                    outStream = new TCFFileOutputStream(handle[0]);
                    ProgressHelper.setSubTaskName((IProgressMonitor)monitor, (String)("Transfer '" + hostPath.toOSString() + "' to '" + targetPath.toString() + "'"));
                    FileTransferService.copy(inStream, (OutputStream)outStream, hostPath.toFile().length(), monitor);
                    fileSystem.fstat(handle[0], new IFileSystem.DoneStat(){

                        public void doneStat(IToken token, IFileSystem.FileSystemException e, IFileSystem.FileAttrs a) {
                            error[0] = e;
                            attrs[0] = a;
                        }
                    });
                    IFileSystem.FileAttrs newAttrs = new IFileSystem.FileAttrs(attrs[0].flags, attrs[0].size, attrs[0].uid, attrs[0].gid, attrs[0].permissions, attrs[0].atime, hostPath.toFile().lastModified(), attrs[0].attributes);
                    fileSystem.fsetstat(handle[0], newAttrs, new IFileSystem.DoneSetStat(){

                        public void doneSetStat(IToken token, IFileSystem.FileSystemException e) {
                            error[0] = e;
                        }
                    });
                }
                catch (OperationCanceledException operationCanceledException) {
                    result = Status.CANCEL_STATUS;
                    if (outStream != null) {
                        try {
                            outStream.close();
                            outStream = null;
                        }
                        catch (IOException iOException) {}
                    }
                    if (inStream != null) {
                        try {
                            inStream.close();
                            inStream = null;
                        }
                        catch (IOException iOException) {}
                    }
                    if (result.getSeverity() == 4 || result.getSeverity() == 8) {
                        fileSystem.remove(targetPath.toString(), null);
                    }
                    break block34;
                }
                catch (Exception e) {
                    block35: {
                        try {
                            result = StatusHelper.getStatus((Throwable)e);
                            if (outStream == null) break block35;
                        }
                        catch (Throwable throwable) {
                            if (outStream != null) {
                                try {
                                    outStream.close();
                                    outStream = null;
                                }
                                catch (IOException iOException) {}
                            }
                            if (inStream != null) {
                                try {
                                    inStream.close();
                                    inStream = null;
                                }
                                catch (IOException iOException) {}
                            }
                            if (result.getSeverity() == 4 || result.getSeverity() == 8) {
                                fileSystem.remove(targetPath.toString(), null);
                            }
                            throw throwable;
                        }
                        try {
                            outStream.close();
                            outStream = null;
                        }
                        catch (IOException iOException) {}
                    }
                    if (inStream != null) {
                        try {
                            inStream.close();
                            inStream = null;
                        }
                        catch (IOException iOException) {}
                    }
                    if (result.getSeverity() == 4 || result.getSeverity() == 8) {
                        fileSystem.remove(targetPath.toString(), null);
                    }
                    break block34;
                }
                if (outStream == null) break block36;
                try {
                    outStream.close();
                    outStream = null;
                }
                catch (IOException iOException) {}
            }
            if (inStream != null) {
                try {
                    inStream.close();
                    inStream = null;
                }
                catch (IOException iOException) {}
            }
            if (result.getSeverity() == 4 || result.getSeverity() == 8) {
                fileSystem.remove(targetPath.toString(), null);
            }
        }
        callback.done((Object)peer, result);
    }

    private static void copy(InputStream in, OutputStream out, long bytesTotal, IProgressMonitor monitor) throws IOException {
        long bytesDone = 0L;
        long startTimeStamp = System.currentTimeMillis();
        byte[] dataBuffer = new byte[12288];
        while (true) {
            if (ProgressHelper.isCanceled((IProgressMonitor)monitor)) {
                throw new OperationCanceledException();
            }
            int bytesRead = in.read(dataBuffer);
            if (bytesRead < 0) break;
            if (ProgressHelper.isCanceled((IProgressMonitor)monitor)) {
                throw new OperationCanceledException();
            }
            out.write(dataBuffer, 0, bytesRead);
            long timestamp = System.currentTimeMillis();
            long speed = (bytesDone += (long)bytesRead) * 1000L / Math.max(timestamp - startTimeStamp, 1L);
            ProgressHelper.worked((IProgressMonitor)monitor, (int)new Long((long)bytesRead / bytesTotal * 1000L).intValue());
            ProgressHelper.setSubTaskName((IProgressMonitor)monitor, (String)FileTransferService.getProgressMessage(bytesDone, bytesTotal, speed));
        }
    }

    protected static IChannel openChannel(final IPeer peer) throws TCFChannelException {
        IChannelManager proxy = (IChannelManager)BlockingCallProxy.newInstance(IChannelManager.class, (Object)Tcf.getChannelManager());
        final TCFChannelException[] errors = new TCFChannelException[1];
        final IChannel[] channels = new IChannel[1];
        proxy.openChannel(peer, null, new IChannelManager.DoneOpenChannel(){

            public void doneOpenChannel(Throwable error, IChannel channel) {
                if (error != null) {
                    if (error instanceof ConnectException) {
                        String message = NLS.bind((String)Messages.Operation_NotResponding, (Object)peer.getID());
                        errors[0] = new TCFChannelException(message);
                    } else {
                        String message = NLS.bind((String)Messages.Operation_OpeningChannelFailureMessage, (Object)peer.getID(), (Object)error.getMessage());
                        errors[0] = new TCFChannelException(message, error);
                    }
                } else {
                    channels[0] = channel;
                }
            }
        });
        if (errors[0] != null) {
            throw errors[0];
        }
        return channels[0];
    }

    protected static void closeChannel(IPeer peer, IChannel channel) throws TCFChannelException {
        if (channel != null) {
            IChannelManager proxy = (IChannelManager)BlockingCallProxy.newInstance(IChannelManager.class, (Object)Tcf.getChannelManager());
            proxy.closeChannel(channel);
        }
    }

    protected static IFileSystem getBlockingFileSystem(final IChannel channel) {
        if (Protocol.isDispatchThread()) {
            IFileSystem service = (IFileSystem)channel.getRemoteService(IFileSystem.class);
            return (IFileSystem)BlockingCallProxy.newInstance(IFileSystem.class, (Object)service);
        }
        final IFileSystem[] service = new IFileSystem[1];
        Protocol.invokeAndWait((Runnable)new Runnable(){

            @Override
            public void run() {
                service[0] = FileTransferService.getBlockingFileSystem(channel);
            }
        });
        return service[0];
    }

    private static String getProgressMessage(long bytesDone, long bytesTotal, long bytesSpeed) {
        String done = "B";
        String total = "B";
        String speed = "B/s";
        if (bytesDone > 1024L) {
            bytesDone /= 1024L;
            done = "KB";
        }
        if (bytesDone > 1024L) {
            bytesDone /= 1024L;
            done = "MB";
        }
        if (bytesSpeed > 1024L) {
            bytesSpeed /= 1024L;
            speed = "GB/s";
        }
        if (bytesTotal > 1024L) {
            bytesTotal /= 1024L;
            total = "KB";
        }
        if (bytesTotal > 1024L) {
            bytesTotal /= 1024L;
            total = "MB";
        }
        if (bytesTotal > 1024L) {
            bytesTotal /= 1024L;
            total = "GB";
        }
        if (bytesSpeed > 1024L) {
            bytesSpeed /= 1024L;
            speed = "KB/s";
        }
        if (bytesSpeed > 1024L) {
            bytesSpeed /= 1024L;
            speed = "MB/s";
        }
        if (bytesDone > 1024L) {
            bytesDone /= 1024L;
            done = "GB";
        }
        return String.valueOf(bytesDone) + done + " of " + bytesTotal + total + " at " + bytesSpeed + speed;
    }
}

