/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf.te.tcf.launch.core.internal.adapters;

import java.util.concurrent.atomic.AtomicReference;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.PlatformObject;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationType;
import org.eclipse.tcf.protocol.Protocol;
import org.eclipse.tcf.te.runtime.interfaces.properties.IPropertiesContainer;
import org.eclipse.tcf.te.runtime.stepper.interfaces.IStepContext;

public class StepContextAdapter
extends PlatformObject
implements IStepContext {
    private final ILaunch launch;

    public StepContextAdapter(ILaunch launch) {
        Assert.isNotNull((Object)launch);
        this.launch = launch;
    }

    public ILaunch getLaunch() {
        return this.launch;
    }

    public String getId() {
        return this.launch != null && this.launch.getLaunchConfiguration() != null ? this.launch.getLaunchConfiguration().getName() : null;
    }

    public String getName() {
        final AtomicReference name = new AtomicReference();
        if (this.launch != null) {
            Runnable runnable = new Runnable(){

                @Override
                public void run() {
                    name.set(StepContextAdapter.this.getId());
                }
            };
            if (Protocol.isDispatchThread()) {
                runnable.run();
            } else {
                Protocol.invokeAndWait((Runnable)runnable);
            }
        }
        return (String)name.get();
    }

    public Object getContextObject() {
        return this.launch;
    }

    public String getInfo(IPropertiesContainer data) {
        try {
            return String.valueOf(this.getName()) + "(" + this.launch.getLaunchMode() + ") - " + this.launch.getLaunchConfiguration().getType().getName();
        }
        catch (CoreException coreException) {
            return String.valueOf(this.getName()) + "(" + this.launch.getLaunchMode() + ")";
        }
    }

    public Object getAdapter(final Class adapter) {
        final AtomicReference object = new AtomicReference();
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                object.set(StepContextAdapter.this.doGetAdapter(adapter));
            }
        };
        if (Protocol.isDispatchThread()) {
            runnable.run();
        } else {
            Protocol.invokeAndWait((Runnable)runnable);
        }
        return object.get() != null ? object.get() : super.getAdapter(adapter);
    }

    protected Object doGetAdapter(Class<?> adapter) {
        if (ILaunch.class.equals(adapter)) {
            return this.launch;
        }
        if (ILaunchConfiguration.class.equals(adapter)) {
            return this.launch.getLaunchConfiguration();
        }
        if (ILaunchConfigurationType.class.equals(adapter)) {
            try {
                return this.launch.getLaunchConfiguration().getType();
            }
            catch (CoreException coreException) {}
        }
        return null;
    }
}

