/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf.te.tcf.locator.listener;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import org.eclipse.core.runtime.Assert;
import org.eclipse.tcf.core.AbstractPeer;
import org.eclipse.tcf.protocol.IPeer;
import org.eclipse.tcf.protocol.Protocol;
import org.eclipse.tcf.services.ILocator;
import org.eclipse.tcf.te.tcf.locator.ScannerRunnable;
import org.eclipse.tcf.te.tcf.locator.activator.CoreBundleActivator;
import org.eclipse.tcf.te.tcf.locator.interfaces.nodes.ILocatorModel;
import org.eclipse.tcf.te.tcf.locator.interfaces.nodes.IPeerModel;
import org.eclipse.tcf.te.tcf.locator.interfaces.services.ILocatorModelLookupService;
import org.eclipse.tcf.te.tcf.locator.interfaces.services.ILocatorModelRefreshService;
import org.eclipse.tcf.te.tcf.locator.interfaces.services.ILocatorModelUpdateService;
import org.eclipse.tcf.te.tcf.locator.nodes.PeerModel;

public class LocatorListener
implements ILocator.LocatorListener {
    private final ILocatorModel model;
    private final Map<IPeer, AtomicBoolean> PEER_CHANGED_GUARDIANS = new HashMap<IPeer, AtomicBoolean>();

    public LocatorListener(ILocatorModel model) {
        Assert.isNotNull((Object)model);
        this.model = model;
    }

    public void peerAdded(IPeer peer) {
        if (CoreBundleActivator.getTraceHandler().isSlotEnabled(0, "trace/locatorListener")) {
            CoreBundleActivator.getTraceHandler().trace("LocatorListener.peerAdded( " + (peer != null ? peer.getID() : null) + " )", "trace/locatorListener", (Object)this);
        }
        if (this.model != null && peer != null) {
            IPeerModel peerNode = this.model.getService(ILocatorModelLookupService.class).lkupPeerModelById(peer.getID());
            if (peerNode == null) {
                peerNode = new PeerModel(this.model, peer);
                if ((peerNode = this.model.validatePeerNodeForAdd(peerNode)) != null) {
                    this.model.getService(ILocatorModelUpdateService.class).add(peerNode);
                    ScannerRunnable runnable = new ScannerRunnable(this.model.getScanner(), peerNode);
                    Protocol.invokeLater((Runnable)runnable);
                }
            } else {
                peerNode.setProperty("instance", peer);
            }
        }
    }

    public void peerChanged(IPeer peer) {
        if (peer != null) {
            AtomicBoolean guard = this.PEER_CHANGED_GUARDIANS.get(peer);
            if (guard != null && guard.get()) {
                return;
            }
            if (guard != null) {
                guard.set(true);
            } else {
                this.PEER_CHANGED_GUARDIANS.put(peer, new AtomicBoolean(true));
            }
        }
        if (CoreBundleActivator.getTraceHandler().isSlotEnabled(0, "trace/locatorListener")) {
            CoreBundleActivator.getTraceHandler().trace("LocatorListener.peerChanged( " + (peer != null ? peer.getID() : null) + " )", "trace/locatorListener", (Object)this);
        }
        if (this.model != null && peer != null) {
            IPeer oldPeer;
            IPeerModel peerNode = this.model.getService(ILocatorModelLookupService.class).lkupPeerModelById(peer.getID());
            if (peerNode != null && (oldPeer = peerNode.getPeer()) != peer) {
                if (oldPeer instanceof AbstractPeer) {
                    peerNode.setProperty("instance", peer);
                } else {
                    this.model.getService(ILocatorModelUpdateService.class).mergeUserDefinedAttributes(peerNode, peer, false);
                }
            }
            this.model.getService(ILocatorModelRefreshService.class).refreshStaticPeers();
        }
        if (peer != null) {
            this.PEER_CHANGED_GUARDIANS.remove(peer);
        }
    }

    public void peerRemoved(String id) {
        IPeerModel peerNode;
        if (CoreBundleActivator.getTraceHandler().isSlotEnabled(0, "trace/locatorListener")) {
            CoreBundleActivator.getTraceHandler().trace("LocatorListener.peerRemoved( " + id + " )", "trace/locatorListener", (Object)this);
        }
        if (this.model != null && id != null && (peerNode = this.model.getService(ILocatorModelLookupService.class).lkupPeerModelById(id)) != null) {
            this.model.getService(ILocatorModelUpdateService.class).remove(peerNode);
        }
    }

    public void peerHeartBeat(String id) {
        if (CoreBundleActivator.getTraceHandler().isSlotEnabled(0, "trace/locatorListener")) {
            CoreBundleActivator.getTraceHandler().trace("LocatorListener.peerHeartBeat( " + id + " )", "trace/locatorListener", (Object)this);
        }
    }
}

