/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf.te.tcf.locator.nodes;

import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import org.eclipse.core.runtime.Assert;
import org.eclipse.tcf.protocol.IPeer;
import org.eclipse.tcf.protocol.Protocol;
import org.eclipse.tcf.te.runtime.model.ContainerModelNode;
import org.eclipse.tcf.te.tcf.locator.interfaces.nodes.ILocatorModel;
import org.eclipse.tcf.te.tcf.locator.interfaces.nodes.IPeerModel;

public class PeerModel
extends ContainerModelNode
implements IPeerModel {
    private final ILocatorModel model;
    private String peerId;

    public PeerModel(ILocatorModel model, IPeer peer) {
        Assert.isNotNull((Object)model);
        this.model = model;
        Assert.isNotNull((Object)peer);
        this.setProperty("instance", peer);
        this.peerId = peer.getID();
        Assert.isNotNull((Object)this.peerId);
        this.allowSetParentOnNonNullParent = true;
        this.suppressEventsOnNullParent = false;
        this.setChangeEventsEnabled(true);
    }

    protected final boolean checkThreadAccess() {
        return Protocol.isDispatchThread();
    }

    @Override
    public ILocatorModel getModel() {
        return (ILocatorModel)this.getAdapter(ILocatorModel.class);
    }

    @Override
    public IPeer getPeer() {
        return (IPeer)this.getAdapter(IPeer.class);
    }

    @Override
    public String getPeerId() {
        return this.peerId;
    }

    @Override
    public boolean isComplete() {
        Assert.isTrue((boolean)this.checkThreadAccess(), (String)"Illegal Thread Access");
        boolean complete = true;
        String transport = this.getPeer().getTransportName();
        if (transport == null) {
            complete = false;
        } else {
            String ip = (String)this.getPeer().getAttributes().get("Host");
            if (("TCP".equals(transport) || "SSL".equals(transport)) && ip == null) {
                complete = false;
            }
        }
        return complete;
    }

    public Object getAdapter(final Class adapter) {
        final AtomicReference object = new AtomicReference();
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                object.set(PeerModel.this.doGetAdapter(adapter));
            }
        };
        if (Protocol.isDispatchThread()) {
            runnable.run();
        } else {
            Protocol.invokeAndWait((Runnable)runnable);
        }
        return object.get() != null ? object.get() : super.getAdapter(adapter);
    }

    protected Object doGetAdapter(Class<?> adapter) {
        Assert.isTrue((boolean)this.checkThreadAccess(), (String)"Illegal Thread Access");
        if (ILocatorModel.class.equals(adapter)) {
            return this.model;
        }
        Object peer = this.getProperty("instance");
        if (peer != null && adapter.isAssignableFrom(peer.getClass())) {
            return peer;
        }
        return null;
    }

    public String toString() {
        final StringBuilder buffer = new StringBuilder(this.getClass().getSimpleName());
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                IPeer peer = PeerModel.this.getPeer();
                buffer.append(": id=" + peer.getID());
                buffer.append(", name=" + peer.getName());
            }
        };
        if (Protocol.isDispatchThread()) {
            runnable.run();
        } else {
            Protocol.invokeAndWait((Runnable)runnable);
        }
        buffer.append(", " + super.toString());
        return buffer.toString();
    }

    public boolean equals(Object obj) {
        if (obj instanceof PeerModel) {
            return this.getPeerId().equals(((PeerModel)obj).getPeerId());
        }
        return super.equals(obj);
    }

    public int hashCode() {
        return this.getPeerId().hashCode();
    }

    protected void postSetProperties(Map<String, ?> properties) {
        Assert.isTrue((boolean)this.checkThreadAccess(), (String)"Illegal Thread Access");
        Assert.isNotNull(properties);
        Assert.isNotNull((Object)this.getPeer());
        this.peerId = this.getPeer().getID();
        Assert.isNotNull((Object)this.peerId);
        super.postSetProperties(properties);
    }

    public void postSetProperty(String key, Object value, Object oldValue) {
        Assert.isTrue((boolean)this.checkThreadAccess(), (String)"Illegal Thread Access");
        Assert.isNotNull((Object)key);
        Assert.isNotNull((Object)this.getPeer());
        if ("instance".equals(key)) {
            this.peerId = this.getPeer().getID();
            Assert.isNotNull((Object)this.peerId);
        }
        super.postSetProperty(key, value, oldValue);
    }
}

