/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf.te.tcf.locator.services;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import org.eclipse.core.runtime.Assert;
import org.eclipse.tcf.protocol.IChannel;
import org.eclipse.tcf.protocol.Protocol;
import org.eclipse.tcf.te.runtime.interfaces.IConditionTester;
import org.eclipse.tcf.te.tcf.core.Tcf;
import org.eclipse.tcf.te.tcf.core.interfaces.IChannelManager;
import org.eclipse.tcf.te.tcf.locator.interfaces.nodes.ILocatorModel;
import org.eclipse.tcf.te.tcf.locator.interfaces.nodes.IPeerModel;
import org.eclipse.tcf.te.tcf.locator.interfaces.services.ILocatorModelPeerNodeQueryService;
import org.eclipse.tcf.te.tcf.locator.interfaces.services.ILocatorModelUpdateService;
import org.eclipse.tcf.te.tcf.locator.services.AbstractLocatorModelService;

public class LocatorModelPeerNodeQueryService
extends AbstractLocatorModelService
implements ILocatorModelPeerNodeQueryService {
    final Map<IPeerModel, List<DoneQueryServices>> serviceQueriesInProgress = new HashMap<IPeerModel, List<DoneQueryServices>>();

    public LocatorModelPeerNodeQueryService(ILocatorModel parentModel) {
        super(parentModel);
    }

    @Override
    public String queryLocalServices(final IPeerModel node) {
        Assert.isTrue((!Protocol.isDispatchThread() ? 1 : 0) != 0, (String)"Illegal Thread Access");
        Assert.isNotNull((Object)node);
        final AtomicReference services = new AtomicReference();
        Protocol.invokeAndWait((Runnable)new Runnable(){

            @Override
            public void run() {
                services.set(node.getStringProperty("services.local"));
            }
        });
        if (services.get() != null && !"".equals(services.get())) {
            return (String)services.get();
        }
        final AtomicBoolean completed = new AtomicBoolean(false);
        Protocol.invokeLater((Runnable)new Runnable(){

            @Override
            public void run() {
                LocatorModelPeerNodeQueryService.this.doQueryServices(node, new DoneQueryServices(){

                    @Override
                    public void doneQueryServices(Throwable error) {
                        if (error == null) {
                            services.set(node.getStringProperty("services.local"));
                        }
                        completed.set(true);
                    }
                });
            }
        });
        long startTime = System.currentTimeMillis();
        IConditionTester tester = new IConditionTester(){

            public boolean isConditionFulfilled() {
                return completed.get();
            }

            public void cleanup() {
            }
        };
        while (startTime + 1000L < System.currentTimeMillis() && !tester.isConditionFulfilled()) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        return (String)services.get();
    }

    @Override
    public String queryRemoteServices(final IPeerModel node) {
        Assert.isTrue((!Protocol.isDispatchThread() ? 1 : 0) != 0, (String)"Illegal Thread Access");
        Assert.isNotNull((Object)node);
        final AtomicReference services = new AtomicReference();
        Protocol.invokeAndWait((Runnable)new Runnable(){

            @Override
            public void run() {
                services.set(node.getStringProperty("services.remote"));
            }
        });
        if (services.get() != null && !"".equals(services.get())) {
            return (String)services.get();
        }
        final AtomicBoolean completed = new AtomicBoolean(false);
        Protocol.invokeLater((Runnable)new Runnable(){

            @Override
            public void run() {
                LocatorModelPeerNodeQueryService.this.doQueryServices(node, new DoneQueryServices(){

                    @Override
                    public void doneQueryServices(Throwable error) {
                        if (error == null) {
                            services.set(node.getStringProperty("services.remote"));
                        }
                        completed.set(true);
                    }
                });
            }
        });
        long startTime = System.currentTimeMillis();
        IConditionTester tester = new IConditionTester(){

            public boolean isConditionFulfilled() {
                return completed.get();
            }

            public void cleanup() {
            }
        };
        while (startTime + 1000L < System.currentTimeMillis() && !tester.isConditionFulfilled()) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        return (String)services.get();
    }

    protected void doQueryServices(final IPeerModel node, DoneQueryServices done) {
        Assert.isTrue((boolean)Protocol.isDispatchThread(), (String)"Illegal Thread Access");
        Assert.isNotNull((Object)node);
        Assert.isNotNull((Object)done);
        if (this.serviceQueriesInProgress.containsKey(node)) {
            List<DoneQueryServices> dones = this.serviceQueriesInProgress.get(node);
            Assert.isNotNull(dones);
            dones.add(done);
            return;
        }
        ArrayList<DoneQueryServices> dones = new ArrayList<DoneQueryServices>();
        dones.add(done);
        this.serviceQueriesInProgress.put(node, dones);
        final DoneQueryServices innerDone = new DoneQueryServices(){

            @Override
            public void doneQueryServices(Throwable error) {
                List<DoneQueryServices> dones = LocatorModelPeerNodeQueryService.this.serviceQueriesInProgress.remove(node);
                for (DoneQueryServices done : dones) {
                    done.doneQueryServices(error);
                }
            }
        };
        int state = node.getIntProperty("state");
        if (state == 3 || state == 2 || !node.isComplete()) {
            innerDone.doneQueryServices(null);
            return;
        }
        Tcf.getChannelManager().openChannel(node.getPeer(), null, new IChannelManager.DoneOpenChannel(){

            public void doneOpenChannel(Throwable error, IChannel channel) {
                if (error != null) {
                    innerDone.doneQueryServices(error);
                } else {
                    ArrayList<String> localServices = new ArrayList<String>(channel.getLocalServices());
                    ArrayList<String> remoteServices = new ArrayList<String>(channel.getRemoteServices());
                    Tcf.getChannelManager().closeChannel(channel);
                    Collections.sort(localServices);
                    Collections.sort(remoteServices);
                    ILocatorModelUpdateService updateService = node.getModel().getService(ILocatorModelUpdateService.class);
                    updateService.updatePeerServices(node, localServices, remoteServices);
                    innerDone.doneQueryServices(null);
                }
            }
        });
    }

    static interface DoneQueryServices {
        public void doneQueryServices(Throwable var1);
    }
}

