/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf.te.tcf.processes.core.callbacks;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.tcf.te.runtime.interfaces.callback.ICallback;
import org.eclipse.tcf.te.tcf.processes.core.activator.CoreBundleActivator;
import org.eclipse.tcf.te.tcf.processes.core.nls.Messages;

public class CallbackMonitor {
    private ICallback callback;
    private Map<Object, IStatus> locks;

    public CallbackMonitor(ICallback callback) {
        Assert.isNotNull((Object)callback);
        this.callback = callback;
        this.locks = Collections.synchronizedMap(new HashMap());
    }

    public CallbackMonitor(ICallback callback, Object ... keys) {
        Assert.isNotNull((Object)callback);
        this.callback = callback;
        this.locks = Collections.synchronizedMap(new HashMap());
        Object[] objectArray = keys;
        int n = keys.length;
        int n2 = 0;
        while (n2 < n) {
            Object key = objectArray[n2];
            this.locks.put(key, null);
            ++n2;
        }
    }

    public synchronized void lock(Object ... keys) {
        Object[] objectArray = keys;
        int n = keys.length;
        int n2 = 0;
        while (n2 < n) {
            Object key = objectArray[n2];
            this.locks.put(key, null);
            ++n2;
        }
    }

    public synchronized void lock(Object key) {
        Assert.isNotNull((Object)key);
        this.locks.put(key, null);
    }

    public synchronized void unlock(Object key, IStatus status) {
        Assert.isNotNull((Object)key);
        Assert.isNotNull((Object)status);
        this.locks.put(key, status);
        IStatus current = this.getCurrentStatus();
        if (current != null) {
            this.callback.done((Object)this, current);
        }
    }

    private synchronized IStatus getCurrentStatus() {
        ArrayList<IStatus> list = new ArrayList<IStatus>();
        for (Map.Entry<Object, IStatus> entry : this.locks.entrySet()) {
            IStatus status = entry.getValue();
            if (status == null) {
                return null;
            }
            list.add(status);
        }
        IStatus[] children = list.toArray(new IStatus[list.size()]);
        return new MultiStatus(CoreBundleActivator.getUniqueIdentifier(), 0, children, Messages.CallbackMonitor_AllTasksFinished, null);
    }
}

