/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf.te.tcf.ui.views.scriptpad;

import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.action.GroupMarker;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.custom.CaretEvent;
import org.eclipse.swt.custom.CaretListener;
import org.eclipse.swt.custom.LineStyleListener;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.dnd.DropTarget;
import org.eclipse.swt.dnd.DropTargetAdapter;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.FileTransfer;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.tcf.te.runtime.interfaces.properties.IPropertiesContainer;
import org.eclipse.tcf.te.runtime.properties.PropertiesContainer;
import org.eclipse.tcf.te.runtime.statushandler.StatusHandlerManager;
import org.eclipse.tcf.te.runtime.statushandler.interfaces.IStatusHandler;
import org.eclipse.tcf.te.tcf.locator.interfaces.nodes.IPeerModel;
import org.eclipse.tcf.te.tcf.ui.views.activator.UIPlugin;
import org.eclipse.tcf.te.tcf.ui.views.help.IContextHelpIds;
import org.eclipse.tcf.te.tcf.ui.views.nls.Messages;
import org.eclipse.tcf.te.tcf.ui.views.scriptpad.ScriptPadLineStyleListener;
import org.eclipse.tcf.te.tcf.ui.views.scriptpad.actions.CopyAction;
import org.eclipse.tcf.te.tcf.ui.views.scriptpad.actions.CutAction;
import org.eclipse.tcf.te.tcf.ui.views.scriptpad.actions.DeleteAction;
import org.eclipse.tcf.te.tcf.ui.views.scriptpad.actions.PasteAction;
import org.eclipse.tcf.te.tcf.ui.views.scriptpad.actions.PeerAction;
import org.eclipse.tcf.te.tcf.ui.views.scriptpad.actions.SelectAllAction;
import org.eclipse.tcf.te.ui.swt.DisplayUtil;
import org.eclipse.tcf.te.ui.swt.SWTControlUtil;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.ISaveablePart;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.part.ViewPart;

public class ScriptPad
extends ViewPart
implements ISelectionProvider,
SelectionListener,
ISaveablePart {
    private Label head;
    StyledText text;
    private ScriptPadLineStyleListener lineStyleListener;
    private final List<ISelectionChangedListener> listeners = new ArrayList<ISelectionChangedListener>();
    IPeerModel peerModel;
    private CutAction cutHandler;
    private CopyAction copyHandler;
    private PasteAction pasteHandler;
    DeleteAction deleteHandler;
    private SelectAllAction selectAllHandler;
    private String fileLoaded = null;
    private boolean dirty = false;

    public ScriptPad() {
        this.listeners.clear();
    }

    public void dispose() {
        if (this.text != null && !this.text.isDisposed()) {
            this.text.removeSelectionListener((SelectionListener)this);
            if (this.lineStyleListener != null) {
                this.text.removeLineStyleListener((LineStyleListener)this.lineStyleListener);
                this.lineStyleListener.dispose();
                this.lineStyleListener = null;
            }
        }
        this.listeners.clear();
        this.fileLoaded = null;
        super.dispose();
    }

    public void createPartControl(Composite parent) {
        Composite panel = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        panel.setLayout((Layout)layout);
        panel.setLayoutData((Object)new GridData(4, 4, true, true));
        this.head = new Label(panel, 256);
        this.head.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.text = new StyledText(panel, 67586);
        this.text.setLayoutData((Object)new GridData(4, 4, true, true));
        this.text.setFont(JFaceResources.getTextFont());
        this.text.addSelectionListener((SelectionListener)this);
        this.text.addCaretListener(new CaretListener(){

            public void caretMoved(CaretEvent event) {
                if (ScriptPad.this.deleteHandler != null) {
                    ScriptPad.this.deleteHandler.updateEnabledState();
                }
            }
        });
        this.text.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                if (!ScriptPad.this.isDirty()) {
                    ScriptPad.this.markDirty(true);
                }
            }
        });
        this.lineStyleListener = new ScriptPadLineStyleListener();
        this.text.addLineStyleListener((LineStyleListener)this.lineStyleListener);
        this.getViewSite().setSelectionProvider((ISelectionProvider)this);
        this.createContextMenu();
        this.createToolbar();
        this.hookGlobalActions();
        this.setupDnD();
        this.getViewSite().getActionBars().updateActionBars();
    }

    private void createContextMenu() {
        MenuManager menuMgr = new MenuManager();
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager mgr) {
                ScriptPad.this.fillContextMenu(mgr);
            }
        });
        Menu menu = menuMgr.createContextMenu((Control)this.text);
        this.text.setMenu(menu);
        this.getSite().registerContextMenu(menuMgr, (ISelectionProvider)this);
    }

    protected void fillContextMenu(IMenuManager manager) {
        Assert.isNotNull((Object)manager);
    }

    protected void hookGlobalActions() {
        IActionBars actionBars = this.getViewSite().getActionBars();
        this.cutHandler = new CutAction(this);
        actionBars.setGlobalActionHandler(ActionFactory.CUT.getId(), (IAction)this.cutHandler);
        this.copyHandler = new CopyAction(this);
        actionBars.setGlobalActionHandler(ActionFactory.COPY.getId(), (IAction)this.copyHandler);
        this.pasteHandler = new PasteAction(this);
        actionBars.setGlobalActionHandler(ActionFactory.PASTE.getId(), (IAction)this.pasteHandler);
        this.deleteHandler = new DeleteAction(this);
        actionBars.setGlobalActionHandler(ActionFactory.DELETE.getId(), (IAction)this.deleteHandler);
        this.selectAllHandler = new SelectAllAction(this);
        actionBars.setGlobalActionHandler(ActionFactory.SELECT_ALL.getId(), (IAction)this.selectAllHandler);
        this.updateActionEnablements();
    }

    private void createToolbar() {
        IToolBarManager manager = this.getViewSite().getActionBars().getToolBarManager();
        manager.add((IContributionItem)new Separator());
        manager.add((IContributionItem)new GroupMarker("open"));
        manager.add((IContributionItem)new GroupMarker("save"));
        manager.add((IContributionItem)new Separator());
        manager.add((IContributionItem)new GroupMarker("clear"));
        manager.add((IContributionItem)new Separator());
        manager.add((IContributionItem)new GroupMarker("play"));
        manager.add((IContributionItem)new Separator());
        manager.add((IContributionItem)new GroupMarker("peers"));
        manager.add((IContributionItem)new Separator("additions"));
    }

    private void setupDnD() {
        DropTarget target = new DropTarget((Control)this.text, 17);
        target.setTransfer(new Transfer[]{TextTransfer.getInstance(), FileTransfer.getInstance()});
        target.addDropListener((DropTargetListener)new DropTargetAdapter(){

            public void drop(DropTargetEvent event) {
                String content;
                if (FileTransfer.getInstance().isSupportedType(event.currentDataType)) {
                    String[] names = (String[])FileTransfer.getInstance().nativeToJava(event.currentDataType);
                    if (names != null && names.length > 0) {
                        ScriptPad.this.openFile(names[0]);
                    }
                } else if (TextTransfer.getInstance().isSupportedType(event.currentDataType) && (content = (String)TextTransfer.getInstance().nativeToJava(event.currentDataType)) != null && !"".equals(content) && ScriptPad.this.text != null && !ScriptPad.this.text.isDisposed()) {
                    ScriptPad.this.text.setText(content);
                }
            }

            public void dragOperationChanged(DropTargetEvent event) {
                if (event.detail == 16) {
                    event.detail = 1;
                }
            }

            public void dragEnter(DropTargetEvent event) {
                if (event.detail == 16) {
                    event.detail = 1;
                }
            }
        });
    }

    public void setFocus() {
        if (this.text != null) {
            this.text.setFocus();
        }
    }

    public void addSelectionChangedListener(ISelectionChangedListener listener) {
        Assert.isNotNull((Object)listener);
        if (!this.listeners.contains(listener)) {
            this.listeners.add(listener);
        }
    }

    public void removeSelectionChangedListener(ISelectionChangedListener listener) {
        Assert.isNotNull((Object)listener);
        this.listeners.remove(listener);
    }

    public ISelection getSelection() {
        String selected = this.text.getSelectionText();
        return selected != null ? new StructuredSelection((Object)selected) : null;
    }

    public void setSelection(ISelection selection) {
        if (selection instanceof IStructuredSelection && !selection.isEmpty()) {
            int start;
            Object element = ((IStructuredSelection)selection).getFirstElement();
            if (element instanceof String && (start = this.text.getText().indexOf((String)element)) != -1) {
                this.text.setSelection(start, start + ((String)element).length());
            }
        } else {
            this.text.setSelection(this.text.getCaretOffset(), this.text.getCaretOffset());
        }
        this.fireSelectionChanged();
        this.updateActionEnablements();
    }

    private void fireSelectionChanged() {
        if (this.getSelection() == null) {
            return;
        }
        SelectionChangedEvent event = new SelectionChangedEvent((ISelectionProvider)this, this.getSelection());
        for (ISelectionChangedListener listener : this.listeners) {
            listener.selectionChanged(event);
        }
    }

    public void updateActionEnablements() {
        if (this.cutHandler != null) {
            this.cutHandler.updateEnabledState();
        }
        if (this.copyHandler != null) {
            this.copyHandler.updateEnabledState();
        }
        if (this.pasteHandler != null) {
            this.pasteHandler.updateEnabledState();
        }
        if (this.deleteHandler != null) {
            this.deleteHandler.updateEnabledState();
        }
        if (this.selectAllHandler != null) {
            this.selectAllHandler.updateEnabledState();
        }
    }

    protected void updateHeadLabel() {
        StringBuilder label = new StringBuilder();
        if (this.fileLoaded == null) {
            label.append("<no file>");
        } else {
            Path path = new Path(this.fileLoaded);
            label.append(path.lastSegment());
        }
        label.append(" - ");
        if (this.peerModel == null) {
            label.append("<no peer>");
        } else {
            PeerAction action = new PeerAction((IViewPart)this, this.peerModel);
            label.append(action.getText());
        }
        SWTControlUtil.setText((Control)this.head, (String)label.toString());
    }

    public void widgetDefaultSelected(SelectionEvent e) {
    }

    public void widgetSelected(SelectionEvent e) {
        this.fireSelectionChanged();
        this.updateActionEnablements();
    }

    public void setPeerModel(IPeerModel peerModel) {
        this.peerModel = peerModel;
        this.updateHeadLabel();
        this.getViewSite().getActionBars().updateActionBars();
        DisplayUtil.safeAsyncExec((Runnable)new Runnable(){

            @Override
            public void run() {
                ScriptPad.this.firePropertyChange(258);
            }
        });
    }

    public IPeerModel getPeerModel() {
        return this.peerModel;
    }

    public StyledText getStyledText() {
        return this.text;
    }

    public void markDirty(boolean dirty) {
        if (this.dirty != dirty) {
            this.dirty = dirty;
            this.firePropertyChange(257);
        }
    }

    public boolean isDirty() {
        return this.dirty;
    }

    public void doSave(IProgressMonitor monitor) {
        if (this.fileLoaded != null) {
            this.saveFile(this.fileLoaded);
        } else {
            this.doSaveAs();
        }
    }

    public void doSaveAs() {
        FileDialog dialog = new FileDialog(this.getViewSite().getShell(), 8192);
        dialog.setFilterExtensions(new String[]{"*.tcf", "*"});
        dialog.setFilterPath(this.fileLoaded != null ? this.fileLoaded : System.getProperty("user.home"));
        String file = dialog.open();
        if (file != null) {
            this.saveFile(file);
            if (!this.isDirty()) {
                this.fileLoaded = file;
                this.updateHeadLabel();
            }
        }
    }

    public boolean isSaveAsAllowed() {
        return true;
    }

    public boolean isSaveOnCloseNeeded() {
        return this.isDirty();
    }

    public void clear() {
        this.fileLoaded = null;
        this.updateHeadLabel();
        if (this.text != null && !this.text.isDisposed()) {
            this.text.setText("");
        }
    }

    public void openFile(String file) {
        block18: {
            Assert.isNotNull((Object)file);
            File f = new File(file);
            if (f.isAbsolute() && f.isFile() && f.canRead()) {
                this.fileLoaded = file;
                this.updateHeadLabel();
                this.text.setText("");
                FileReader reader = null;
                try {
                    try {
                        int c;
                        reader = new FileReader(f);
                        StringBuilder buffer = new StringBuilder();
                        while ((c = reader.read()) != -1) {
                            buffer.append((char)c);
                        }
                        this.text.setText(buffer.toString());
                        this.markDirty(false);
                    }
                    catch (IOException e) {
                        Status status = new Status(4, UIPlugin.getUniqueIdentifier(), NLS.bind((String)Messages.ScriptPad_error_openFile, (Object)file, (Object)e.getLocalizedMessage()), (Throwable)e);
                        IStatusHandler[] handlers = StatusHandlerManager.getInstance().getHandler((Object)this);
                        if (handlers.length > 0) {
                            PropertiesContainer data = new PropertiesContainer();
                            data.setProperty("title", (Object)Messages.ScriptPad_error_title);
                            data.setProperty("contextHelpId", (Object)IContextHelpIds.SCRIPT_PAD_ERROR_OPEN_FILE);
                            data.setProperty("caller", (Object)this);
                            handlers[0].handleStatus((IStatus)status, (IPropertiesContainer)data, null);
                        } else {
                            UIPlugin.getDefault().getLog().log((IStatus)status);
                        }
                        if (reader != null) {
                            try {
                                reader.close();
                            }
                            catch (IOException iOException) {}
                        }
                        break block18;
                    }
                }
                catch (Throwable throwable) {
                    if (reader != null) {
                        try {
                            reader.close();
                        }
                        catch (IOException iOException) {}
                    }
                    throw throwable;
                }
                if (reader != null) {
                    try {
                        reader.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
        this.updateActionEnablements();
    }

    public void saveFile(String file) {
        block17: {
            Assert.isNotNull((Object)file);
            File f = new File(file);
            if (f.isAbsolute() && (f.exists() && f.isFile() && f.canWrite() || !f.exists())) {
                String content = this.text.getText();
                FileWriter writer = null;
                try {
                    try {
                        writer = new FileWriter(f);
                        writer.write(content);
                        this.markDirty(false);
                    }
                    catch (Exception e) {
                        Status status = new Status(4, UIPlugin.getUniqueIdentifier(), NLS.bind((String)Messages.ScriptPad_error_saveFile, (Object)file, (Object)e.getLocalizedMessage()), (Throwable)e);
                        IStatusHandler[] handlers = StatusHandlerManager.getInstance().getHandler((Object)this);
                        if (handlers.length > 0) {
                            PropertiesContainer data = new PropertiesContainer();
                            data.setProperty("title", (Object)Messages.ScriptPad_error_title);
                            data.setProperty("contextHelpId", (Object)IContextHelpIds.SCRIPT_PAD_ERROR_OPEN_FILE);
                            data.setProperty("caller", (Object)this);
                            handlers[0].handleStatus((IStatus)status, (IPropertiesContainer)data, null);
                        } else {
                            UIPlugin.getDefault().getLog().log((IStatus)status);
                        }
                        if (writer != null) {
                            try {
                                writer.close();
                            }
                            catch (IOException iOException) {}
                        }
                        break block17;
                    }
                }
                catch (Throwable throwable) {
                    if (writer != null) {
                        try {
                            writer.close();
                        }
                        catch (IOException iOException) {}
                    }
                    throw throwable;
                }
                if (writer != null) {
                    try {
                        writer.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
        this.updateActionEnablements();
    }
}

