/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf.te.tcf.ui.editor.sections;

import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import org.eclipse.core.runtime.Assert;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.tcf.protocol.Protocol;
import org.eclipse.tcf.te.runtime.interfaces.properties.IPropertiesContainer;
import org.eclipse.tcf.te.runtime.properties.PropertiesContainer;
import org.eclipse.tcf.te.tcf.locator.interfaces.nodes.IPeerModel;
import org.eclipse.tcf.te.tcf.locator.interfaces.services.ILocatorModelPeerNodeQueryService;
import org.eclipse.tcf.te.tcf.ui.nls.Messages;
import org.eclipse.tcf.te.ui.forms.parts.AbstractSection;
import org.eclipse.tcf.te.ui.swt.SWTControlUtil;
import org.eclipse.tcf.te.ui.views.editor.pages.AbstractEditorPage;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Section;

public class ServicesSection
extends AbstractSection {
    private Text local;
    private Text remote;
    IPeerModel od;
    final IPropertiesContainer odc = new PropertiesContainer();

    public ServicesSection(IManagedForm form, Composite parent) {
        super(form, parent, 130);
        this.createClient(this.getSection(), form.getToolkit());
    }

    protected void createClient(Section section, FormToolkit toolkit) {
        Assert.isNotNull((Object)section);
        Assert.isNotNull((Object)toolkit);
        section.setText(Messages.ServicesSection_title);
        section.setDescription(Messages.ServicesSection_description);
        section.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        Composite client = this.createClientContainer((Composite)section, 1, toolkit);
        Assert.isNotNull((Object)client);
        section.setClient((Control)client);
        Group group = new Group(client, 0);
        group.setText(Messages.ServicesSection_group_local_title);
        group.setLayout((Layout)new GridLayout());
        group.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.local = new Text((Composite)group, 74);
        GridData layoutData = new GridData(4, 0x1000000, true, false);
        layoutData.widthHint = SWTControlUtil.convertWidthInCharsToPixels((Control)this.local, (int)20);
        layoutData.heightHint = SWTControlUtil.convertHeightInCharsToPixels((Control)this.local, (int)5);
        this.local.setLayoutData((Object)layoutData);
        group = new Group(client, 0);
        group.setText(Messages.ServicesSection_group_remote_title);
        group.setLayout((Layout)new GridLayout());
        group.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.remote = new Text((Composite)group, 74);
        layoutData = new GridData(4, 0x1000000, true, false);
        layoutData.widthHint = SWTControlUtil.convertWidthInCharsToPixels((Control)this.local, (int)20);
        layoutData.heightHint = SWTControlUtil.convertHeightInCharsToPixels((Control)this.remote, (int)5);
        this.remote.setLayoutData((Object)layoutData);
        this.setIsUpdating(false);
    }

    public void setActive(boolean active) {
        Object node;
        if (active && this.getManagedForm().getContainer() instanceof AbstractEditorPage && !((AbstractEditorPage)this.getManagedForm().getContainer()).isDirty() && (node = ((AbstractEditorPage)this.getManagedForm().getContainer()).getEditorInputNode()) instanceof IPeerModel) {
            this.setupData((IPeerModel)node);
        }
    }

    public void setupData(final IPeerModel node) {
        this.od = node;
        this.odc.clearProperties();
        if (node == null) {
            return;
        }
        final AtomicBoolean needQueryServices = new AtomicBoolean();
        Protocol.invokeAndWait((Runnable)new Runnable(){

            @Override
            public void run() {
                needQueryServices.set(node.getStringProperty("services.local") != null || node.getStringProperty("services.remote") != null);
            }
        });
        if (needQueryServices.get()) {
            ((ILocatorModelPeerNodeQueryService)node.getModel().getService(ILocatorModelPeerNodeQueryService.class)).queryLocalServices(node);
        }
        Protocol.invokeAndWait((Runnable)new Runnable(){

            @Override
            public void run() {
                Map properties = ServicesSection.this.od.getProperties();
                ServicesSection.this.odc.setProperties(properties);
            }
        });
        boolean fireRefreshTabs = needQueryServices.get();
        String value = this.odc.getStringProperty("services.local");
        fireRefreshTabs |= value != null && !value.equals(SWTControlUtil.getText((Control)this.local));
        SWTControlUtil.setText((Control)this.local, (String)(value != null ? value : ""));
        value = this.odc.getStringProperty("services.remote");
        boolean bl = value != null && !value.equals(SWTControlUtil.getText((Control)this.remote));
        SWTControlUtil.setText((Control)this.remote, (String)(value != null ? value : ""));
        if (fireRefreshTabs |= bl) {
            this.od.fireChangeEvent("editor.refreshTab", (Object)Boolean.FALSE, (Object)Boolean.TRUE);
        }
    }
}

