/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf.te.ui.controls;

import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.PlatformObject;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.tcf.te.ui.jface.interfaces.IValidatable;

public class BaseControl
extends PlatformObject
implements IValidatable {
    private Composite parentControl;
    private String message = null;
    private int messageType = 0;
    private boolean enabled = true;

    public final boolean isControlCreated() {
        return this.parentControl != null;
    }

    public final Composite getParentControl() {
        return this.parentControl;
    }

    public void dispose() {
        this.parentControl = null;
    }

    public void setupPanel(Composite parent) {
        Assert.isNotNull((Object)parent);
        this.parentControl = parent;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public final boolean isEnabled() {
        return this.enabled;
    }

    public boolean isValid() {
        this.setMessage(null, 0);
        return true;
    }

    protected final boolean isSubControlValid(BaseControl subControl, boolean currentValidationState) {
        if (subControl == null) {
            return currentValidationState;
        }
        currentValidationState &= subControl.isValid();
        if (subControl.getMessageType() > this.getMessageType()) {
            this.setMessage(subControl.getMessage(), subControl.getMessageType());
        }
        return currentValidationState;
    }

    public final String getMessage() {
        return this.message;
    }

    public final int getMessageType() {
        return this.messageType;
    }

    protected final void setMessage(String message, int messageType) {
        if (message == null && this.getDefaultMessage() != null) {
            message = this.getDefaultMessage();
            messageType = this.getDefaultMessageType();
        }
        this.message = message;
        this.messageType = messageType;
    }

    public String getDefaultMessage() {
        return null;
    }

    public int getDefaultMessageType() {
        return 1;
    }

    public final String prefixDialogSettingsSlotId(String settingsSlotId, String prefix) {
        if (settingsSlotId != null && prefix != null && prefix.trim().length() > 0) {
            settingsSlotId = String.valueOf(prefix) + "." + settingsSlotId;
        }
        return settingsSlotId;
    }

    protected IDialogSettings doGetParentSection(IDialogSettings settings) {
        Assert.isNotNull((Object)settings);
        return settings;
    }

    public final void restoreWidgetValues(IDialogSettings settings, String idPrefix) {
        Assert.isNotNull((Object)settings);
        IDialogSettings parentSection = this.doGetParentSection(settings);
        Assert.isNotNull((Object)parentSection);
        IDialogSettings section = parentSection.getSection(((Object)((Object)this)).getClass().getName());
        if (section == null) {
            section = parentSection.addNewSection(((Object)((Object)this)).getClass().getName());
        }
        this.doRestoreWidgetValues(section, idPrefix);
    }

    public void doRestoreWidgetValues(IDialogSettings settings, String idPrefix) {
        Assert.isNotNull((Object)settings);
    }

    public final void saveWidgetValues(IDialogSettings settings, String idPrefix) {
        Assert.isNotNull((Object)settings);
        IDialogSettings parentSection = this.doGetParentSection(settings);
        Assert.isNotNull((Object)parentSection);
        IDialogSettings section = parentSection.getSection(((Object)((Object)this)).getClass().getName());
        if (section == null) {
            section = parentSection.addNewSection(((Object)((Object)this)).getClass().getName());
        }
        this.doSaveWidgetValues(section, idPrefix);
    }

    public void doSaveWidgetValues(IDialogSettings settings, String idPrefix) {
        Assert.isNotNull((Object)settings);
    }
}

