/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf.te.ui.controls;

import java.util.Hashtable;
import java.util.Map;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.dialogs.IDialogPage;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.swt.custom.StackLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.tcf.te.ui.controls.BaseDialogPageControl;
import org.eclipse.tcf.te.ui.controls.interfaces.IWizardConfigurationPanel;
import org.eclipse.ui.forms.widgets.FormToolkit;

public class BaseWizardConfigurationPanelControl
extends BaseDialogPageControl {
    private final Map<String, IWizardConfigurationPanel> configurationPanels = new Hashtable<String, IWizardConfigurationPanel>();
    private boolean isGroup;
    private Composite panel;
    private StackLayout panelLayout;

    public BaseWizardConfigurationPanelControl(IDialogPage parentPage) {
        super(parentPage);
        this.clear();
        this.setPanelIsGroup(false);
    }

    public void setPanelIsGroup(boolean isGroup) {
        this.isGroup = isGroup;
    }

    public boolean isPanelIsGroup() {
        return this.isGroup;
    }

    public Composite getPanel() {
        return this.panel;
    }

    public String getGroupLabel() {
        return null;
    }

    public void setupPanel(Composite parent, String[] configurationPanelKeys, FormToolkit toolkit) {
        Assert.isNotNull((Object)parent);
        Assert.isNotNull((Object)toolkit);
        if (this.isPanelIsGroup()) {
            this.panel = new Group(parent, 0);
            if (this.getGroupLabel() != null) {
                ((Group)this.panel).setText(this.getGroupLabel());
            }
        } else {
            this.panel = new Composite(parent, 0);
        }
        Assert.isNotNull((Object)this.panel);
        this.panel.setFont(parent.getFont());
        this.panel.setBackground(parent.getBackground());
        this.panelLayout = new StackLayout();
        this.panel.setLayout((Layout)this.panelLayout);
        this.setupConfigurationPanels(this.panel, configurationPanelKeys, toolkit);
    }

    public void clear() {
        this.configurationPanels.clear();
    }

    public String[] getConfigurationPanelIds() {
        return this.configurationPanels.keySet().toArray(new String[this.configurationPanels.keySet().size()]);
    }

    public IWizardConfigurationPanel getConfigurationPanel(String key) {
        if (key == null) {
            return null;
        }
        return this.configurationPanels.get(key);
    }

    public void addConfigurationPanel(String key, IWizardConfigurationPanel panel) {
        if (key == null) {
            return;
        }
        if (panel != null) {
            this.configurationPanels.put(key, panel);
        } else {
            this.configurationPanels.remove(key);
        }
    }

    public void setupConfigurationPanels(Composite parent, String[] configurationPanelKeys, FormToolkit toolkit) {
        Assert.isNotNull((Object)parent);
        Assert.isNotNull((Object)toolkit);
        if (configurationPanelKeys != null) {
            int i = 0;
            while (i < configurationPanelKeys.length) {
                IWizardConfigurationPanel configPanel = this.getConfigurationPanel(configurationPanelKeys[i]);
                if (configPanel != null) {
                    configPanel.setupPanel(parent, toolkit);
                }
                ++i;
            }
        }
    }

    public void showConfigurationPanel(String key) {
        if (key == null) {
            return;
        }
        IWizardConfigurationPanel configPanel = this.getConfigurationPanel(key);
        if (configPanel != null && configPanel.getControl() != null) {
            this.panelLayout.topControl = configPanel.getControl();
            this.panel.layout();
        }
    }

    @Override
    public void doSaveWidgetValues(IDialogSettings settings, String idPrefix) {
        super.doSaveWidgetValues(settings, idPrefix);
        if (settings != null) {
            for (String key : this.configurationPanels.keySet()) {
                IWizardConfigurationPanel configPanel = this.getConfigurationPanel(key);
                if (configPanel == null) continue;
                IDialogSettings configPanelSettings = settings.getSection(key);
                if (configPanelSettings == null) {
                    configPanelSettings = settings.addNewSection(key);
                }
                configPanel.doSaveWidgetValues(configPanelSettings, idPrefix);
            }
        }
    }

    @Override
    public void doRestoreWidgetValues(IDialogSettings settings, String idPrefix) {
        super.doRestoreWidgetValues(settings, idPrefix);
        if (settings != null) {
            for (String key : this.configurationPanels.keySet()) {
                IWizardConfigurationPanel configPanel = this.getConfigurationPanel(key);
                if (configPanel == null) continue;
                IDialogSettings configPanelSettings = settings.getSection(key);
                if (configPanelSettings == null) {
                    configPanelSettings = settings.addNewSection(key);
                }
                configPanel.doRestoreWidgetValues(configPanelSettings, idPrefix);
            }
        }
    }
}

