/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf.te.ui.terminals.internal.dialogs;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.dialogs.IDialogPage;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.TypedEvent;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.tcf.te.runtime.interfaces.properties.IPropertiesContainer;
import org.eclipse.tcf.te.runtime.properties.PropertiesContainer;
import org.eclipse.tcf.te.ui.controls.BaseDialogPageControl;
import org.eclipse.tcf.te.ui.controls.BaseWizardConfigurationPanelControl;
import org.eclipse.tcf.te.ui.controls.interfaces.IWizardConfigurationPanel;
import org.eclipse.tcf.te.ui.interfaces.data.IDataExchangeNode;
import org.eclipse.tcf.te.ui.jface.dialogs.CustomTrayDialog;
import org.eclipse.tcf.te.ui.swt.SWTControlUtil;
import org.eclipse.tcf.te.ui.terminals.help.IContextHelpIds;
import org.eclipse.tcf.te.ui.terminals.interfaces.IConfigurationPanel;
import org.eclipse.tcf.te.ui.terminals.interfaces.ILauncherDelegate;
import org.eclipse.tcf.te.ui.terminals.launcher.LauncherDelegateManager;
import org.eclipse.tcf.te.ui.terminals.nls.Messages;
import org.eclipse.tcf.te.ui.terminals.panels.AbstractConfigurationPanel;
import org.eclipse.ui.forms.widgets.FormToolkit;

public class LaunchTerminalSettingsDialog
extends CustomTrayDialog {
    private ISelection selection = null;
    Combo terminals;
    SettingsPanelControl settings;
    private final Map<String, ILauncherDelegate> label2delegate = new HashMap<String, ILauncherDelegate>();
    private IPropertiesContainer data = null;

    public LaunchTerminalSettingsDialog(Shell shell) {
        super(shell, IContextHelpIds.LAUNCH_TERMINAL_SETTINGS_DIALOG);
    }

    public void setSelection(ISelection selection) {
        this.selection = selection;
    }

    public ISelection getSelection() {
        return this.selection;
    }

    protected void dispose() {
        if (this.settings != null) {
            this.settings.dispose();
            this.settings = null;
        }
        super.dispose();
    }

    protected Control createDialogArea(Composite parent) {
        this.setDialogTitle(Messages.LaunchTerminalSettingsDialog_title);
        Composite composite = (Composite)super.createDialogArea(parent);
        Composite panel = new Composite(composite, 0);
        GridLayout layout = new GridLayout(2, false);
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        panel.setLayout((Layout)layout);
        panel.setLayoutData((Object)new GridData(4, 0x1000000, true, true));
        Label label = new Label(panel, 256);
        label.setText(Messages.LaunchTerminalSettingsDialog_combo_label);
        this.terminals = new Combo(panel, 8);
        this.terminals.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.terminals.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                LaunchTerminalSettingsDialog.this.settings.showConfigurationPanel(LaunchTerminalSettingsDialog.this.terminals.getText());
            }
        });
        this.fillCombo(this.terminals);
        this.settings = new SettingsPanelControl(null);
        String[] stringArray = this.terminals.getItems();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String terminalLabel = stringArray[n2];
            ILauncherDelegate delegate = this.label2delegate.get(terminalLabel);
            Assert.isNotNull((Object)delegate);
            IConfigurationPanel configPanel = delegate.getPanel((BaseDialogPageControl)this.settings);
            if (configPanel == null) {
                configPanel = new EmptySettingsPanel((BaseDialogPageControl)this.settings);
            }
            Assert.isNotNull((Object)configPanel);
            configPanel.setSelection(this.getSelection());
            this.settings.addConfigurationPanel(terminalLabel, configPanel);
            ++n2;
        }
        this.settings.setupPanel(panel, this.terminals.getItems(), new FormToolkit(panel.getDisplay()));
        GridData layoutData = new GridData(4, 4, true, true);
        layoutData.horizontalSpan = 2;
        this.settings.getPanel().setLayoutData((Object)layoutData);
        this.terminals.select(0);
        this.settings.showConfigurationPanel(this.terminals.getText());
        SWTControlUtil.setEnabled((Control)this.terminals, (this.terminals.getItemCount() > 1 ? 1 : 0) != 0);
        this.restoreWidgetValues();
        LaunchTerminalSettingsDialog.applyDialogFont((Control)composite);
        return composite;
    }

    protected void fillCombo(Combo combo) {
        Assert.isNotNull((Object)combo);
        ArrayList<String> items = new ArrayList<String>();
        if (this.selection == null || this.selection.isEmpty()) {
            ILauncherDelegate[] delegates;
            ILauncherDelegate[] iLauncherDelegateArray = delegates = LauncherDelegateManager.getInstance().getLauncherDelegates(true);
            int n = delegates.length;
            int n2 = 0;
            while (n2 < n) {
                ILauncherDelegate delegate = iLauncherDelegateArray[n2];
                String label = delegate.getLabel();
                String id = delegate.getId();
                if (!id.equals("org.eclipse.tcf.te.ui.terminals.launcher.tcf")) {
                    if (label == null || "".equals(label.trim())) {
                        label = delegate.getId();
                    }
                    this.label2delegate.put(label, delegate);
                    items.add(label);
                }
                ++n2;
            }
        } else {
            ILauncherDelegate[] delegates;
            ILauncherDelegate[] iLauncherDelegateArray = delegates = LauncherDelegateManager.getInstance().getApplicableLauncherDelegates(this.selection);
            int n = delegates.length;
            int n3 = 0;
            while (n3 < n) {
                ILauncherDelegate delegate = iLauncherDelegateArray[n3];
                String label = delegate.getLabel();
                if (label == null || "".equals(label.trim())) {
                    label = delegate.getId();
                }
                this.label2delegate.put(label, delegate);
                items.add(label);
                ++n3;
            }
        }
        Collections.sort(items);
        combo.setItems(items.toArray(new String[items.size()]));
    }

    protected void saveWidgetValues() {
        IDialogSettings settings = this.getDialogSettings();
        if (settings != null) {
            settings.put("terminalLabel", SWTControlUtil.getText((Control)this.terminals));
            this.settings.saveWidgetValues(settings, null);
        }
    }

    protected void restoreWidgetValues() {
        IDialogSettings settings = this.getDialogSettings();
        if (settings != null) {
            int index;
            String terminalLabel = settings.get("terminalLabel");
            int n = index = terminalLabel != null ? Arrays.asList(this.terminals.getItems()).indexOf(terminalLabel) : -1;
            if (index != -1) {
                this.terminals.select(index);
                this.settings.showConfigurationPanel(this.terminals.getText());
            }
            this.settings.restoreWidgetValues(settings, null);
        }
    }

    protected void okPressed() {
        IWizardConfigurationPanel panel = this.settings.getConfigurationPanel(this.terminals.getText());
        if (!panel.isValid()) {
            String strTitle = Messages.LaunchTerminalSettingsDialog_error_title;
            MessageBox mb = new MessageBox(this.getShell(), 33);
            mb.setText(strTitle);
            mb.setMessage(Messages.LaunchTerminalSettingsDialog_error_invalidSettings);
            mb.open();
            return;
        }
        this.data = new PropertiesContainer();
        this.data.setProperty("delegateId", (Object)this.label2delegate.get(this.terminals.getText()).getId());
        this.data.setProperty("selection", (Object)this.selection);
        if (panel instanceof IDataExchangeNode) {
            ((IDataExchangeNode)panel).extractData(this.data);
        }
        super.okPressed();
    }

    public IPropertiesContainer getSettings() {
        return this.data;
    }

    protected class EmptySettingsPanel
    extends AbstractConfigurationPanel {
        Text fHostText;

        public EmptySettingsPanel(BaseDialogPageControl parentControl) {
            super(parentControl);
        }

        public void setupPanel(Composite parent, FormToolkit toolkit) {
            Composite panel = new Composite(parent, 0);
            panel.setLayout((Layout)new GridLayout());
            panel.setLayoutData((Object)new GridData(4, 4, true, true));
            Label label = new Label(panel, 256);
            GridData layoutData = new GridData(4, 4, true, true);
            layoutData.widthHint = LaunchTerminalSettingsDialog.this.convertWidthInCharsToPixels(30);
            layoutData.heightHint = LaunchTerminalSettingsDialog.this.convertHeightInCharsToPixels(5);
            label.setLayoutData((Object)layoutData);
            this.setControl(panel);
        }

        public boolean dataChanged(IPropertiesContainer data, TypedEvent e) {
            return false;
        }

        @Override
        protected void saveSettingsForHost(boolean add) {
        }

        @Override
        protected void fillSettingsForHost(String host) {
        }

        @Override
        protected String getHostFromSettings() {
            return null;
        }

        @Override
        public void doRestoreWidgetValues(IDialogSettings settings, String idPrefix) {
        }

        @Override
        public void doSaveWidgetValues(IDialogSettings settings, String idPrefix) {
        }
    }

    protected class SettingsPanelControl
    extends BaseWizardConfigurationPanelControl {
        public SettingsPanelControl(IDialogPage parentPage) {
            super(parentPage);
            this.setPanelIsGroup(true);
        }

        public String getGroupLabel() {
            return Messages.LaunchTerminalSettingsDialog_group_label;
        }
    }
}

