/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf.te.ui.terminals.internal.handler;

import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.tcf.te.runtime.interfaces.properties.IPropertiesContainer;
import org.eclipse.tcf.te.runtime.properties.PropertiesContainer;
import org.eclipse.tcf.te.ui.terminals.interfaces.ILauncherDelegate;
import org.eclipse.tcf.te.ui.terminals.internal.dialogs.LaunchTerminalSettingsDialog;
import org.eclipse.tcf.te.ui.terminals.launcher.LauncherDelegateManager;
import org.eclipse.ui.handlers.HandlerUtil;

public class LaunchTerminalCommandHandler
extends AbstractHandler {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        String commandId = event.getCommand().getId();
        Shell shell = HandlerUtil.getActiveShell((ExecutionEvent)event);
        ISelection selection = HandlerUtil.getCurrentSelection((ExecutionEvent)event);
        if (commandId.equals("org.eclipse.tcf.te.ui.terminals.command.launchToolbar")) {
            IPropertiesContainer properties;
            LaunchTerminalSettingsDialog dialog = new LaunchTerminalSettingsDialog(shell);
            if (dialog.open() == 0 && (properties = dialog.getSettings()) != null) {
                String delegateId = properties.getStringProperty("delegateId");
                Assert.isNotNull((Object)delegateId);
                ILauncherDelegate delegate = LauncherDelegateManager.getInstance().getLauncherDelegate(delegateId, false);
                Assert.isNotNull((Object)delegateId);
                delegate.execute(properties, null);
            }
        } else {
            ILauncherDelegate[] delegates = LauncherDelegateManager.getInstance().getApplicableLauncherDelegates(selection);
            if (delegates.length > 1 || delegates.length == 1 && delegates[0].needsUserConfiguration()) {
                IPropertiesContainer properties;
                LaunchTerminalSettingsDialog dialog = new LaunchTerminalSettingsDialog(shell);
                dialog.setSelection(selection);
                if (dialog.open() == 0 && (properties = dialog.getSettings()) != null) {
                    String delegateId = properties.getStringProperty("delegateId");
                    Assert.isNotNull((Object)delegateId);
                    ILauncherDelegate delegate = LauncherDelegateManager.getInstance().getLauncherDelegate(delegateId, false);
                    Assert.isNotNull((Object)delegateId);
                    delegate.execute(properties, null);
                }
            } else if (delegates.length == 1) {
                ILauncherDelegate delegate = delegates[0];
                PropertiesContainer properties = new PropertiesContainer();
                properties.setProperty("delegateId", (Object)delegate.getId());
                properties.setProperty("selection", (Object)selection);
                delegate.execute((IPropertiesContainer)properties, null);
            }
        }
        return null;
    }
}

