/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf.te.ui.views.events;

import java.util.Iterator;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.tcf.te.runtime.model.interfaces.IModelNode;
import org.eclipse.tcf.te.runtime.model.interfaces.IModelNodeProvider;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.navigator.CommonNavigator;
import org.eclipse.ui.navigator.CommonViewer;

public abstract class AbstractEventListener
extends org.eclipse.tcf.te.ui.events.AbstractEventListener {
    private CommonViewer viewer = null;
    private RefreshJob refreshJob = null;
    private UpdateJob updateJob = null;
    private static final int SCHEDULE_TIME = 1000;

    protected CommonViewer getViewer() {
        if (this.viewer == null) {
            IViewPart part;
            IWorkbenchPage page;
            IWorkbench workbench = PlatformUI.getWorkbench();
            IWorkbenchWindow window = workbench != null ? workbench.getActiveWorkbenchWindow() : null;
            IWorkbenchPage iWorkbenchPage = page = window != null ? window.getActivePage() : null;
            if (page != null && (part = page.findView("org.eclipse.tcf.te.ui.views.View")) instanceof CommonNavigator) {
                this.viewer = ((CommonNavigator)part).getCommonViewer();
            }
        }
        return this.viewer;
    }

    protected void refresh(Object node, boolean scheduled) {
        CommonViewer viewer = this.getViewer();
        if (viewer == null || viewer.getControl() != null && viewer.getControl().isDisposed()) {
            return;
        }
        if (scheduled) {
            this.scheduleRefreshJob(node != null ? node : viewer, viewer);
        } else if (node != null) {
            viewer.refresh(node);
        } else {
            viewer.refresh();
        }
    }

    protected void update(Object node, boolean scheduled) {
        Assert.isNotNull((Object)node);
        CommonViewer viewer = this.getViewer();
        if (viewer == null || viewer.getControl() != null && viewer.getControl().isDisposed()) {
            return;
        }
        if (scheduled) {
            this.scheduleUpdateJob(node, viewer);
        } else {
            viewer.update(node, null);
        }
    }

    private void scheduleRefreshJob(Object node, CommonViewer viewer) {
        Assert.isNotNull((Object)node);
        Assert.isNotNull((Object)viewer);
        if (this.refreshJob == null) {
            this.refreshJob = new RefreshJob(viewer);
        }
        this.refreshJob.addNode(node);
    }

    private void scheduleUpdateJob(Object node, CommonViewer viewer) {
        Assert.isNotNull((Object)node);
        Assert.isNotNull((Object)viewer);
        if (this.updateJob == null) {
            this.updateJob = new UpdateJob(viewer);
        }
        this.updateJob.addNode(node);
    }

    private abstract class AbstractJob
    extends Job {
        final CommonViewer parentViewer;
        private final Queue<Object> nodes;
        private boolean done;

        protected AbstractJob(String name, CommonViewer viewer) {
            super(name);
            this.nodes = new ConcurrentLinkedQueue<Object>();
            this.done = true;
            Assert.isNotNull((Object)viewer);
            this.parentViewer = viewer;
            this.setPriority(20);
            this.setSystem(true);
        }

        protected void addNode(Object element) {
            if (element instanceof CommonViewer) {
                this.nodes.clear();
            } else if (!this.nodes.contains(element)) {
                if (element instanceof IModelNodeProvider) {
                    IModelNode node = ((IModelNodeProvider)element).getModelNode();
                    Iterator it = this.nodes.iterator();
                    while (it.hasNext() && element != null && node != null) {
                        IModelNode rNode;
                        Object obj = it.next();
                        if (!(obj instanceof IModelNodeProvider) || (rNode = ((IModelNodeProvider)obj).getModelNode()) == null) continue;
                        if (rNode.equals(node.getParent())) {
                            element = null;
                            continue;
                        }
                        if (!node.equals(rNode.getParent())) continue;
                        it.remove();
                    }
                }
            } else {
                element = null;
            }
            if (element != null) {
                this.nodes.add(element);
            }
            if (this.done) {
                this.done = false;
                this.schedule(1000L);
            }
        }

        protected IStatus run(IProgressMonitor monitor) {
            Object node = this.nodes.poll();
            while (node != null) {
                Runnable runnable = this.newRunnable(node);
                if (runnable != null) {
                    try {
                        PlatformUI.getWorkbench().getDisplay().asyncExec(runnable);
                    }
                    catch (Exception exception) {}
                }
                node = this.nodes.poll();
            }
            this.done = true;
            return Status.OK_STATUS;
        }

        protected Runnable newRunnable(Object node) {
            Assert.isNotNull((Object)node);
            return null;
        }
    }

    private class RefreshJob
    extends AbstractJob {
        public RefreshJob(CommonViewer viewer) {
            super(RefreshJob.class.getSimpleName(), viewer);
        }

        @Override
        protected Runnable newRunnable(final Object node) {
            return new Runnable(){

                @Override
                public void run() {
                    if (RefreshJob.this.parentViewer != null && RefreshJob.this.parentViewer.getControl() != null && !RefreshJob.this.parentViewer.getControl().isDisposed()) {
                        if (node instanceof CommonViewer) {
                            RefreshJob.this.parentViewer.refresh();
                        } else {
                            RefreshJob.this.parentViewer.refresh(node);
                        }
                    }
                }
            };
        }
    }

    private class UpdateJob
    extends AbstractJob {
        public UpdateJob(CommonViewer viewer) {
            super(UpdateJob.class.getSimpleName(), viewer);
        }

        @Override
        protected Runnable newRunnable(final Object node) {
            return new Runnable(){

                @Override
                public void run() {
                    if (UpdateJob.this.parentViewer != null && UpdateJob.this.parentViewer.getControl() != null && !UpdateJob.this.parentViewer.getControl().isDisposed()) {
                        if (node instanceof CommonViewer) {
                            UpdateJob.this.parentViewer.refresh();
                        } else {
                            UpdateJob.this.parentViewer.update(node, null);
                        }
                    }
                }
            };
        }
    }
}

