/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf.te.ui.views.internal;

import org.eclipse.core.commands.Command;
import org.eclipse.core.commands.ParameterizedCommand;
import org.eclipse.core.expressions.EvaluationContext;
import org.eclipse.core.expressions.IEvaluationContext;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.action.GroupMarker;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.viewers.ColumnViewerEditorActivationStrategy;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.TreeViewerEditor;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.tcf.te.ui.trees.TreeViewerEditorActivationStrategy;
import org.eclipse.tcf.te.ui.views.activator.UIPlugin;
import org.eclipse.tcf.te.ui.views.internal.AltDoubleClickEvent;
import org.eclipse.tcf.te.ui.views.internal.ViewExpandingState;
import org.eclipse.tcf.te.ui.views.internal.ViewRoot;
import org.eclipse.tcf.te.ui.views.internal.ViewViewer;
import org.eclipse.tcf.te.ui.views.internal.ViewViewerComparer;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.commands.ICommandService;
import org.eclipse.ui.handlers.IHandlerService;
import org.eclipse.ui.navigator.CommonNavigator;
import org.eclipse.ui.navigator.CommonViewer;
import org.eclipse.ui.navigator.IMementoAware;
import org.eclipse.ui.views.properties.IPropertySheetPage;
import org.eclipse.ui.views.properties.tabbed.ITabbedPropertySheetPageContributor;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetPage;

public class View
extends CommonNavigator
implements ITabbedPropertySheetPageContributor {
    private int rootMode = 1;
    private String workingSetLabel;
    IMementoAware expandingState;

    protected Object getInitialInput() {
        return ViewRoot.getInstance();
    }

    public void setRootMode(int mode) {
        this.rootMode = mode;
    }

    public int getRootMode() {
        return this.rootMode;
    }

    public void setWorkingSetLabel(String label) {
        this.workingSetLabel = label;
    }

    public String getWorkingSetLabel() {
        return this.workingSetLabel;
    }

    public void dispose() {
        super.dispose();
    }

    protected CommonViewer createCommonViewerObject(Composite parent) {
        ViewViewer viewer = new ViewViewer(this.getViewSite().getId(), parent, 770);
        viewer.setComparer(new ViewViewerComparer());
        TreeViewerEditorActivationStrategy activationStrategy = new TreeViewerEditorActivationStrategy(this.getSite().getId(), (TreeViewer)viewer);
        TreeViewerEditor.create((TreeViewer)viewer, null, (ColumnViewerEditorActivationStrategy)activationStrategy, (int)1);
        return viewer;
    }

    public void createPartControl(Composite parent) {
        super.createPartControl(parent);
        this.addCustomToolbarGroups();
        this.expandingState = new ViewExpandingState(this.getCommonViewer());
        if (this.getMemento() != null) {
            this.expandingState.restoreState(this.getMemento());
        }
    }

    protected void addCustomToolbarGroups() {
        IToolBarManager tbManager;
        if (this.getViewSite() != null && this.getViewSite().getActionBars() != null && (tbManager = this.getViewSite().getActionBars().getToolBarManager()) != null) {
            tbManager.insertBefore("FRAME_ACTION_GROUP_ID", (IContributionItem)new GroupMarker("group.new"));
            tbManager.appendToGroup("group.new", (IContributionItem)new Separator("group.configure"));
            tbManager.appendToGroup("group.configure", (IContributionItem)new Separator("group.connect"));
            tbManager.appendToGroup("group.connect", (IContributionItem)new Separator("group.symbols.rd"));
            tbManager.appendToGroup("group.symbols.rd", (IContributionItem)new GroupMarker("group.symbols"));
            tbManager.appendToGroup("group.symbols", (IContributionItem)new Separator("group.refresh"));
            tbManager.appendToGroup("group.refresh", (IContributionItem)new Separator("additions"));
        }
    }

    public void saveState(IMemento aMemento) {
        super.saveState(aMemento);
        if (this.expandingState != null && aMemento != null) {
            this.expandingState.saveState(aMemento);
        }
    }

    protected void handleDoubleClick(DoubleClickEvent dblClickEvent) {
        Command command;
        ICommandService service = (ICommandService)PlatformUI.getWorkbench().getService(ICommandService.class);
        Command command2 = command = service != null ? service.getCommand("org.eclipse.ui.navigator.Open") : null;
        if (command != null && command.isDefined() && command.isEnabled()) {
            try {
                ISelection selection = dblClickEvent.getSelection();
                EvaluationContext ctx = new EvaluationContext(null, (Object)selection);
                ctx.addVariable("selection", (Object)selection);
                ctx.addVariable("activeMenuSelection", (Object)selection);
                ctx.addVariable("activeWorkbenchWindow", (Object)PlatformUI.getWorkbench().getActiveWorkbenchWindow());
                ctx.addVariable("activePartId", (Object)this.getViewSite().getId());
                ctx.addVariable("activePart", (Object)this);
                ctx.addVariable("activeSite", (Object)this.getViewSite());
                ctx.addVariable("activeShell", (Object)this.getViewSite().getShell());
                ctx.addVariable("altPressed", (Object)(dblClickEvent instanceof AltDoubleClickEvent));
                ctx.setAllowPluginActivation(true);
                ParameterizedCommand pCmd = ParameterizedCommand.generateCommand((Command)command, null);
                Assert.isNotNull((Object)pCmd);
                IHandlerService handlerSvc = (IHandlerService)PlatformUI.getWorkbench().getService(IHandlerService.class);
                Assert.isNotNull((Object)handlerSvc);
                handlerSvc.executeCommandInContext(pCmd, null, (IEvaluationContext)ctx);
            }
            catch (Exception e) {
                if (Platform.inDebugMode()) {
                    Status status = new Status(4, UIPlugin.getUniqueIdentifier(), e.getLocalizedMessage(), (Throwable)e);
                    UIPlugin.getDefault().getLog().log((IStatus)status);
                }
            }
        } else {
            super.handleDoubleClick(dblClickEvent);
        }
    }

    public Object getAdapter(Class adapter) {
        if (adapter == IPropertySheetPage.class) {
            return new TabbedPropertySheetPage((ITabbedPropertySheetPageContributor)this);
        }
        return super.getAdapter(adapter);
    }

    public String getContributorId() {
        return "org.eclipse.tcf.te.ui";
    }
}

