/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf.te.ui.views.internal.categories;

import java.util.ArrayList;
import java.util.Iterator;
import org.eclipse.core.expressions.IEvaluationContext;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeSelection;
import org.eclipse.jface.viewers.TreePath;
import org.eclipse.swt.graphics.Image;
import org.eclipse.tcf.te.ui.views.ViewsUtil;
import org.eclipse.tcf.te.ui.views.extensions.CategoriesExtensionPointManager;
import org.eclipse.tcf.te.ui.views.interfaces.ICategory;
import org.eclipse.tcf.te.ui.views.interfaces.categories.ICategorizable;
import org.eclipse.ui.actions.CompoundContributionItem;
import org.eclipse.ui.handlers.IHandlerService;
import org.eclipse.ui.menus.IWorkbenchContribution;
import org.eclipse.ui.services.IServiceLocator;

public abstract class AbstractCategoryContributionItem
extends CompoundContributionItem
implements IWorkbenchContribution {
    protected IServiceLocator serviceLocator;

    public void initialize(IServiceLocator serviceLocator) {
        this.serviceLocator = serviceLocator;
    }

    protected IContributionItem[] getContributionItems() {
        ICategory[] categories;
        IHandlerService service = (IHandlerService)this.serviceLocator.getService(IHandlerService.class);
        IEvaluationContext state = service.getCurrentState();
        ISelection selection = (ISelection)state.getVariable("selection");
        IStructuredSelection iss = (IStructuredSelection)selection;
        ArrayList<ActionContributionItem> items = new ArrayList<ActionContributionItem>();
        ICategory[] iCategoryArray = categories = this.getCategories(iss, true);
        int n = categories.length;
        int n2 = 0;
        while (n2 < n) {
            ICategory category = iCategoryArray[n2];
            IAction action = this.createAction(this, (ISelection)iss, category, categories.length == 1);
            if (action != null) {
                action.setEnabled(this.isEnabled((ISelection)iss, category));
                items.add(new ActionContributionItem(action));
            }
            ++n2;
        }
        return items.toArray(new IContributionItem[items.size()]);
    }

    protected ICategory[] getCategories(IStructuredSelection selection, boolean onlyEnabled) {
        Assert.isNotNull((Object)selection);
        ArrayList categories = new ArrayList();
        ICategory[] allCategories = CategoriesExtensionPointManager.getInstance().getCategories(false);
        boolean firstRun = true;
        for (Object element : selection) {
            if (this.getCategorizable(element) == null) continue;
            ICategory parentCategory = this.getParentCategory(element, selection);
            ArrayList<ICategory> candidates = new ArrayList<ICategory>();
            ICategory[] iCategoryArray = allCategories;
            int n = allCategories.length;
            int n2 = 0;
            while (n2 < n) {
                ICategory category = iCategoryArray[n2];
                if (this.isValid(parentCategory, element, category) && (!onlyEnabled || this.isEnabled((ISelection)selection, category))) {
                    candidates.add(category);
                }
                ++n2;
            }
            if (firstRun) {
                categories.addAll(candidates);
                firstRun = false;
                continue;
            }
            Iterator catIterator = categories.iterator();
            while (catIterator.hasNext()) {
                ICategory category = (ICategory)catIterator.next();
                if (candidates.contains(category)) continue;
                catIterator.remove();
            }
        }
        return categories.toArray(new ICategory[categories.size()]);
    }

    protected abstract IAction createAction(AbstractCategoryContributionItem var1, ISelection var2, ICategory var3, boolean var4);

    protected abstract boolean isValid(ICategory var1, Object var2, ICategory var3);

    protected abstract boolean isEnabled(ISelection var1, ICategory var2);

    protected ICategory getParentCategory(Object element, IStructuredSelection selection) {
        Assert.isNotNull((Object)element);
        Assert.isNotNull((Object)selection);
        ICategory parent = null;
        if (selection instanceof ITreeSelection) {
            TreePath[] pathes;
            TreePath[] treePathArray = pathes = ((ITreeSelection)selection).getPathsFor(element);
            int n = pathes.length;
            int n2 = 0;
            while (n2 < n) {
                TreePath path = treePathArray[n2];
                TreePath parentPath = path.getParentPath();
                while (parentPath != null) {
                    if (parentPath.getLastSegment() instanceof ICategory) {
                        parent = (ICategory)parentPath.getLastSegment();
                        break;
                    }
                    parentPath = parentPath.getParentPath();
                }
                if (parent != null) break;
                ++n2;
            }
        }
        return parent;
    }

    protected ICategorizable getCategorizable(Object element) {
        ICategorizable categorizable;
        ICategorizable iCategorizable = categorizable = element instanceof IAdaptable ? (ICategorizable)((IAdaptable)element).getAdapter(ICategorizable.class) : null;
        if (categorizable == null) {
            categorizable = (ICategorizable)Platform.getAdapterManager().getAdapter(element, ICategorizable.class);
        }
        return categorizable;
    }

    protected static abstract class AbstractCategoryAction
    extends Action {
        private final AbstractCategoryContributionItem item;
        private final ISelection selection;
        private final ICategory category;

        public AbstractCategoryAction(AbstractCategoryContributionItem item, ISelection selection, ICategory category, boolean single) {
            Assert.isNotNull((Object)((Object)item));
            this.item = item;
            Assert.isNotNull((Object)selection);
            this.selection = selection;
            Assert.isNotNull((Object)category);
            this.category = category;
            this.initialize(single);
        }

        protected void initialize(boolean single) {
            this.setText(single ? this.makeSingleText(this.category.getLabel()) : this.category.getLabel());
            Image image = this.category.getImage();
            if (image != null) {
                this.setImageDescriptor(ImageDescriptor.createFromImage((Image)image));
            }
        }

        protected String makeSingleText(String text) {
            Assert.isNotNull((Object)text);
            return text;
        }

        public void run() {
            if (this.selection instanceof IStructuredSelection && !this.selection.isEmpty()) {
                boolean refresh = false;
                for (Object element : (IStructuredSelection)this.selection) {
                    refresh |= this.execute(element, this.category);
                }
                if (refresh) {
                    ViewsUtil.refresh("org.eclipse.tcf.te.ui.views.View");
                }
            }
        }

        protected ICategorizable getCategorizable(Object element) {
            return this.item.getCategorizable(element);
        }

        protected abstract boolean execute(Object var1, ICategory var2);
    }
}

