/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf.te.ui.internal.utils;

import java.lang.reflect.InvocationTargetException;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.viewers.TreePath;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.tcf.te.ui.interfaces.ISearchMatcher;
import org.eclipse.tcf.te.ui.internal.utils.AbstractSearcher;

public class BreadthFirstSearcher
extends AbstractSearcher {
    private Queue<TreePath> queue;

    public BreadthFirstSearcher(TreeViewer viewer, ISearchMatcher matcher) {
        super(viewer, matcher);
    }

    @Override
    public void setStartPath(TreePath path) {
        this.queue = new ConcurrentLinkedQueue<TreePath>();
        this.queue.offer(path);
    }

    @Override
    public TreePath searchNext(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
        TreePath result = null;
        while (!this.queue.isEmpty() && result == null && !monitor.isCanceled()) {
            TreePath path = this.queue.poll();
            Object element = path.getLastSegment();
            Object[] children = this.getUpdatedChildren(element, monitor);
            if (children != null && children.length > 0) {
                Object[] objectArray = children;
                int n = children.length;
                int n2 = 0;
                while (n2 < n) {
                    Object child = objectArray[n2];
                    TreePath childPath = path.createChildPath(child);
                    this.queue.offer(childPath);
                    ++n2;
                }
            }
            String elementText = this.getElementText(element);
            monitor.subTask(elementText);
            if (!this.fMatcher.match(element)) continue;
            result = path;
        }
        if (monitor.isCanceled()) {
            throw new InterruptedException();
        }
        return result;
    }
}

