/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf.te.ui.trees;

import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.tcf.te.ui.trees.ColumnDescriptor;
import org.eclipse.tcf.te.ui.trees.Pending;
import org.eclipse.tcf.te.ui.trees.PendingAwareLabelProvider;

public class TreeViewerLabelProvider
extends PendingAwareLabelProvider
implements ITableLabelProvider {
    private TreeViewer viewer;

    public TreeViewerLabelProvider(TreeViewer viewer) {
        this.viewer = viewer;
    }

    private ColumnDescriptor getColumn(int columnIndex) {
        Tree tree = this.viewer.getTree();
        TreeColumn column = tree.getColumn(columnIndex);
        ColumnDescriptor descriptor = (ColumnDescriptor)column.getData();
        return descriptor;
    }

    @Override
    public String getText(Object element) {
        return this.getColumnText(element, 0);
    }

    @Override
    public Image getImage(Object element) {
        return this.getColumnImage(element, 0);
    }

    public Image getColumnImage(Object element, int columnIndex) {
        ILabelProvider labelProvider;
        if (element instanceof Pending) {
            return columnIndex == 0 ? super.getImage(element) : null;
        }
        ColumnDescriptor column = this.getColumn(columnIndex);
        if (column != null && (labelProvider = column.getLabelProvider()) != null) {
            return labelProvider.getImage(element);
        }
        return null;
    }

    public String getColumnText(Object element, int columnIndex) {
        ILabelProvider labelProvider;
        if (element instanceof Pending) {
            return columnIndex == 0 ? super.getText(element) : "";
        }
        ColumnDescriptor column = this.getColumn(columnIndex);
        if (column != null && (labelProvider = column.getLabelProvider()) != null) {
            return labelProvider.getText(element);
        }
        return "";
    }
}

