/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.svn.ui.action.local;

import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.action.IAction;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.team.svn.core.IStateFilter;
import org.eclipse.team.svn.core.SVNMessages;
import org.eclipse.team.svn.core.operation.AbstractActionOperation;
import org.eclipse.team.svn.core.operation.CompositeOperation;
import org.eclipse.team.svn.core.operation.IActionOperation;
import org.eclipse.team.svn.core.operation.local.AddToSVNOperation;
import org.eclipse.team.svn.core.operation.local.FreezeExternalsOperation;
import org.eclipse.team.svn.core.operation.local.IUnresolvedConflictDetector;
import org.eclipse.team.svn.core.operation.local.RefreshResourcesOperation;
import org.eclipse.team.svn.core.operation.local.RestoreExternalsOperation;
import org.eclipse.team.svn.core.operation.local.RestoreProjectMetaOperation;
import org.eclipse.team.svn.core.operation.local.RevertOperation;
import org.eclipse.team.svn.core.operation.local.SaveProjectMetaOperation;
import org.eclipse.team.svn.core.operation.local.SwitchOperation;
import org.eclipse.team.svn.core.operation.local.UpdateOperation;
import org.eclipse.team.svn.core.operation.remote.PreparedBranchTagOperation;
import org.eclipse.team.svn.core.resource.ILocalResource;
import org.eclipse.team.svn.core.resource.IRepositoryContainer;
import org.eclipse.team.svn.core.resource.IRepositoryResource;
import org.eclipse.team.svn.core.resource.IRepositoryResourceProvider;
import org.eclipse.team.svn.core.resource.IRepositoryRoot;
import org.eclipse.team.svn.core.resource.IResourceProvider;
import org.eclipse.team.svn.core.svnstorage.ResourcesParentsProvider;
import org.eclipse.team.svn.core.svnstorage.SVNRemoteStorage;
import org.eclipse.team.svn.core.utility.SVNUtility;
import org.eclipse.team.svn.ui.SVNTeamUIPlugin;
import org.eclipse.team.svn.ui.SVNUIMessages;
import org.eclipse.team.svn.ui.action.AbstractNonRecursiveTeamAction;
import org.eclipse.team.svn.ui.action.FilterManager;
import org.eclipse.team.svn.ui.dialog.DefaultDialog;
import org.eclipse.team.svn.ui.dialog.OperationErrorDialog;
import org.eclipse.team.svn.ui.operation.ClearUpdateStatusesOperation;
import org.eclipse.team.svn.ui.operation.NotifyUnresolvedConflictOperation;
import org.eclipse.team.svn.ui.panel.common.AbstractBranchTagPanel;
import org.eclipse.team.svn.ui.panel.common.BranchPanel;
import org.eclipse.team.svn.ui.panel.common.TagPanel;
import org.eclipse.team.svn.ui.preferences.SVNTeamPreferences;
import org.eclipse.team.svn.ui.utility.UIMonitorUtility;

public class BranchTagAction
extends AbstractNonRecursiveTeamAction {
    public static final int BRANCH_ACTION = 0;
    public static final int TAG_ACTION = 1;
    protected int actionType;

    public BranchTagAction(int actionType) {
        this.actionType = actionType;
    }

    public void runImpl(IAction action) {
        IResource[] resources = this.getSelectedResources(IStateFilter.SF_EXCLUDE_DELETED);
        IActionOperation op = BranchTagAction.getBranchTagOperation(this.getShell(), this.actionType, resources);
        if (op != null) {
            this.runScheduled(op);
        }
    }

    public static IActionOperation getBranchTagOperation(Shell shell, int actionType, final IResource[] resources) {
        boolean isStructureEnabled;
        final IRepositoryResource[] remoteResources = new IRepositoryResource[resources.length];
        int i = 0;
        while (i < resources.length) {
            remoteResources[i] = SVNRemoteStorage.instance().asRepositoryResource(resources[i]);
            ++i;
        }
        if (!OperationErrorDialog.isAcceptableAtOnce(remoteResources, actionType == 0 ? SVNUIMessages.BranchTagAction_Error_Branch : SVNUIMessages.BranchTagAction_Error_Tag, shell)) {
            return null;
        }
        Set<Object> nodeNames = new HashSet();
        boolean bl = isStructureEnabled = remoteResources[0].getRepositoryLocation().isStructureEnabled() && SVNTeamPreferences.getRepositoryBoolean(SVNTeamUIPlugin.instance().getPreferenceStore(), "tagConsideringProjectStructure");
        if (isStructureEnabled && (nodeNames = org.eclipse.team.svn.ui.action.remote.BranchTagAction.getExistingNodeNames((IRepositoryContainer)(actionType == 0 ? SVNUtility.getBranchesLocation((IRepositoryResource)remoteResources[0]) : SVNUtility.getTagsLocation((IRepositoryResource)remoteResources[0])))) == null) {
            return null;
        }
        AbstractBranchTagPanel panel = actionType == 0 ? new BranchPanel(SVNUtility.getBranchesLocation((IRepositoryResource)remoteResources[0]), true, nodeNames, resources, new IRepositoryResource[0]) : new TagPanel(SVNUtility.getTagsLocation((IRepositoryResource)remoteResources[0]), true, nodeNames, resources, new IRepositoryResource[0]);
        DefaultDialog dialog = new DefaultDialog(shell, panel);
        if (dialog.open() == 0) {
            CompositeOperation op;
            PreparedBranchTagOperation mainOp;
            int creationMode;
            boolean forceCreate;
            IRepositoryResource destination = panel.getDestination();
            boolean bl2 = forceCreate = isStructureEnabled && resources.length == 1 && resources[0].getType() == 4;
            if (forceCreate) {
                boolean isSingleProjectLayout = remoteResources[0] instanceof IRepositoryRoot && ((IRepositoryRoot)remoteResources[0]).getKind() == 1 || org.eclipse.team.svn.ui.action.remote.BranchTagAction.isSingleProjectLayout(remoteResources[0]);
                forceCreate &= !isSingleProjectLayout;
            }
            if ((creationMode = panel.getCreationMode()) == 3) {
                IRepositoryResource[] resourcesWithSpecifiedRevision = new IRepositoryResource[remoteResources.length];
                int i2 = 0;
                while (i2 < resources.length) {
                    resourcesWithSpecifiedRevision[i2] = SVNUtility.copyOf((IRepositoryResource)remoteResources[i2]);
                    resourcesWithSpecifiedRevision[i2].setSelectedRevision(panel.getRevisionForRemoteResources());
                    resourcesWithSpecifiedRevision[i2].setPegRevision(remoteResources[i2].getPegRevision());
                    ++i2;
                }
                mainOp = new PreparedBranchTagOperation(actionType == 0 ? "Branch" : "Tag", resourcesWithSpecifiedRevision, destination, panel.getMessage(), forceCreate);
            } else {
                mainOp = new PreparedBranchTagOperation(actionType == 0 ? "Branch" : "Tag", resources, remoteResources, destination, panel.getMessage(), forceCreate);
            }
            switch (creationMode) {
                case 1: {
                    final boolean[] notInSync = new boolean[1];
                    boolean cancelled = UIMonitorUtility.doTaskNowDefault((IActionOperation)new AbstractActionOperation("Operation_CheckIfWCInSync", SVNUIMessages.class){

                        protected void runImpl(IProgressMonitor monitor) throws Exception {
                            if (!FilterManager.instance().checkForResourcesPresenceRecursive(resources, IStateFilter.SF_ANY_CHANGE)) {
                                int i = 0;
                                while (i < resources.length && !monitor.isCanceled()) {
                                    ILocalResource local = SVNRemoteStorage.instance().asLocalResource(resources[i]);
                                    if (local.getRevision() != remoteResources[i].getRevision()) {
                                        notInSync[0] = true;
                                        return;
                                    }
                                    ++i;
                                }
                            } else {
                                notInSync[0] = true;
                            }
                        }
                    }, true).isCancelled();
                    if (cancelled) {
                        return null;
                    }
                    if (!notInSync[0]) break;
                    new OperationErrorDialog(shell, actionType == 0 ? SVNUIMessages.BranchTagAction_Error_Branch : SVNUIMessages.BranchTagAction_Error_Tag, SVNUIMessages.BranchTagAction_Error_NotInSync).open();
                    return null;
                }
                case 2: {
                    op = new CompositeOperation("Operation_Update", SVNMessages.class);
                    SaveProjectMetaOperation saveOp = new SaveProjectMetaOperation(resources);
                    op.add((IActionOperation)saveOp);
                    boolean ignoreExternals = SVNTeamPreferences.getBehaviourBoolean(SVNTeamUIPlugin.instance().getPreferenceStore(), "externals.ignore");
                    UpdateOperation updateOp = new UpdateOperation(resources, ignoreExternals);
                    op.add((IActionOperation)updateOp);
                    op.add((IActionOperation)new ClearUpdateStatusesOperation((IResourceProvider)updateOp), new IActionOperation[]{updateOp});
                    op.add((IActionOperation)new NotifyUnresolvedConflictOperation((IUnresolvedConflictDetector)updateOp));
                    op.add((IActionOperation)new RestoreProjectMetaOperation(saveOp));
                    op.add((IActionOperation)new RefreshResourcesOperation((IResourceProvider)new ResourcesParentsProvider(resources)));
                    if (!UIMonitorUtility.doTaskNowDefault((IActionOperation)op, true).isCancelled() && !updateOp.hasUnresolvedConflicts()) break;
                    return null;
                }
            }
            op = new CompositeOperation(mainOp.getId(), mainOp.getMessagesClass());
            if (creationMode == 3) {
                op.add((IActionOperation)mainOp);
            } else {
                IResource[] newResources = panel.getSelectedResources();
                if (newResources != null && newResources.length > 0) {
                    op.add((IActionOperation)new AddToSVNOperation(newResources, false));
                }
                if (panel.isFreezeExternals()) {
                    FreezeExternalsOperation freezeOp = new FreezeExternalsOperation(resources);
                    op.add((IActionOperation)freezeOp);
                    op.add((IActionOperation)mainOp, new IActionOperation[]{freezeOp});
                    op.add((IActionOperation)new RestoreExternalsOperation(freezeOp));
                } else {
                    op.add((IActionOperation)mainOp);
                }
                if (newResources != null && newResources.length > 0) {
                    op.add((IActionOperation)new RevertOperation(newResources, false));
                }
            }
            if (panel.isStartWithSelected()) {
                boolean ignoreExternals = SVNTeamPreferences.getBehaviourBoolean(SVNTeamUIPlugin.instance().getPreferenceStore(), "externals.ignore");
                SaveProjectMetaOperation saveOp = new SaveProjectMetaOperation(resources);
                op.add((IActionOperation)saveOp);
                SwitchOperation switchOp = new SwitchOperation(resources, (IRepositoryResourceProvider)mainOp, 3, false, ignoreExternals);
                op.add((IActionOperation)switchOp, new IActionOperation[]{mainOp});
                op.add((IActionOperation)new RestoreProjectMetaOperation(saveOp));
                op.add((IActionOperation)new RefreshResourcesOperation(resources));
                op.add((IActionOperation)new NotifyUnresolvedConflictOperation((IUnresolvedConflictDetector)switchOp));
            }
            return op;
        }
        return null;
    }

    public boolean isEnabled() {
        return this.checkForResourcesPresence(IStateFilter.SF_EXCLUDE_DELETED);
    }

    protected boolean needsToSaveDirtyEditors() {
        return true;
    }
}

