/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.svn.ui.composite;

import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.team.svn.ui.SVNUIMessages;
import org.eclipse.team.svn.ui.composite.SecurityWarningComposite;
import org.eclipse.team.svn.ui.utility.UserInputHistory;

public class CredentialsComposite
extends Composite {
    protected static final String USER_HISTORY_NAME = "repositoryUser";
    protected Combo userName;
    protected Text password;
    protected Button savePassword;
    protected String usernameInput;
    protected String passwordInput;
    protected boolean passwordSaved;
    protected UserInputHistory userHistory;

    public CredentialsComposite(Composite parent, int style) {
        super(parent, style);
        this.createControls();
    }

    public void initialize() {
        if (this.usernameInput != null && this.usernameInput.trim().length() > 0) {
            this.userName.setText(this.usernameInput);
        } else {
            this.userName.setFocus();
        }
        if (this.passwordInput != null) {
            this.password.setText(this.passwordInput);
        }
        if (this.usernameInput != null && this.usernameInput.trim().length() > 0) {
            this.password.setFocus();
            this.password.selectAll();
        }
        this.savePassword.setSelection(this.passwordSaved);
    }

    public Text getPassword() {
        return this.password;
    }

    public Button getSavePassword() {
        return this.savePassword;
    }

    public UserInputHistory getUserHistory() {
        return this.userHistory;
    }

    public void setUserHistory(UserInputHistory userHistory) {
        this.userHistory = userHistory;
    }

    public Combo getUsername() {
        return this.userName;
    }

    public void setPasswordInput(String passwordInput) {
        this.passwordInput = passwordInput;
    }

    public void setPasswordSaved(boolean passwordSaved) {
        this.passwordSaved = passwordSaved;
    }

    public void setUsernameInput(String usernameInput) {
        this.usernameInput = usernameInput;
    }

    private void createControls() {
        GridLayout layout = new GridLayout();
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        this.setLayout((Layout)layout);
        GridData data = new GridData(1808);
        this.setLayoutData(data);
        Group authGroup = new Group((Composite)this, 0);
        layout = new GridLayout();
        layout.verticalSpacing = 12;
        authGroup.setLayout((Layout)layout);
        data = new GridData(770);
        data.horizontalSpan = 2;
        authGroup.setLayoutData((Object)data);
        authGroup.setText(SVNUIMessages.CredentialsComposite_Authentication);
        Composite inner = new Composite((Composite)authGroup, 4);
        layout = new GridLayout();
        layout.numColumns = 2;
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        inner.setLayout((Layout)layout);
        data = new GridData(768);
        data.horizontalSpan = 2;
        inner.setLayoutData((Object)data);
        Label description = new Label(inner, 0);
        data = new GridData(768);
        data.grabExcessHorizontalSpace = false;
        data.horizontalIndent = 0;
        description.setLayoutData((Object)data);
        description.setText(SVNUIMessages.CredentialsComposite_User);
        this.userHistory = new UserInputHistory(USER_HISTORY_NAME);
        this.userName = new Combo(inner, 4);
        data = new GridData(768);
        data.grabExcessHorizontalSpace = true;
        data.widthHint = 200;
        this.userName.setLayoutData((Object)data);
        this.userName.setVisibleItemCount(this.userHistory.getDepth());
        this.userName.setItems(this.userHistory.getHistory());
        description = new Label(inner, 0);
        data = new GridData(768);
        data.grabExcessHorizontalSpace = false;
        data.horizontalIndent = 0;
        description.setLayoutData((Object)data);
        description.setText(SVNUIMessages.CredentialsComposite_Password);
        this.password = new Text(inner, 0x400804);
        data = new GridData(768);
        data.grabExcessHorizontalSpace = true;
        data.widthHint = 200;
        this.password.setLayoutData((Object)data);
        inner = new Composite((Composite)authGroup, 4);
        layout = new GridLayout();
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        inner.setLayout((Layout)layout);
        data = new GridData(768);
        data.horizontalSpan = 2;
        inner.setLayoutData((Object)data);
        this.savePassword = new Button(inner, 32);
        data = new GridData();
        this.savePassword.setLayoutData((Object)data);
        this.savePassword.setText(SVNUIMessages.CredentialsComposite_SavePassword);
        new SecurityWarningComposite(inner);
    }
}

