/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.svn.ui.panel.local;

import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IPath;
import org.eclipse.team.svn.core.connector.ISVNConnector;
import org.eclipse.team.svn.core.connector.ISVNProgressMonitor;
import org.eclipse.team.svn.core.connector.SVNConflictDescriptor;
import org.eclipse.team.svn.core.connector.SVNConflictVersion;
import org.eclipse.team.svn.core.connector.SVNConnectorException;
import org.eclipse.team.svn.core.connector.SVNEntryReference;
import org.eclipse.team.svn.core.connector.SVNEntryRevisionReference;
import org.eclipse.team.svn.core.connector.SVNRevision;
import org.eclipse.team.svn.core.operation.CompositeOperation;
import org.eclipse.team.svn.core.operation.IActionOperation;
import org.eclipse.team.svn.core.operation.SVNNullProgressMonitor;
import org.eclipse.team.svn.core.operation.local.MarkResolvedOperation;
import org.eclipse.team.svn.core.operation.local.RefreshResourcesOperation;
import org.eclipse.team.svn.core.operation.local.RevertOperation;
import org.eclipse.team.svn.core.operation.local.UpdateOperation;
import org.eclipse.team.svn.core.operation.local.refactor.DeleteResourceOperation;
import org.eclipse.team.svn.core.operation.remote.CopyRemoteResourcesToWcOperation;
import org.eclipse.team.svn.core.resource.ILocalResource;
import org.eclipse.team.svn.core.resource.IRepositoryLocation;
import org.eclipse.team.svn.core.resource.IRepositoryResource;
import org.eclipse.team.svn.core.utility.SVNUtility;
import org.eclipse.team.svn.ui.SVNTeamUIPlugin;
import org.eclipse.team.svn.ui.SVNUIMessages;
import org.eclipse.team.svn.ui.preferences.SVNTeamPreferences;

public class EditTreeConflictsHelper {
    protected ILocalResource local;
    protected SVNConflictDescriptor treeConflict;

    public EditTreeConflictsHelper(ILocalResource local) {
        this.local = local;
        this.treeConflict = this.local.getTreeConflictDescriptor();
    }

    public String getOperationAsString() {
        String operation;
        switch (this.treeConflict.operation) {
            case 1: {
                operation = SVNUIMessages.EditTreeConflictsPanel_Update_Operation;
                break;
            }
            case 3: {
                operation = SVNUIMessages.EditTreeConflictsPanel_Merge_Operation;
                break;
            }
            case 2: {
                operation = SVNUIMessages.EditTreeConflictsPanel_Switch_Operation;
                break;
            }
            default: {
                operation = SVNUIMessages.EditTreeConflictsPanel_None_Operation;
            }
        }
        return operation;
    }

    public String getReasonAsString() {
        String reason = "";
        switch (this.treeConflict.reason) {
            case 5: {
                reason = SVNUIMessages.EditTreeConflictsPanel_Add_Reason;
                break;
            }
            case 2: {
                reason = SVNUIMessages.EditTreeConflictsPanel_Delete_Reason;
                break;
            }
            case 3: {
                reason = SVNUIMessages.EditTreeConflictsPanel_Missing_Reason;
                break;
            }
            case 0: {
                reason = SVNUIMessages.EditTreeConflictsPanel_Modified_Reason;
                break;
            }
            case 1: {
                reason = SVNUIMessages.EditTreeConflictsPanel_Obstructed_Reason;
                break;
            }
            case 4: {
                reason = SVNUIMessages.EditTreeConflictsPanel_Unversioned_Reason;
            }
        }
        return reason;
    }

    public String getActionAsString() {
        String action = SVNUIMessages.EditTreeConflictsPanel_Replace_Action;
        if (this.treeConflict.action == 0) {
            action = SVNUIMessages.EditTreeConflictsPanel_Modify_Action;
        } else if (this.treeConflict.action == 1) {
            action = SVNUIMessages.EditTreeConflictsPanel_Add_Action;
        } else if (this.treeConflict.action == 2) {
            action = SVNUIMessages.EditTreeConflictsPanel_Delete_Action;
        }
        return action;
    }

    public String getTip() {
        String tip = null;
        if (this.treeConflict.action == 2 && this.treeConflict.reason == 2) {
            tip = SVNUIMessages.EditTreeConflictsPanel_Tip1;
        } else if (this.treeConflict.reason == 0 && this.treeConflict.action == 2) {
            tip = SVNUIMessages.EditTreeConflictsPanel_Tip2;
        } else if (this.treeConflict.reason == 2 || this.treeConflict.action == 2) {
            tip = SVNUIMessages.EditTreeConflictsPanel_Tip3;
        }
        return tip;
    }

    public String getSrcUrl(boolean isLeft) {
        SVNConflictVersion version = isLeft ? this.treeConflict.srcLeftVersion : this.treeConflict.srcRightVersion;
        String url = String.valueOf(version.reposURL) + "/" + version.pathInRepos;
        url = SVNUtility.normalizeURL((String)url);
        return url;
    }

    public boolean isRemoteOperationResolveTheConflict() {
        return !(this.treeConflict.action != 0 && this.treeConflict.action != 3 || this.treeConflict.operation != 1 && this.treeConflict.operation != 2);
    }

    public IActionOperation getOperation(boolean isRemoteResolution, boolean isLocalResolution, boolean markAsMerged) {
        boolean isManual;
        CompositeOperation cmpOp = null;
        String opName = "";
        boolean isRecursive = true;
        if (isLocalResolution) {
            cmpOp = new CompositeOperation(opName, SVNUIMessages.class);
            IActionOperation resolvedOp = this.getResolvedOperation(isRemoteResolution, isLocalResolution, markAsMerged);
            cmpOp.add(resolvedOp);
        } else if (isRemoteResolution) {
            if (this.treeConflict.action == 1) {
                cmpOp = this.getRemoteAddOperation(opName, isRecursive);
            } else if (this.treeConflict.action == 2) {
                cmpOp = this.getRemoteDeleteOperation(opName);
            } else if (this.treeConflict.action == 0 || this.treeConflict.action == 3) {
                cmpOp = this.getRemoteModifyOperation(opName, isRecursive);
            }
        }
        boolean bl = isManual = !isRemoteResolution && !isLocalResolution;
        if (markAsMerged && (isRemoteResolution && !this.isRemoteOperationResolveTheConflict() || isManual)) {
            if (isManual) {
                cmpOp = new CompositeOperation(opName, SVNUIMessages.class);
            }
            cmpOp.add(this.getResolvedOperation(isRemoteResolution, isLocalResolution, markAsMerged));
        }
        if (cmpOp != null) {
            cmpOp.add((IActionOperation)new RefreshResourcesOperation(new IResource[]{this.local.getResource()}));
        }
        return cmpOp;
    }

    protected CompositeOperation getRemoteDeleteOperation(String opName) {
        CompositeOperation cmpOp = new CompositeOperation(opName, SVNUIMessages.class);
        DeleteResourceOperation deleteOp = null;
        if ("Deleted" != this.local.getStatus() && "Missing" != this.local.getStatus()) {
            deleteOp = new DeleteResourceOperation(this.local.getResource());
            cmpOp.add((IActionOperation)deleteOp);
        }
        return cmpOp;
    }

    protected CompositeOperation getRemoteModifyOperation(String opName, boolean isRecursive) {
        CompositeOperation cmpOp = null;
        IResource resource = this.local.getResource();
        if (this.treeConflict.operation == 1 || this.treeConflict.operation == 2) {
            cmpOp = new CompositeOperation(opName, SVNUIMessages.class);
            RevertOperation resolveOp = new RevertOperation(new IResource[]{resource}, isRecursive);
            cmpOp.add((IActionOperation)resolveOp);
            SVNRevision rev = this.treeConflict.operation == 1 ? SVNRevision.HEAD : SVNRevision.fromNumber((long)this.treeConflict.srcRightVersion.pegRevision);
            boolean ignoreExternals = SVNTeamPreferences.getBehaviourBoolean(SVNTeamUIPlugin.instance().getPreferenceStore(), "externals.ignore");
            UpdateOperation updateOp = new UpdateOperation(new IResource[]{resource}, rev, ignoreExternals);
            cmpOp.add((IActionOperation)updateOp, new IActionOperation[]{resolveOp});
        } else if (this.treeConflict.operation == 3) {
            IActionOperation[] iActionOperationArray;
            cmpOp = new CompositeOperation(opName, SVNUIMessages.class);
            DeleteResourceOperation deleteOp = null;
            if (resource.exists()) {
                deleteOp = new DeleteResourceOperation(resource);
                cmpOp.add((IActionOperation)deleteOp);
            }
            IActionOperation copyOp = this.getCopyResourceOperation();
            if (deleteOp == null) {
                iActionOperationArray = null;
            } else {
                IActionOperation[] iActionOperationArray2 = new IActionOperation[1];
                iActionOperationArray = iActionOperationArray2;
                iActionOperationArray2[0] = deleteOp;
            }
            cmpOp.add(copyOp, iActionOperationArray);
        }
        return cmpOp;
    }

    protected CompositeOperation getRemoteAddOperation(String opName, boolean isRecursive) {
        IActionOperation[] iActionOperationArray;
        IActionOperation updateOp;
        CompositeOperation cmpOp = new CompositeOperation(opName, SVNUIMessages.class);
        DeleteResourceOperation deleteOp = null;
        if (this.local.getResource().exists()) {
            deleteOp = new DeleteResourceOperation(this.local.getResource());
            cmpOp.add((IActionOperation)deleteOp);
        }
        if (this.treeConflict.operation == 3) {
            updateOp = this.getCopyResourceOperation();
        } else {
            SVNRevision rev = this.treeConflict.operation == 1 ? SVNRevision.HEAD : SVNRevision.fromNumber((long)this.treeConflict.srcRightVersion.pegRevision);
            boolean ignoreExternals = SVNTeamPreferences.getBehaviourBoolean(SVNTeamUIPlugin.instance().getPreferenceStore(), "externals.ignore");
            updateOp = new UpdateOperation(new IResource[]{this.local.getResource()}, rev, ignoreExternals);
        }
        if (deleteOp == null) {
            iActionOperationArray = null;
        } else {
            IActionOperation[] iActionOperationArray2 = new IActionOperation[1];
            iActionOperationArray = iActionOperationArray2;
            iActionOperationArray2[0] = deleteOp;
        }
        cmpOp.add(updateOp, iActionOperationArray);
        return cmpOp;
    }

    protected IActionOperation getCopyResourceOperation() {
        String url = this.getSrcUrl(false);
        long pegRev = this.treeConflict.srcRightVersion.pegRevision;
        boolean isFolder = this.treeConflict.nodeKind == 2;
        return new CopyRemoteResourcesToWcOperation(new SVNEntryReference(url, (SVNRevision)SVNRevision.fromNumber((long)pegRev)), isFolder, this.local.getResource());
    }

    protected IActionOperation getResolvedOperation(boolean isRemoteResolution, boolean isLocalResolution, boolean markAsMerged) {
        int resolution = 6;
        return new MarkResolvedOperation(new IResource[]{this.local.getResource()}, resolution, 3);
    }

    public IRepositoryResource getRepositoryResourceForHistory(boolean isLeft) {
        SVNConflictVersion version = isLeft ? this.treeConflict.srcLeftVersion : this.treeConflict.srcRightVersion;
        String url = this.getSrcUrl(isLeft);
        String repos = version.reposURL;
        repos = SVNUtility.normalizeURL((String)repos);
        SVNRevision.Number revision = SVNRevision.fromNumber((long)this.treeConflict.srcRightVersion.pegRevision);
        while (true) {
            IPath path = SVNUtility.createPathForSVNUrl((String)url);
            path = path.removeLastSegments(1);
            url = path.toString();
            IRepositoryLocation location = null;
            ISVNConnector proxy = null;
            try {
                SVNEntryRevisionReference ref = new SVNEntryRevisionReference(url, (SVNRevision)revision, (SVNRevision)revision);
                IRepositoryResource rr = SVNUtility.asRepositoryResource((String)url, (boolean)true);
                location = rr.getRepositoryLocation();
                proxy = location.acquireSVNProxy();
                SVNUtility.info((ISVNConnector)proxy, (SVNEntryRevisionReference)ref, (int)0, (ISVNProgressMonitor)new SVNNullProgressMonitor());
                if (location == null || proxy == null) break;
            }
            catch (SVNConnectorException sVNConnectorException) {
                if (!repos.equals(url)) continue;
                break;
            }
            finally {
                if (location == null || proxy == null) continue;
                location.releaseSVNProxy(proxy);
                continue;
            }
            location.releaseSVNProxy(proxy);
            break;
        }
        IRepositoryResource repositoryResource = SVNUtility.asRepositoryResource((String)url, (boolean)true);
        repositoryResource.setPegRevision((SVNRevision)revision);
        repositoryResource.setSelectedRevision((SVNRevision)revision);
        return repositoryResource;
    }
}

