/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.svn.ui.synchronize.action.logicalmodel;

import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.team.core.synchronize.FastSyncInfoFilter;
import org.eclipse.team.core.synchronize.SyncInfo;
import org.eclipse.team.svn.core.operation.IActionOperation;
import org.eclipse.team.svn.core.operation.local.DiffViewerSettings;
import org.eclipse.team.svn.core.operation.local.RunExternalCompareOperation;
import org.eclipse.team.svn.core.resource.ILocalResource;
import org.eclipse.team.svn.core.resource.IRepositoryResource;
import org.eclipse.team.svn.core.svnstorage.SVNRemoteStorage;
import org.eclipse.team.svn.core.synchronize.AbstractSVNSyncInfo;
import org.eclipse.team.svn.core.utility.SVNUtility;
import org.eclipse.team.svn.ui.action.local.CompareWithWorkingCopyAction;
import org.eclipse.team.svn.ui.preferences.SVNTeamDiffViewerPage;
import org.eclipse.team.svn.ui.synchronize.action.AbstractSynchronizeLogicalModelAction;
import org.eclipse.team.ui.synchronize.ISynchronizePageConfiguration;

public class OpenInExternalCompareEditorModelAction
extends AbstractSynchronizeLogicalModelAction {
    protected DiffViewerSettings.ExternalProgramParameters externalProgramParams;

    public OpenInExternalCompareEditorModelAction(String text, ISynchronizePageConfiguration configuration) {
        super(text, configuration);
    }

    protected IActionOperation getOperation() {
        RunExternalCompareOperation.ExternalCompareOperation op = null;
        if (this.externalProgramParams != null) {
            IResource resource = this.getSelectedResource();
            ILocalResource local = SVNRemoteStorage.instance().asLocalResource(resource);
            IRepositoryResource remote = local.isCopied() ? SVNUtility.getCopiedFrom((IResource)resource) : SVNRemoteStorage.instance().asRepositoryResource(resource);
            op = new RunExternalCompareOperation.ExternalCompareOperation(local, remote, (RunExternalCompareOperation.IExternalProgramParametersProvider)new RunExternalCompareOperation.DefaultExternalProgramParametersProvider(this.externalProgramParams));
        }
        return op;
    }

    protected boolean updateSelection(IStructuredSelection selection) {
        if (super.updateSelection(selection) && selection.size() == 1) {
            IResource resource = this.getSelectedResource();
            DiffViewerSettings diffSettings = SVNTeamDiffViewerPage.loadDiffViewerSettings();
            RunExternalCompareOperation.DetectExternalCompareOperationHelper detectCompareHelper = new RunExternalCompareOperation.DetectExternalCompareOperationHelper(resource, diffSettings, true);
            detectCompareHelper.execute((IProgressMonitor)new NullProgressMonitor());
            this.externalProgramParams = detectCompareHelper.getExternalProgramParameters();
            if (this.externalProgramParams != null) {
                return true;
            }
        }
        return false;
    }

    public FastSyncInfoFilter getSyncInfoFilter() {
        return new FastSyncInfoFilter(){

            public boolean select(SyncInfo info) {
                return CompareWithWorkingCopyAction.COMPARE_FILTER.accept(((AbstractSVNSyncInfo)info).getLocalResource());
            }
        };
    }
}

