/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.svn.ui.verifier;

import java.util.HashSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.swt.widgets.Control;
import org.eclipse.team.svn.ui.SVNUIMessages;
import org.eclipse.team.svn.ui.verifier.AbstractFormattedVerifier;

public class PropertyNameVerifier
extends AbstractFormattedVerifier {
    protected static String ERROR_MESSAGE_LETTER;
    protected static String ERROR_MESSAGE_SYMBOLS;
    protected HashSet<String> ignoreStrings;

    public PropertyNameVerifier(String fieldName) {
        super(fieldName);
        ERROR_MESSAGE_LETTER = SVNUIMessages.format((String)SVNUIMessages.Verifier_PropertyName_Letter, (Object[])new String[]{"$FIELD_NAME$"});
        ERROR_MESSAGE_SYMBOLS = SVNUIMessages.format((String)SVNUIMessages.Verifier_PropertyName_Symbols, (Object[])new String[]{"$FIELD_NAME$"});
        this.ignoreStrings = new HashSet();
        this.ignoreStrings.add(SVNUIMessages.AbstractPropertyEditPanel_svn_description);
        this.ignoreStrings.add(SVNUIMessages.PropertyEditPanel_tsvn_description);
        this.ignoreStrings.add(SVNUIMessages.PropertyEditPanel_bugtraq_description);
        this.ignoreStrings.add(SVNUIMessages.AbstractPropertyEditPanel_custom_description);
        this.ignoreStrings.add("    " + SVNUIMessages.AbstractPropertyEditPanel_custom_hint);
    }

    protected String getErrorMessageImpl(Control input) {
        String property = this.getText(input);
        if (property.trim().length() == 0) {
            return null;
        }
        if (this.ignoreStrings.contains(property)) {
            return SVNUIMessages.AbstractPropertyEditPanel_Name_Verifier_IgnoreStrings;
        }
        Pattern pattern = Pattern.compile("[a-zA-Z].*");
        Matcher matcher = pattern.matcher(property);
        if (!matcher.matches()) {
            return ERROR_MESSAGE_LETTER;
        }
        pattern = Pattern.compile("[a-zA-Z0-9:\\-_.]*");
        if (!pattern.matcher(property).matches()) {
            return ERROR_MESSAGE_SYMBOLS;
        }
        return null;
    }

    protected String getWarningMessageImpl(Control input) {
        return null;
    }
}

