/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.svn.ui.wizard;

import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.team.svn.core.resource.IRepositoryLocation;
import org.eclipse.team.svn.core.resource.IRepositoryResource;
import org.eclipse.team.svn.core.svnstorage.SVNRemoteStorage;
import org.eclipse.team.svn.ui.SVNUIMessages;
import org.eclipse.team.svn.ui.wizard.AbstractSVNWizard;
import org.eclipse.team.svn.ui.wizard.CheckoutAsWizard;
import org.eclipse.team.svn.ui.wizard.checkoutas.SelectCheckoutResourcePage;
import org.eclipse.team.svn.ui.wizard.shareproject.AddRepositoryLocationPage;
import org.eclipse.team.svn.ui.wizard.shareproject.SelectRepositoryLocationPage;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;

public class ImportFromSVNWizard
extends AbstractSVNWizard
implements INewWizard {
    protected SelectRepositoryLocationPage selectLocation;
    protected AddRepositoryLocationPage addLocation;
    protected SelectCheckoutResourcePage selectResource;

    public ImportFromSVNWizard() {
        this.setWindowTitle(SVNUIMessages.ImportFromSVNWizard_Title);
    }

    public void addPages() {
        IRepositoryLocation[] locations = SVNRemoteStorage.instance().getRepositoryLocations();
        if (locations.length > 0) {
            this.selectLocation = new SelectRepositoryLocationPage(locations, true);
            this.addPage((IWizardPage)this.selectLocation);
        }
        this.addLocation = new AddRepositoryLocationPage();
        this.addPage((IWizardPage)this.addLocation);
        this.selectResource = new SelectCheckoutResourcePage();
        this.addPage((IWizardPage)this.selectResource);
    }

    public IWizardPage getNextPage(IWizardPage page) {
        IWizardPage retVal = null;
        this.addLocation.setInitialUrl(null);
        retVal = page instanceof SelectRepositoryLocationPage && this.selectLocation.useExistingLocation() ? super.getNextPage(super.getNextPage(page)) : super.getNextPage(page);
        if (retVal instanceof SelectCheckoutResourcePage) {
            this.selectResource.setRepositoryLocation(this.selectLocation != null && this.selectLocation.useExistingLocation() ? this.selectLocation.getRepositoryLocation() : this.addLocation.getRepositoryLocation());
        }
        return retVal;
    }

    public IWizardPage getPreviousPage(IWizardPage page) {
        if (page instanceof SelectCheckoutResourcePage && this.selectLocation != null && this.selectLocation.useExistingLocation()) {
            return super.getPreviousPage(super.getPreviousPage(page));
        }
        return super.getPreviousPage(page);
    }

    public boolean canFinish() {
        IWizardPage currentPage = this.getContainer().getCurrentPage();
        return currentPage instanceof SelectCheckoutResourcePage && this.selectResource.isPageComplete();
    }

    public boolean performFinish() {
        IRepositoryResource resource = this.selectResource.getSelectedResource();
        CheckoutAsWizard checkoutWizard = new CheckoutAsWizard(new IRepositoryResource[]{resource}, this.addLocation.getOperationToPeform());
        WizardDialog dialog = new WizardDialog(this.getShell(), (IWizard)checkoutWizard);
        dialog.create();
        dialog.getShell().setSize(Math.max(570, dialog.getShell().getSize().x), 500);
        return dialog.open() == 0;
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
    }
}

