/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.gef.graphical.policies;

import org.apache.commons.lang.StringUtils;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;
import org.eclipse.wb.draw2d.FigureUtils;
import org.eclipse.wb.draw2d.geometry.Dimension;
import org.eclipse.wb.draw2d.geometry.Rectangle;
import org.eclipse.wb.gef.graphical.policies.GraphicalEditPolicy;

public abstract class DirectTextEditPolicy
extends GraphicalEditPolicy {
    private Text m_textWidget;
    private Point m_initialSize;
    private final Listener m_mouseDownFilter = new Listener(){

        public void handleEvent(Event event) {
            if (event.widget != DirectTextEditPolicy.this.m_textWidget) {
                DirectTextEditPolicy.this.commitEdit();
            }
        }
    };

    protected abstract String getText();

    protected abstract void setText(String var1);

    public void deactivate() {
        this.endEdit();
        super.deactivate();
    }

    private void commitEdit() {
        String text = this.m_textWidget.getText();
        this.endEdit();
        this.setText(text);
    }

    protected final void beginEdit() {
        this.m_textWidget = new Text((Composite)this.getHost().getViewer().getControl(), 2048);
        String text = this.getText();
        text = StringUtils.defaultString((String)text);
        this.m_textWidget.setText(text);
        this.m_textWidget.selectAll();
        this.m_textWidget.setFocus();
        this.relocateTextWidget();
        this.m_textWidget.addListener(1, new Listener(){

            public void handleEvent(Event event) {
                if (event.keyCode == 27) {
                    DirectTextEditPolicy.this.endEdit();
                } else if (event.keyCode == 13) {
                    DirectTextEditPolicy.this.commitEdit();
                }
            }
        });
        this.m_textWidget.addListener(24, new Listener(){

            public void handleEvent(Event event) {
                DirectTextEditPolicy.this.relocateTextWidget();
            }
        });
        this.m_textWidget.addListener(16, new Listener(){

            public void handleEvent(Event event) {
                DirectTextEditPolicy.this.commitEdit();
            }
        });
        this.m_textWidget.getDisplay().addFilter(3, this.m_mouseDownFilter);
    }

    private void endEdit() {
        if (this.isEditing()) {
            this.m_textWidget.getDisplay().removeFilter(3, this.m_mouseDownFilter);
            this.m_textWidget.dispose();
            this.m_textWidget = null;
            this.m_initialSize = null;
            Display.getCurrent().asyncExec(new Runnable(){

                public void run() {
                    if (DirectTextEditPolicy.this.getHost().isActive()) {
                        DirectTextEditPolicy.this.getHost().getViewer().getControl().setFocus();
                    }
                }
            });
        }
    }

    private boolean isEditing() {
        return this.m_textWidget != null;
    }

    private void relocateTextWidget() {
        Rectangle hostBounds = this.getHostFigure().getBounds().getCopy();
        FigureUtils.translateFigureToCanvas(this.getHostFigure().getParent(), hostBounds);
        Point textSize = this.m_textWidget.computeSize(-1, -1);
        if (this.m_initialSize != null) {
            textSize.x = Math.max(textSize.x, this.m_initialSize.x);
            textSize.y = Math.max(textSize.y, this.m_initialSize.y);
        } else {
            this.m_initialSize = textSize;
        }
        org.eclipse.wb.draw2d.geometry.Point textLocation = this.getTextWidgetLocation(hostBounds, new Dimension(textSize.x, textSize.y));
        this.m_textWidget.setBounds(textLocation.x, textLocation.y, textSize.x, textSize.y);
        Point oldSelection = this.m_textWidget.getSelection();
        this.m_textWidget.setSelection(0);
        this.m_textWidget.setSelection(oldSelection);
    }

    protected abstract org.eclipse.wb.draw2d.geometry.Point getTextWidgetLocation(Rectangle var1, Dimension var2);
}

