/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.core.model.property.editor.presentation;

import com.google.common.collect.Lists;
import java.util.List;
import org.eclipse.wb.internal.core.model.property.Property;
import org.eclipse.wb.internal.core.model.property.editor.presentation.PropertyEditorPresentation;
import org.eclipse.wb.internal.core.model.property.table.PropertyTable;

public class CompoundPropertyEditorPresentation
extends PropertyEditorPresentation {
    private final List<PropertyEditorPresentation> m_presentations = Lists.newArrayList();

    public void add(PropertyEditorPresentation presentation) {
        this.m_presentations.add(presentation);
    }

    public int show(PropertyTable propertyTable, Property property, int x, int y, int width, int height) {
        int sumWidth = 0;
        for (PropertyEditorPresentation presentation : this.m_presentations) {
            int presentationWidth = presentation.show(propertyTable, property, x, y, width, height);
            sumWidth += presentationWidth;
            width -= presentationWidth;
        }
        return sumWidth;
    }

    public void hide(PropertyTable propertyTable, Property property) {
        for (PropertyEditorPresentation presentation : this.m_presentations) {
            presentation.hide(propertyTable, property);
        }
    }
}

