/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.discovery.core;

import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.equinox.p2.core.IProvisioningAgent;
import org.eclipse.equinox.p2.core.IProvisioningAgentProvider;
import org.eclipse.equinox.p2.core.ProvisionException;
import org.eclipse.equinox.p2.engine.IProfile;
import org.eclipse.equinox.p2.engine.IProfileRegistry;
import org.eclipse.equinox.p2.query.IQueryResult;
import org.eclipse.equinox.p2.query.QueryUtil;
import org.eclipse.wb.internal.discovery.core.Messages;
import org.eclipse.wb.internal.discovery.core.WBDiscoveryCorePlugin;
import org.eclipse.wb.internal.discovery.core.WBToolkitFeature;
import org.osgi.framework.ServiceReference;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WBToolkit {
    private static IProfile installedProfile;
    private String name;
    private String title;
    private String id;
    private String description;
    private URL parentPath;
    private String iconPath;
    private String updateSite;
    private String auxiliaryUpdateSite;
    private List<WBToolkitFeature> features = new ArrayList<WBToolkitFeature>();
    private String providerName;
    private String licenseDescription;
    private String moreInfoURL;
    private List<String> osList = new ArrayList<String>();

    protected WBToolkit() {
    }

    public String getName() {
        return this.name;
    }

    protected void setName(String name) {
        this.name = name;
    }

    public String getTitle() {
        if (this.title != null) {
            return this.title;
        }
        return this.getName();
    }

    protected void setTitle(String title) {
        this.title = title;
    }

    public String getId() {
        return this.id;
    }

    protected void setId(String id) {
        this.id = id;
    }

    protected String getIconPath() {
        return this.iconPath;
    }

    public URL getIconURL() {
        if (this.iconPath == null) {
            return null;
        }
        try {
            String urlString = this.parentPath.toString();
            if (!urlString.endsWith("/")) {
                urlString = urlString.substring(0, urlString.length());
            }
            int index = urlString.lastIndexOf(47);
            urlString = urlString.substring(0, index);
            return new URL(String.valueOf(urlString) + "/" + this.iconPath);
        }
        catch (MalformedURLException malformedURLException) {
            return null;
        }
    }

    protected void setIconPath(URL parentPath, String iconPath) {
        this.parentPath = parentPath;
        this.iconPath = iconPath;
    }

    public String getLicenseDescription() {
        return this.licenseDescription;
    }

    protected void setLicenseDescription(String licenseDescription) {
        this.licenseDescription = licenseDescription;
    }

    public String getUpdateSite() {
        return this.updateSite;
    }

    protected void setUpdateSite(String updateSite) {
        this.updateSite = updateSite;
    }

    public URI getUpdateSiteURI() {
        block3: {
            try {
                if (this.getUpdateSite() != null) break block3;
                return null;
            }
            catch (URISyntaxException uRISyntaxException) {
                return null;
            }
        }
        return new URI(this.getUpdateSite());
    }

    public String getAuxiliaryUpdateSite() {
        return this.auxiliaryUpdateSite;
    }

    protected void setAuxiliaryUpdateSite(String updateSite) {
        this.auxiliaryUpdateSite = updateSite;
    }

    public URI getAuxiliaryUpdateSiteURI() {
        block3: {
            try {
                if (this.getAuxiliaryUpdateSite() != null) break block3;
                return null;
            }
            catch (URISyntaxException uRISyntaxException) {
                return null;
            }
        }
        return new URI(this.getAuxiliaryUpdateSite());
    }

    public List<WBToolkitFeature> getFeatures() {
        return Collections.unmodifiableList(this.features);
    }

    protected void addFeature(String featureId, boolean optional) {
        if (featureId != null && featureId.length() > 0) {
            this.features.add(new WBToolkitFeature(featureId, optional));
        }
    }

    public String getProviderName() {
        return this.providerName;
    }

    protected void setProviderName(String providerName) {
        this.providerName = providerName;
    }

    public String getProviderDescription() {
        if (this.licenseDescription != null) {
            return MessageFormat.format(Messages.WBToolkit_fromProviderLicense, this.getProviderName(), this.getLicenseDescription());
        }
        return MessageFormat.format(Messages.WBToolkit_fromProvider, this.getProviderName());
    }

    public String getMoreInfoURL() {
        return this.moreInfoURL;
    }

    protected void setMoreInfoURL(String moreInfoURL) {
        this.moreInfoURL = moreInfoURL;
    }

    public String getDescription() {
        return this.description;
    }

    protected void setDescription(String description) {
        this.description = description;
    }

    public List<String> getOsList() {
        return Collections.unmodifiableList(this.osList);
    }

    protected void setOsList(String[] oses) {
        this.osList.clear();
        this.osList.addAll((Collection<String>)Arrays.asList(oses));
    }

    public boolean supportsCurrentOS() {
        if (this.osList.size() == 0) {
            return true;
        }
        for (String os : this.osList) {
            if (!WBDiscoveryCorePlugin.getCurrentOS().equals(os)) continue;
            return true;
        }
        return false;
    }

    public boolean isInstalled() {
        if (this.getFeatures().size() == 0) {
            return false;
        }
        for (WBToolkitFeature feature : this.getFeatures()) {
            if (feature.isOptional() || this.isFeatureInstalled(feature)) continue;
            return false;
        }
        return true;
    }

    private boolean isFeatureInstalled(WBToolkitFeature feature) {
        IProfile profile = this.getCurrentProfile();
        if (profile == null) {
            return false;
        }
        IQueryResult results = installedProfile.available(QueryUtil.createIUQuery((String)(String.valueOf(feature.getFeatureId()) + ".feature.group")), (IProgressMonitor)new NullProgressMonitor());
        return !results.isEmpty();
    }

    private IProfile getCurrentProfile() {
        if (installedProfile == null) {
            ServiceReference sr = WBDiscoveryCorePlugin.getBundleContext().getServiceReference(IProvisioningAgentProvider.SERVICE_NAME);
            if (sr == null) {
                return null;
            }
            IProvisioningAgentProvider agentProvider = (IProvisioningAgentProvider)WBDiscoveryCorePlugin.getBundleContext().getService(sr);
            try {
                IProvisioningAgent agent = agentProvider.createAgent(null);
                IProfileRegistry profileRegistry = (IProfileRegistry)agent.getService(IProfileRegistry.SERVICE_NAME);
                installedProfile = profileRegistry.getProfile("_SELF_");
            }
            catch (ProvisionException provisionException) {
                return null;
            }
        }
        return installedProfile;
    }

    public boolean equals(Object object) {
        if (object instanceof WBToolkit) {
            WBToolkit other = (WBToolkit)object;
            return this.getName().equals(other.getName());
        }
        return false;
    }

    public int hashCode() {
        return this.getName().hashCode();
    }

    public String toString() {
        return this.getName();
    }
}

