/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtend.shared.ui;

import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IStorage;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.internal.xtend.xtend.parser.ErrorHandler;
import org.eclipse.internal.xtend.xtend.parser.XtendError;
import org.eclipse.xtend.expression.Resource;
import org.eclipse.xtend.shared.ui.ResourceContributor;
import org.eclipse.xtend.shared.ui.core.IXtendXpandResource;
import org.eclipse.xtend.shared.ui.core.builder.XtendXpandMarkerManager;

public abstract class ResourceContributorBase
implements ResourceContributor {
    protected ErrorHandler getErrorHandler(final IStorage source) {
        boolean cfr_ignored_0 = source instanceof IFile;
        return new ErrorHandler(){

            public void handleError(XtendError e) {
                if (e.getStart() >= 0 && source instanceof IFile) {
                    IFile f = (IFile)source;
                    XtendXpandMarkerManager.addErrorMarker(f, e.getMessage(), 2, e.getStart(), e.getEnd());
                }
            }
        };
    }

    protected abstract void logInfo(String var1);

    protected abstract void logError(String var1, Throwable var2);

    public final IXtendXpandResource create(IStorage file, String fqn) {
        Resource res = this.parse(file, fqn);
        if (res != null) {
            return this.createExtXptResource(res, file);
        }
        return null;
    }

    protected Reader createReader(IStorage resource) {
        try {
            InputStream in = resource.getContents();
            return new InputStreamReader(in);
        }
        catch (CoreException e1) {
            this.logInfo(e1.getMessage());
            return null;
        }
    }

    protected abstract Resource parse(IStorage var1, String var2);

    protected abstract IXtendXpandResource createExtXptResource(Resource var1, IStorage var2);
}

