/*******************************************************************************
 * Copyright (c) 2012 itemis AG (http://www.itemis.eu) and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *******************************************************************************/
package org.eclipse.xtext.xbase.typesystem.internal;

import java.util.List;

import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.xtext.common.types.JvmIdentifiableElement;
import org.eclipse.xtext.common.types.JvmTypeReference;
import org.eclipse.xtext.xbase.XExpression;
import org.eclipse.xtext.xbase.typesystem.IResolvedTypes;

/**
 * @author Sebastian Zarnekow - Initial contribution and API
 */
public class DelegatingResolvedTypes implements IResolvedTypes {

	private final IResolvedTypes delegate;

	public DelegatingResolvedTypes(IResolvedTypes delegate) {
		this.delegate = delegate;
	}
	
	protected IResolvedTypes getDelegate() {
		return delegate;
	}

	public List<Diagnostic> getQueuedDiagnostics() {
		return delegate.getQueuedDiagnostics();
	}

	public JvmTypeReference getActualType(XExpression expression) {
		return delegate.getActualType(expression);
	}

	public JvmTypeReference getActualType(JvmIdentifiableElement identifiable) {
		return delegate.getActualType(identifiable);
	}

	public JvmTypeReference getExpectedType(XExpression expression) {
		return delegate.getExpectedType(expression);
	}

	public List<JvmTypeReference> getActualTypeArguments(XExpression expression) {
		return delegate.getActualTypeArguments(expression);
	}
	
}
