/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.reviewdb;

import com.google.gerrit.reviewdb.Change;
import com.google.gwtorm.client.Column;
import com.google.gwtorm.client.CompoundKey;
import com.google.gwtorm.client.StringKey;

public final class TrackingId {
    public static final int TRACKING_ID_MAX_CHAR = 20;
    public static final int TRACKING_SYSTEM_MAX_CHAR = 10;
    @Column(id=1, name="--NONE--")
    protected Key key;

    protected TrackingId() {
    }

    public TrackingId(Change.Id ch, Id id, System s) {
        this.key = new Key(ch, id, s);
    }

    public TrackingId(Change.Id ch, String id, String s) {
        this.key = new Key(ch, new Id(id), new System(s));
    }

    public Change.Id getChangeId() {
        return this.key.changeId;
    }

    public String getTrackingId() {
        return this.key.trackingId.get();
    }

    public String getSystem() {
        return this.key.trackingSystem.get();
    }

    public int hashCode() {
        return this.key.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj instanceof TrackingId) {
            TrackingId tr = (TrackingId)obj;
            return tr.key.equals((Object)tr.key);
        }
        return false;
    }

    public static class Id
    extends StringKey<com.google.gwtorm.client.Key<?>> {
        private static final long serialVersionUID = 1L;
        @Column(id=1, length=20)
        protected String id;

        protected Id() {
        }

        public Id(String id) {
            this.id = id;
        }

        public String get() {
            return this.id;
        }

        protected void set(String newValue) {
            this.id = newValue;
        }
    }

    public static class Key
    extends CompoundKey<Change.Id> {
        private static final long serialVersionUID = 1L;
        @Column(id=1)
        protected Change.Id changeId;
        @Column(id=2)
        protected Id trackingId;
        @Column(id=3)
        protected System trackingSystem;

        protected Key() {
            this.changeId = new Change.Id();
            this.trackingId = new Id();
            this.trackingSystem = new System();
        }

        protected Key(Change.Id ch, Id id, System s) {
            this.changeId = ch;
            this.trackingId = id;
            this.trackingSystem = s;
        }

        public Change.Id getParentKey() {
            return this.changeId;
        }

        public com.google.gwtorm.client.Key<?>[] members() {
            return new com.google.gwtorm.client.Key[]{this.trackingId, this.trackingSystem};
        }
    }

    public static class System
    extends StringKey<com.google.gwtorm.client.Key<?>> {
        private static final long serialVersionUID = 1L;
        @Column(id=1, length=10)
        protected String system;

        protected System() {
        }

        public System(String s) {
            this.system = s;
        }

        public String get() {
            return this.system;
        }

        protected void set(String newValue) {
            this.system = newValue;
        }
    }
}

