/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.nattable.style.editor;

import net.sourceforge.nattable.util.GUIHelper;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.ColorDialog;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public class ColorPicker
extends CLabel {
    private Color selectedColor;
    private Image image;

    public ColorPicker(Composite parent, Color originalColor) {
        super(parent, 8);
        if (originalColor == null) {
            throw new IllegalArgumentException("null");
        }
        this.selectedColor = originalColor;
        this.setImage(this.getColorImage(originalColor));
        this.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDown(MouseEvent e) {
                ColorDialog dialog = new ColorDialog(new Shell(Display.getDefault(), 1264));
                dialog.setRGB(ColorPicker.this.selectedColor.getRGB());
                RGB selected = dialog.open();
                if (selected != null) {
                    ColorPicker.this.update(selected);
                }
            }
        });
    }

    private Image getColorImage(Color color) {
        Display display = Display.getCurrent();
        this.image = new Image((Device)display, new Rectangle(10, 10, 70, 20));
        GC gc = new GC((Drawable)this.image);
        gc.setBackground(color);
        gc.fillRectangle(this.image.getBounds());
        gc.dispose();
        return this.image;
    }

    private void update(RGB selected) {
        this.selectedColor = GUIHelper.getColor(selected);
        this.setImage(this.getColorImage(this.selectedColor));
    }

    public Color getSelectedColor() {
        return this.selectedColor;
    }

    public void setSelectedColor(Color backgroundColor) {
        if (backgroundColor == null) {
            throw new IllegalArgumentException("null");
        }
        this.update(backgroundColor.getRGB());
    }

    public void dispose() {
        super.dispose();
        this.image.dispose();
    }
}

