/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections.primitives;

import org.apache.commons.collections.primitives.ShortCollection;
import org.apache.commons.collections.primitives.ShortIterator;

public abstract class AbstractShortCollection
implements ShortCollection {
    public abstract ShortIterator iterator();

    public abstract int size();

    protected AbstractShortCollection() {
    }

    public boolean add(short element) {
        throw new UnsupportedOperationException("add(short) is not supported.");
    }

    public boolean addAll(ShortCollection c) {
        boolean modified = false;
        ShortIterator iter = c.iterator();
        while (iter.hasNext()) {
            modified |= this.add(iter.next());
        }
        return modified;
    }

    public void clear() {
        ShortIterator iter = this.iterator();
        while (iter.hasNext()) {
            iter.next();
            iter.remove();
        }
    }

    public boolean contains(short element) {
        ShortIterator iter = this.iterator();
        while (iter.hasNext()) {
            if (iter.next() != element) continue;
            return true;
        }
        return false;
    }

    public boolean containsAll(ShortCollection c) {
        ShortIterator iter = c.iterator();
        while (iter.hasNext()) {
            if (this.contains(iter.next())) continue;
            return false;
        }
        return true;
    }

    public boolean isEmpty() {
        return this.size() == 0;
    }

    public boolean removeElement(short element) {
        ShortIterator iter = this.iterator();
        while (iter.hasNext()) {
            if (iter.next() != element) continue;
            iter.remove();
            return true;
        }
        return false;
    }

    public boolean removeAll(ShortCollection c) {
        boolean modified = false;
        ShortIterator iter = c.iterator();
        while (iter.hasNext()) {
            modified |= this.removeElement(iter.next());
        }
        return modified;
    }

    public boolean retainAll(ShortCollection c) {
        boolean modified = false;
        ShortIterator iter = this.iterator();
        while (iter.hasNext()) {
            if (c.contains(iter.next())) continue;
            iter.remove();
            modified = true;
        }
        return modified;
    }

    public short[] toArray() {
        short[] array = new short[this.size()];
        int i = 0;
        ShortIterator iter = this.iterator();
        while (iter.hasNext()) {
            array[i] = iter.next();
            ++i;
        }
        return array;
    }

    public short[] toArray(short[] a) {
        if (a.length < this.size()) {
            return this.toArray();
        }
        int i = 0;
        ShortIterator iter = this.iterator();
        while (iter.hasNext()) {
            a[i] = iter.next();
            ++i;
        }
        return a;
    }
}

