/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections.primitives.adapters;

import java.lang.reflect.Array;
import java.util.Collection;
import java.util.Iterator;
import org.apache.commons.collections.primitives.FloatCollection;
import org.apache.commons.collections.primitives.adapters.CollectionFloatCollection;
import org.apache.commons.collections.primitives.adapters.FloatIteratorIterator;

abstract class AbstractFloatCollectionCollection
implements Collection {
    AbstractFloatCollectionCollection() {
    }

    public boolean add(Object element) {
        return this.getFloatCollection().add(((Number)element).floatValue());
    }

    public boolean addAll(Collection c) {
        return this.getFloatCollection().addAll(CollectionFloatCollection.wrap(c));
    }

    public void clear() {
        this.getFloatCollection().clear();
    }

    public boolean contains(Object element) {
        return this.getFloatCollection().contains(((Number)element).floatValue());
    }

    public boolean containsAll(Collection c) {
        return this.getFloatCollection().containsAll(CollectionFloatCollection.wrap(c));
    }

    public String toString() {
        return this.getFloatCollection().toString();
    }

    public boolean isEmpty() {
        return this.getFloatCollection().isEmpty();
    }

    public Iterator iterator() {
        return FloatIteratorIterator.wrap(this.getFloatCollection().iterator());
    }

    public boolean remove(Object element) {
        return this.getFloatCollection().removeElement(((Number)element).floatValue());
    }

    public boolean removeAll(Collection c) {
        return this.getFloatCollection().removeAll(CollectionFloatCollection.wrap(c));
    }

    public boolean retainAll(Collection c) {
        return this.getFloatCollection().retainAll(CollectionFloatCollection.wrap(c));
    }

    public int size() {
        return this.getFloatCollection().size();
    }

    public Object[] toArray() {
        float[] a = this.getFloatCollection().toArray();
        Object[] A = new Object[a.length];
        int i = 0;
        while (i < a.length) {
            A[i] = new Float(a[i]);
            ++i;
        }
        return A;
    }

    public Object[] toArray(Object[] A) {
        float[] a = this.getFloatCollection().toArray();
        if (A.length < a.length) {
            A = (Object[])Array.newInstance(A.getClass().getComponentType(), a.length);
        }
        int i = 0;
        while (i < a.length) {
            A[i] = new Float(a[i]);
            ++i;
        }
        if (A.length > a.length) {
            A[a.length] = null;
        }
        return A;
    }

    protected abstract FloatCollection getFloatCollection();
}

