/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.client.net;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Collections;
import java.util.Enumeration;
import java.util.LinkedList;
import java.util.List;
import javax.sql.XAConnection;
import javax.transaction.xa.XAException;
import javax.transaction.xa.XAResource;
import javax.transaction.xa.Xid;
import org.apache.derby.client.ClientXid;
import org.apache.derby.client.am.ClientMessageId;
import org.apache.derby.client.am.SqlCode;
import org.apache.derby.client.am.SqlException;
import org.apache.derby.client.am.Utils;
import org.apache.derby.client.am.XaException;
import org.apache.derby.client.net.NetAgent;
import org.apache.derby.client.net.NetConnection;
import org.apache.derby.client.net.NetXACallInfo;
import org.apache.derby.client.net.NetXAConnection;

public class NetXAResource
implements XAResource {
    public static final int TMTIMEOUT = 256;
    public static final int ACTIVE_ONLY = -1;
    public static final int XA_NULL_XID = -1;
    public static final int INITIAL_CALLINFO_ELEMENTS = 1;
    public static final int RECOVER_XID_ARRAY_LENGTH = 10;
    public static final ClientXid nullXid = new ClientXid();
    public static final int XAFUNC_NONE = 0;
    public static final int XAFUNC_COMMIT = 1;
    public static final int XAFUNC_END = 2;
    public static final int XAFUNC_FORGET = 3;
    public static final int XAFUNC_PREPARE = 4;
    public static final int XAFUNC_RECOVER = 5;
    public static final int XAFUNC_ROLLBACK = 6;
    public static final int XAFUNC_START = 7;
    public static final String XAFUNCSTR_NONE = "No XA Function";
    public static final String XAFUNCSTR_COMMIT = "XAResource.commit()";
    public static final String XAFUNCSTR_END = "XAResource.end()";
    public static final String XAFUNCSTR_FORGET = "XAResource.forget()";
    public static final String XAFUNCSTR_PREPARE = "XAResource.prepare()";
    public static final String XAFUNCSTR_RECOVER = "XAResource.recover()";
    public static final String XAFUNCSTR_ROLLBACK = "XAResource.rollback()";
    public static final String XAFUNCSTR_START = "XAResource.start()";
    public SqlException exceptionsOnXA = null;
    XAConnection xaconn_;
    NetXAConnection netXAConn_;
    NetConnection conn_;
    int rmId_;
    NetXACallInfo[] callInfoArray_ = new NetXACallInfo[1];
    int numXACallInfo_ = 1;
    int connectionCount_ = 1;
    int activeXATransCount_ = 0;
    String rmIdx_;
    String rmIdy_;
    int port_;
    String ipaddr_;
    private List specialRegisters_ = Collections.synchronizedList(new LinkedList());
    private int timeoutSeconds = 0;

    public NetXAResource(XAConnection xaconn, int rmId, String userId, String password, NetXAConnection conn) {
        this.xaconn_ = xaconn;
        this.rmId_ = rmId;
        this.conn_ = conn.getNetConnection();
        this.netXAConn_ = conn;
        this.rmIdx_ = userId;
        this.rmIdy_ = password;
        this.port_ = this.conn_.netAgent_.getPort();
        this.ipaddr_ = this.conn_.netAgent_.socket_.getLocalAddress().getHostAddress();
        conn.setNetXAResource(this);
        this.conn_.currXACallInfoOffset_ = 0;
        for (int i = 0; i < 1; ++i) {
            this.callInfoArray_[i] = new NetXACallInfo(null, 0, this, null);
        }
        this.callInfoArray_[0].actualConn_ = conn;
        this.callInfoArray_[0].currConnection_ = true;
        this.callInfoArray_[0].freeEntry_ = false;
        this.callInfoArray_[0].saveConnectionVariables();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void commit(Xid xid, boolean onePhase) throws XAException {
        NetAgent netAgent = this.conn_.netAgent_;
        int rc = 0;
        this.exceptionsOnXA = null;
        if (this.conn_.agent_.loggingEnabled()) {
            this.conn_.agent_.logWriter_.traceEntry((Object)this, "commit", (Object)xid, onePhase);
        }
        if (this.conn_.isPhysicalConnClosed()) {
            this.connectionClosedFailure();
        }
        NetXACallInfo callInfo = this.callInfoArray_[this.conn_.currXACallInfoOffset_];
        callInfo.xaFlags_ = onePhase ? 0x40000000 : 0;
        callInfo.xid_ = xid;
        callInfo.xaResource_ = this;
        callInfo.xaRetVal_ = 0;
        try {
            netAgent.beginWriteChainOutsideUOW();
            netAgent.netConnectionRequest_.writeXaCommit(this.conn_, xid);
            netAgent.flowOutsideUOW();
            netAgent.netConnectionReply_.readXaCommit(this.conn_);
            if (callInfo.xaRetVal_ != 0) {
                callInfo.xaFunction_ = 1;
                rc = this.xaRetValErrorAccumSQL(callInfo, rc);
                callInfo.xaRetVal_ = 0;
            }
            netAgent.endReadChain();
        }
        catch (SqlException sqle) {
            rc = this.getSqlExceptionXAErrorCode(sqle);
            this.exceptionsOnXA = Utils.accumulateSQLException(sqle, this.exceptionsOnXA);
        }
        finally {
            this.conn_.pendingEndXACallinfoOffset_ = -1;
        }
        if (rc != 0) {
            this.throwXAException(rc, false);
        }
    }

    private int getSqlExceptionXAErrorCode(SqlException sqle) {
        int seErrorCode = sqle.getErrorCode();
        return seErrorCode == 40000 ? -7 : -3;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void end(Xid xid, int flags) throws XAException {
        NetAgent netAgent = this.conn_.netAgent_;
        int rc = 0;
        this.exceptionsOnXA = null;
        if (this.conn_.agent_.loggingEnabled()) {
            this.conn_.agent_.logWriter_.traceEntry((Object)this, "end", (Object)xid, flags);
        }
        if (this.conn_.isPhysicalConnClosed()) {
            this.connectionClosedFailure();
        }
        NetXACallInfo callInfo = this.callInfoArray_[this.conn_.currXACallInfoOffset_];
        callInfo.setReadOnlyTransactionFlag(this.conn_.readOnlyTransaction_);
        callInfo.xaFlags_ = flags;
        callInfo.xid_ = xid;
        callInfo.xaResource_ = this;
        callInfo.xaRetVal_ = 0;
        try {
            netAgent.beginWriteChainOutsideUOW();
            netAgent.netConnectionRequest_.writeXaEndUnitOfWork(this.conn_);
            netAgent.flowOutsideUOW();
            rc = netAgent.netConnectionReply_.readXaEndUnitOfWork(this.conn_);
            this.conn_.pendingEndXACallinfoOffset_ = -1;
            if (callInfo.xaRetVal_ != 0) {
                callInfo.xaFunction_ = 2;
                rc = this.xaRetValErrorAccumSQL(callInfo, rc);
                callInfo.xaRetVal_ = 0;
            }
            netAgent.endReadChain();
        }
        catch (SqlException sqle) {
            rc = this.getSqlExceptionXAErrorCode(sqle);
            this.exceptionsOnXA = Utils.accumulateSQLException(sqle, this.exceptionsOnXA);
        }
        finally {
            this.conn_.pendingEndXACallinfoOffset_ = -1;
        }
        if (rc != 0) {
            this.throwXAException(rc, false);
        } else {
            this.conn_.setXAState(0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void forget(Xid xid) throws XAException {
        NetAgent netAgent = this.conn_.netAgent_;
        int rc = 0;
        this.exceptionsOnXA = null;
        if (this.conn_.agent_.loggingEnabled()) {
            this.conn_.agent_.logWriter_.traceEntry((Object)this, "forget", xid);
        }
        if (this.conn_.isPhysicalConnClosed()) {
            this.connectionClosedFailure();
        }
        NetXACallInfo callInfo = this.callInfoArray_[this.conn_.currXACallInfoOffset_];
        callInfo.xid_ = xid;
        callInfo.xaResource_ = this;
        callInfo.xaRetVal_ = 0;
        try {
            netAgent.beginWriteChainOutsideUOW();
            netAgent.netConnectionRequest_.writeXaForget(netAgent.netConnection_, xid);
            netAgent.flowOutsideUOW();
            netAgent.netConnectionReply_.readXaForget(netAgent.netConnection_);
            netAgent.endReadChain();
            if (callInfo.xaRetVal_ != 0) {
                callInfo.xaFunction_ = 3;
                rc = this.xaRetValErrorAccumSQL(callInfo, rc);
                callInfo.xaRetVal_ = 0;
            }
        }
        catch (SqlException sqle) {
            this.exceptionsOnXA = Utils.accumulateSQLException(sqle, this.exceptionsOnXA);
            this.throwXAException(this.getSqlExceptionXAErrorCode(sqle));
        }
        finally {
            this.conn_.pendingEndXACallinfoOffset_ = -1;
        }
        if (rc != 0) {
            this.throwXAException(rc, false);
        }
    }

    public int getTransactionTimeout() throws XAException {
        if (this.conn_.agent_.loggingEnabled()) {
            this.conn_.agent_.logWriter_.traceEntry(this, "getTransactionTimeout");
        }
        this.exceptionsOnXA = null;
        if (this.conn_.isPhysicalConnClosed()) {
            this.connectionClosedFailure();
        }
        if (this.conn_.agent_.loggingEnabled()) {
            this.conn_.agent_.logWriter_.traceExit((Object)this, "getTransactionTimeout", this.timeoutSeconds);
        }
        return this.timeoutSeconds;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int prepare(Xid xid) throws XAException {
        this.exceptionsOnXA = null;
        if (this.conn_.agent_.loggingEnabled()) {
            this.conn_.agent_.logWriter_.traceEntry((Object)this, "prepare", xid);
        }
        if (this.conn_.isPhysicalConnClosed()) {
            this.connectionClosedFailure();
        }
        NetAgent netAgent = this.conn_.netAgent_;
        int rc = 0;
        NetXACallInfo callInfo = this.callInfoArray_[this.conn_.currXACallInfoOffset_];
        callInfo.xid_ = xid;
        callInfo.xaResource_ = this;
        callInfo.xaRetVal_ = 0;
        try {
            netAgent.beginWriteChainOutsideUOW();
            netAgent.netConnectionRequest_.writeXaPrepare(this.conn_);
            netAgent.flowOutsideUOW();
            rc = netAgent.netConnectionReply_.readXaPrepare(this.conn_);
            if (callInfo.xaRetVal_ != 0 && callInfo.xaRetVal_ != 3) {
                callInfo.xaFunction_ = 4;
                rc = this.xaRetValErrorAccumSQL(callInfo, rc);
                callInfo.xaRetVal_ = 0;
            }
            netAgent.endReadChain();
        }
        catch (SqlException sqle) {
            rc = this.getSqlExceptionXAErrorCode(sqle);
            this.exceptionsOnXA = Utils.accumulateSQLException(sqle, this.exceptionsOnXA);
        }
        finally {
            this.conn_.pendingEndXACallinfoOffset_ = -1;
        }
        if (rc != 0 && rc != 3) {
            this.throwXAException(rc, false);
        }
        if (this.conn_.agent_.loggingEnabled()) {
            this.conn_.agent_.logWriter_.traceExit((Object)this, "prepare", rc);
        }
        return rc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Xid[] recover(int flag) throws XAException {
        int rc = 0;
        NetAgent netAgent = this.conn_.netAgent_;
        if (this.conn_.agent_.loggingEnabled()) {
            this.conn_.agent_.logWriter_.traceEntry((Object)this, "recover", flag);
        }
        this.exceptionsOnXA = null;
        if (this.conn_.isPhysicalConnClosed()) {
            this.connectionClosedFailure();
        }
        Xid[] xidList = null;
        int numXid = 0;
        NetXACallInfo callInfo = this.callInfoArray_[this.conn_.currXACallInfoOffset_];
        callInfo.xaFlags_ = flag;
        callInfo.xaResource_ = this;
        callInfo.xaRetVal_ = 0;
        try {
            netAgent.beginWriteChainOutsideUOW();
            netAgent.netConnectionRequest_.writeXaRecover(this.conn_, flag);
            netAgent.flowOutsideUOW();
            netAgent.netConnectionReply_.readXaRecover(this.conn_);
            if (callInfo.xaRetVal_ != 0) {
                callInfo.xaFunction_ = 5;
                rc = this.xaRetValErrorAccumSQL(callInfo, rc);
                callInfo.xaRetVal_ = 0;
            }
            netAgent.endReadChain();
            if (this.conn_.indoubtTransactions_ != null) {
                numXid = this.conn_.indoubtTransactions_.size();
                xidList = new Xid[numXid];
                int i = 0;
                Enumeration e = this.conn_.indoubtTransactions_.keys();
                while (e.hasMoreElements()) {
                    xidList[i] = (Xid)e.nextElement();
                    ++i;
                }
            }
        }
        catch (SqlException sqle) {
            rc = this.getSqlExceptionXAErrorCode(sqle);
            this.exceptionsOnXA = Utils.accumulateSQLException(sqle, this.exceptionsOnXA);
        }
        finally {
            this.conn_.pendingEndXACallinfoOffset_ = -1;
        }
        if (rc != 0) {
            this.throwXAException(rc, false);
        }
        if (this.conn_.agent_.loggingEnabled()) {
            this.conn_.agent_.logWriter_.traceExit((Object)this, "recover", xidList);
        }
        return xidList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void rollback(Xid xid) throws XAException {
        NetAgent netAgent = this.conn_.netAgent_;
        int rc = 0;
        this.exceptionsOnXA = null;
        if (this.conn_.agent_.loggingEnabled()) {
            this.conn_.agent_.logWriter_.traceEntry((Object)this, "rollback", xid);
        }
        if (this.conn_.isPhysicalConnClosed()) {
            this.connectionClosedFailure();
        }
        NetXACallInfo callInfo = this.callInfoArray_[this.conn_.currXACallInfoOffset_];
        callInfo.xid_ = xid;
        callInfo.xaResource_ = this;
        callInfo.xaRetVal_ = 0;
        try {
            netAgent.beginWriteChainOutsideUOW();
            netAgent.netConnectionRequest_.writeXaRollback(this.conn_, xid);
            netAgent.flowOutsideUOW();
            rc = netAgent.netConnectionReply_.readXaRollback(this.conn_);
            netAgent.endReadChain();
            if (callInfo.xaRetVal_ != 0) {
                callInfo.xaFunction_ = 2;
                rc = this.xaRetValErrorAccumSQL(callInfo, rc);
                callInfo.xaRetVal_ = 0;
            }
        }
        catch (SqlException sqle) {
            rc = this.getSqlExceptionXAErrorCode(sqle);
            this.exceptionsOnXA = Utils.accumulateSQLException(sqle, this.exceptionsOnXA);
        }
        finally {
            this.conn_.pendingEndXACallinfoOffset_ = -1;
        }
        if (rc != 0) {
            this.throwXAException(rc, false);
        }
    }

    public boolean setTransactionTimeout(int seconds) throws XAException {
        if (this.conn_.agent_.loggingEnabled()) {
            this.conn_.agent_.logWriter_.traceEntry(this, "setTransactionTimeout");
        }
        if (seconds < 0) {
            throw new XAException(-5);
        }
        this.exceptionsOnXA = null;
        this.timeoutSeconds = seconds;
        if (this.conn_.agent_.loggingEnabled()) {
            this.conn_.agent_.logWriter_.traceExit((Object)this, "setTransactionTimeout", true);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void start(Xid xid, int flags) throws XAException {
        NetAgent netAgent = this.conn_.netAgent_;
        int rc = 0;
        this.exceptionsOnXA = null;
        if (this.conn_.agent_.loggingEnabled()) {
            this.conn_.agent_.logWriter_.traceEntry((Object)this, "start", (Object)xid, flags);
        }
        if (this.conn_.isPhysicalConnClosed()) {
            this.connectionClosedFailure();
        }
        try {
            if (this.conn_.autoCommit_) {
                this.conn_.flowAutoCommit();
            }
        }
        catch (SqlException sqle) {
            rc = this.getSqlExceptionXAErrorCode(sqle);
            this.exceptionsOnXA = Utils.accumulateSQLException(sqle, this.exceptionsOnXA);
        }
        NetXACallInfo callInfo = this.callInfoArray_[this.conn_.currXACallInfoOffset_];
        callInfo.xaFlags_ = flags;
        callInfo.xaInProgress_ = true;
        callInfo.xid_ = xid;
        callInfo.xaResource_ = this;
        callInfo.xaRetVal_ = 0;
        if (flags == 0) {
            if (this.timeoutSeconds == Integer.MAX_VALUE) {
                callInfo.xaTimeoutMillis_ = 0L;
            } else if (this.timeoutSeconds > 0) {
                callInfo.xaTimeoutMillis_ = 1000 * this.timeoutSeconds;
            } else if (this.timeoutSeconds == 0) {
                callInfo.xaTimeoutMillis_ = -1L;
            } else {
                this.throwXAException(-3);
            }
        }
        try {
            netAgent.beginWriteChainOutsideUOW();
            netAgent.netConnectionRequest_.writeXaStartUnitOfWork(this.conn_);
            netAgent.flowOutsideUOW();
            netAgent.netConnectionReply_.readXaStartUnitOfWork(this.conn_);
            if (callInfo.xaRetVal_ != 0) {
                callInfo.xaFunction_ = 7;
                rc = this.xaRetValErrorAccumSQL(callInfo, rc);
                callInfo.xaRetVal_ = 0;
            }
            if (rc == 0) {
                this.conn_.setXAState(1);
            }
        }
        catch (SqlException sqle) {
            rc = this.getSqlExceptionXAErrorCode(sqle);
            this.exceptionsOnXA = Utils.accumulateSQLException(sqle, this.exceptionsOnXA);
        }
        finally {
            this.conn_.pendingEndXACallinfoOffset_ = -1;
        }
        if (rc != 0) {
            this.throwXAException(rc, false);
        }
    }

    protected void throwXAException(int rc) throws XAException {
        this.throwXAException(rc, rc != -4);
    }

    private String getXAExceptionText(int rc) {
        String xaExceptionText;
        switch (rc) {
            case 100: {
                xaExceptionText = "XA_RBROLLBACK";
                break;
            }
            case 101: {
                xaExceptionText = "XA_RBCOMMFAIL";
                break;
            }
            case 102: {
                xaExceptionText = "XA_RBDEADLOCK";
                break;
            }
            case 103: {
                xaExceptionText = "XA_RBINTEGRITY";
                break;
            }
            case 104: {
                xaExceptionText = "XA_RBOTHER";
                break;
            }
            case 105: {
                xaExceptionText = "XA_RBPROTO";
                break;
            }
            case 106: {
                xaExceptionText = "XA_RBTIMEOUT";
                break;
            }
            case 107: {
                xaExceptionText = "XA_RBTRANSIENT";
                break;
            }
            case 9: {
                xaExceptionText = "XA_NOMIGRATE";
                break;
            }
            case 8: {
                xaExceptionText = "XA_HEURHAZ";
                break;
            }
            case 7: {
                xaExceptionText = "XA_HEURCOM";
                break;
            }
            case 6: {
                xaExceptionText = "XA_HEURRB";
                break;
            }
            case 5: {
                xaExceptionText = "XA_HEURMIX";
                break;
            }
            case 4: {
                xaExceptionText = "XA_RETRY";
                break;
            }
            case 3: {
                xaExceptionText = "XA_RDONLY";
                break;
            }
            case -2: {
                xaExceptionText = "XAER_ASYNC";
                break;
            }
            case -3: {
                xaExceptionText = "XAER_RMERR";
                break;
            }
            case -4: {
                xaExceptionText = "XAER_NOTA";
                break;
            }
            case -5: {
                xaExceptionText = "XAER_INVAL";
                break;
            }
            case -6: {
                xaExceptionText = "XAER_PROTO";
                break;
            }
            case -7: {
                xaExceptionText = "XAER_RMFAIL";
                break;
            }
            case -8: {
                xaExceptionText = "XAER_DUPID";
                break;
            }
            case -9: {
                xaExceptionText = "XAER_OUTSIDE";
                break;
            }
            case 0: {
                xaExceptionText = "XA_OK";
                break;
            }
            default: {
                xaExceptionText = "Unknown Error";
            }
        }
        return xaExceptionText;
    }

    protected void throwXAException(int rc, boolean resetFlag) throws XAException {
        if (resetFlag) {
            NetXACallInfo callInfo = this.callInfoArray_[this.conn_.currXACallInfoOffset_];
            callInfo.xaInProgress_ = false;
            callInfo.xaWasSuspended = false;
        }
        String xaExceptionText = this.getXAExceptionText(rc);
        SqlException sqlExceptions = this.exceptionsOnXA;
        while (this.exceptionsOnXA != null) {
            xaExceptionText = xaExceptionText + " : " + this.exceptionsOnXA.getMessage();
            this.exceptionsOnXA = this.exceptionsOnXA.getNextException();
        }
        XaException xaException = new XaException(this.conn_.agent_.logWriter_, (Throwable)sqlExceptions, xaExceptionText);
        xaException.errorCode = rc;
        this.setXaStateForXAException(rc);
        throw xaException;
    }

    private void setXaStateForXAException(int rc) {
        switch (rc) {
            case -7: 
            case -3: 
            case 100: 
            case 101: 
            case 102: 
            case 103: 
            case 104: 
            case 105: 
            case 106: 
            case 107: {
                this.conn_.setXAState(0);
                break;
            }
            default: {
                return;
            }
        }
    }

    public boolean isSameRM(XAResource xares) throws XAException {
        boolean isSame = false;
        this.exceptionsOnXA = null;
        if (this.conn_.agent_.loggingEnabled()) {
            this.conn_.agent_.logWriter_.traceEntry((Object)this, "isSameRM", xares);
        }
        if (this.conn_.isPhysicalConnClosed()) {
            this.connectionClosedFailure();
        }
        if (xares instanceof NetXAResource) {
            NetXAResource derbyxares = (NetXAResource)xares;
            if (this.conn_.databaseName_.equalsIgnoreCase(derbyxares.conn_.databaseName_)) {
                if (!this.conn_.netAgent_.server_.equalsIgnoreCase(derbyxares.conn_.netAgent_.server_)) {
                    try {
                        String server1 = this.processLocalHost(this.conn_.netAgent_.server_);
                        String server2 = this.processLocalHost(derbyxares.conn_.netAgent_.server_);
                        InetAddress serverIP1 = InetAddress.getByName(server1);
                        InetAddress serverIP2 = InetAddress.getByName(server2);
                        if (!serverIP1.equals(serverIP2)) {
                        }
                    }
                    catch (UnknownHostException ue) {}
                } else if (this.conn_.netAgent_.port_ == derbyxares.conn_.netAgent_.port_) {
                    isSame = true;
                }
            }
        }
        if (this.conn_.agent_.loggingEnabled()) {
            this.conn_.agent_.logWriter_.traceExit((Object)this, "isSameRM", isSame);
        }
        return isSame;
    }

    public static boolean xidsEqual(Xid xid1, Xid xid2) {
        int i;
        if (xid1.getFormatId() != xid2.getFormatId()) {
            return false;
        }
        int xid1Length = xid1.getGlobalTransactionId().length;
        if (xid1Length != xid2.getGlobalTransactionId().length) {
            return false;
        }
        byte[] xid1Bytes = xid1.getGlobalTransactionId();
        byte[] xid2Bytes = xid2.getGlobalTransactionId();
        for (i = 0; i < xid1Length; ++i) {
            if (xid1Bytes[i] == xid2Bytes[i]) continue;
            return false;
        }
        xid1Length = xid1.getBranchQualifier().length;
        if (xid1Length != xid2.getBranchQualifier().length) {
            return false;
        }
        xid1Bytes = xid1.getBranchQualifier();
        xid2Bytes = xid2.getBranchQualifier();
        for (i = 0; i < xid1Length; ++i) {
            if (xid1Bytes[i] == xid2Bytes[i]) continue;
            return false;
        }
        return true;
    }

    public List getSpecialRegisters() {
        return this.specialRegisters_;
    }

    public void addSpecialRegisters(String s) {
        if (s.substring(0, 1).equals("@")) {
            if (this.specialRegisters_.remove(s.substring(1))) {
                this.specialRegisters_.remove(s);
                this.specialRegisters_.add(s.substring(1));
            } else {
                this.specialRegisters_.remove(s);
                this.specialRegisters_.add(s);
            }
        } else {
            this.specialRegisters_.remove(s);
            this.specialRegisters_.add(s);
        }
    }

    private void connectionClosedFailure() throws XAException {
        this.exceptionsOnXA = Utils.accumulateSQLException(new SqlException(null, new ClientMessageId("08003")), this.exceptionsOnXA);
        this.throwXAException(-7);
    }

    private String getXAFuncStr(int xaFunc) {
        switch (xaFunc) {
            case 1: {
                return XAFUNCSTR_COMMIT;
            }
            case 2: {
                return XAFUNCSTR_END;
            }
            case 3: {
                return XAFUNCSTR_FORGET;
            }
            case 4: {
                return XAFUNCSTR_PREPARE;
            }
            case 5: {
                return XAFUNCSTR_RECOVER;
            }
            case 6: {
                return XAFUNCSTR_ROLLBACK;
            }
            case 7: {
                return XAFUNCSTR_START;
            }
        }
        return XAFUNCSTR_NONE;
    }

    protected int xaRetValErrorAccumSQL(NetXACallInfo callInfo, int currentRC) {
        int rc = callInfo.xaRetVal_;
        if (rc != 0) {
            SqlException accumSql = new SqlException(this.conn_.netAgent_.logWriter_, new ClientMessageId("XN019.S"), (Object)this.getXAFuncStr(callInfo.xaFunction_), (Object)this.getXAExceptionText(rc), SqlCode.queuedXAError);
            this.exceptionsOnXA = Utils.accumulateSQLException(accumSql, this.exceptionsOnXA);
            if (currentRC != 0 && currentRC < 0) {
                return currentRC;
            }
        }
        return rc;
    }

    private String processLocalHost(String serverName) {
        if (serverName.equalsIgnoreCase("localhost")) {
            try {
                InetAddress localhostNameIA = InetAddress.getLocalHost();
                String localhostName = localhostNameIA.getHostName();
                return localhostName;
            }
            catch (SecurityException se) {
                return serverName;
            }
            catch (UnknownHostException ue) {
                return serverName;
            }
        }
        return serverName;
    }
}

