/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.client.net;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.Arrays;
import org.apache.derby.client.am.Agent;
import org.apache.derby.client.am.ClientMessageId;
import org.apache.derby.client.am.DisconnectException;
import org.apache.derby.client.am.SignedBinary;
import org.apache.derby.client.am.SqlException;
import org.apache.derby.client.net.CcsidManager;
import org.apache.derby.client.net.CodePoint;
import org.apache.derby.client.net.NetAgent;
import org.apache.derby.client.net.NetLogWriter;

public class Reply {
    protected Agent agent_;
    protected NetAgent netAgent_;
    private CcsidManager ccsidManager_;
    protected static final int DEFAULT_BUFFER_SIZE = Short.MAX_VALUE;
    protected byte[] buffer_;
    protected int pos_;
    protected int count_;
    private int topDdmCollectionStack_;
    private static final int MAX_MARKS_NESTING = 10;
    private int[] ddmCollectionLenStack_;
    private int ddmScalarLen_;
    private static final int EMPTY_STACK = -1;
    protected boolean ensuredLengthForDecryption_ = false;
    protected byte[] longBufferForDecryption_ = null;
    protected int longPosForDecryption_ = 0;
    protected byte[] longValueForDecryption_ = null;
    protected int longCountForDecryption_ = 0;
    protected int dssLength_;
    protected boolean dssIsContinued_;
    private boolean dssIsChainedWithSameID_;
    private boolean dssIsChainedWithDiffID_;
    protected int dssCorrelationID_;
    protected int peekedLength_ = 0;
    protected int peekedCodePoint_ = -1;
    private int peekedNumOfExtendedLenBytes_ = 0;
    private int currentPos_ = 0;
    public static final int END_OF_COLLECTION = -1;
    public static final int END_OF_SAME_ID_CHAIN = -2;

    Reply(NetAgent netAgent, int bufferSize) {
        this.buffer_ = new byte[bufferSize];
        this.netAgent_ = netAgent;
        this.agent_ = this.netAgent_;
        this.ccsidManager_ = netAgent.targetCcsidManager_;
        this.ddmCollectionLenStack_ = new int[10];
        this.initialize();
    }

    final void initialize() {
        this.pos_ = 0;
        this.count_ = 0;
        this.topDdmCollectionStack_ = -1;
        Arrays.fill(this.ddmCollectionLenStack_, 0);
        this.ddmScalarLen_ = 0;
        this.dssLength_ = 0;
        this.dssIsContinued_ = false;
        this.dssIsChainedWithSameID_ = false;
        this.dssIsChainedWithDiffID_ = false;
        this.dssCorrelationID_ = 1;
    }

    final int getDdmLength() {
        return this.ddmScalarLen_;
    }

    private final void shiftBuffer(byte[] destinationBuffer) {
        int sz = this.count_ - this.pos_;
        System.arraycopy(this.buffer_, this.pos_, destinationBuffer, 0, sz);
        this.pos_ = 0;
        this.count_ = sz;
        this.buffer_ = destinationBuffer;
    }

    protected final void ensureSpaceInBufferForFill(int desiredSpace) {
        int currentAvailableSpace = this.buffer_.length - this.count_ + this.pos_;
        if (currentAvailableSpace < desiredSpace) {
            int minumNewBufferSize = desiredSpace - currentAvailableSpace + this.buffer_.length;
            int doubleBufferSize = 2 * this.buffer_.length;
            int newsz = minumNewBufferSize <= doubleBufferSize ? doubleBufferSize : minumNewBufferSize;
            byte[] newBuffer = new byte[newsz];
            this.shiftBuffer(newBuffer);
        } else if (this.pos_ != 0) {
            this.shiftBuffer(this.buffer_);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int fill(int minimumBytesNeeded) throws DisconnectException {
        this.ensureSpaceInBufferForFill(minimumBytesNeeded);
        int totalBytesRead = 0;
        int actualBytesRead = 0;
        do {
            try {
                actualBytesRead = this.netAgent_.getInputStream().read(this.buffer_, this.count_, this.buffer_.length - this.count_);
            }
            catch (IOException ioe) {
                this.netAgent_.throwCommunicationsFailure(ioe);
            }
            finally {
                if (this.agent_.loggingEnabled()) {
                    ((NetLogWriter)this.netAgent_.logWriter_).traceProtocolFlow(this.buffer_, this.count_, actualBytesRead, 2, "Reply", "fill", 2);
                }
            }
            if (actualBytesRead <= 0) continue;
            this.count_ += actualBytesRead;
            totalBytesRead += actualBytesRead;
        } while (totalBytesRead < minimumBytesNeeded && actualBytesRead != -1);
        if (actualBytesRead == -1 && totalBytesRead < minimumBytesNeeded) {
            this.netAgent_.accumulateChainBreakingReadExceptionAndThrow(new DisconnectException((Agent)this.netAgent_, new ClientMessageId("08006.C.5"), (Object)new Integer(minimumBytesNeeded), (Object)new Integer(totalBytesRead)));
        }
        return totalBytesRead;
    }

    protected final int ensureALayerDataInBuffer(int desiredDataSize) throws DisconnectException {
        int totalBytesRead = 0;
        int avail = this.count_ - this.pos_;
        if (avail < desiredDataSize) {
            totalBytesRead = this.fill(desiredDataSize - avail);
        }
        return totalBytesRead;
    }

    protected final void ensureBLayerDataInBuffer(int desiredDataSize) throws DisconnectException {
        if (this.dssIsContinued_ && desiredDataSize > this.dssLength_) {
            int continueDssHeaderCount = (desiredDataSize - this.dssLength_) / Short.MAX_VALUE + 1;
            this.ensureALayerDataInBuffer(desiredDataSize + continueDssHeaderCount * 2);
            this.compressBLayerData(continueDssHeaderCount);
            return;
        }
        this.ensureALayerDataInBuffer(desiredDataSize);
    }

    private final void compressBLayerData(int continueDssHeaderCount) throws DisconnectException {
        int tempPos = 0;
        for (int i = 0; i < continueDssHeaderCount; ++i) {
            if (i == 0) {
                tempPos = this.pos_ + this.dssLength_;
                continue;
            }
            tempPos += Short.MAX_VALUE;
        }
        int shiftSize = 0;
        int bytesToShift = 0;
        int continueHeaderLength = 0;
        int newDssLength = 0;
        for (int i = 0; i < continueDssHeaderCount; ++i) {
            continueHeaderLength = ((this.buffer_[tempPos] & 0xFF) << 8) + ((this.buffer_[tempPos + 1] & 0xFF) << 0);
            if (i == 0) {
                if ((continueHeaderLength & 0x8000) == 32768) {
                    continueHeaderLength = Short.MAX_VALUE;
                    this.dssIsContinued_ = true;
                } else {
                    this.dssIsContinued_ = false;
                }
                shiftSize = 2;
            } else {
                if ((continueHeaderLength & 0x8000) == 32768) {
                    continueHeaderLength = Short.MAX_VALUE;
                } else {
                    this.doSyntaxrmSemantics(CodePoint.SYNERRCD_DSS_LENGTH_BYTE_NUMBER_MISMATCH);
                }
                shiftSize += 2;
            }
            if (continueHeaderLength <= 2) {
                this.doSyntaxrmSemantics(CodePoint.SYNERRCD_DSS_CONT_LESS_OR_EQUAL_2);
            }
            newDssLength += continueHeaderLength - 2;
            bytesToShift = i != continueDssHeaderCount - 1 ? Short.MAX_VALUE : this.dssLength_;
            System.arraycopy(this.buffer_, (tempPos -= bytesToShift - 2) - shiftSize, this.buffer_, tempPos, bytesToShift);
        }
        this.pos_ = tempPos;
        this.dssLength_ += newDssLength;
    }

    protected final void readDssHeader() throws DisconnectException {
        int gdsFormatter;
        int correlationID = 0;
        int nextCorrelationID = 0;
        this.ensureALayerDataInBuffer(6);
        int oldDssLength = this.dssLength_ = ((this.buffer_[this.pos_++] & 0xFF) << 8) + ((this.buffer_[this.pos_++] & 0xFF) << 0);
        if ((this.dssLength_ & 0x8000) == 32768) {
            this.dssLength_ = Short.MAX_VALUE;
            this.dssIsContinued_ = true;
        } else {
            this.dssIsContinued_ = false;
        }
        if (this.dssLength_ < 6) {
            this.doSyntaxrmSemantics(CodePoint.SYNERRCD_DSS_LESS_THAN_6);
        }
        if ((this.buffer_[this.pos_++] & 0xFF) != 208) {
            this.doSyntaxrmSemantics(CodePoint.SYNERRCD_CBYTE_NOT_D0);
        }
        if (((gdsFormatter = this.buffer_[this.pos_++] & 0xFF) & 2) != 2 && (gdsFormatter & 3) != 3 && (gdsFormatter & 4) != 4) {
            this.doSyntaxrmSemantics(CodePoint.SYNERRCD_FBYTE_NOT_SUPPORTED);
        }
        if ((gdsFormatter & 0x40) == 64) {
            if ((gdsFormatter & 0x10) == 16) {
                this.dssIsChainedWithSameID_ = true;
                this.dssIsChainedWithDiffID_ = false;
                nextCorrelationID = this.dssCorrelationID_;
            } else {
                this.dssIsChainedWithSameID_ = false;
                this.dssIsChainedWithDiffID_ = true;
                nextCorrelationID = this.dssCorrelationID_ + 1;
            }
        } else {
            if ((gdsFormatter & 0x10) == 16) {
                this.doSyntaxrmSemantics(CodePoint.SYNERRCD_CHAIN_OFF_SAME_NEXT_CORRELATOR);
            }
            if ((gdsFormatter & 0x20) == 32) {
                this.doSyntaxrmSemantics(CodePoint.SYNERRCD_CHAIN_OFF_ERROR_CONTINUE);
            }
            this.dssIsChainedWithSameID_ = false;
            this.dssIsChainedWithDiffID_ = false;
            nextCorrelationID = 1;
        }
        correlationID = ((this.buffer_[this.pos_++] & 0xFF) << 8) + ((this.buffer_[this.pos_++] & 0xFF) << 0);
        if (correlationID != this.dssCorrelationID_ && correlationID != 65535) {
            this.doSyntaxrmSemantics(CodePoint.SYNERRCD_INVALID_CORRELATOR);
        } else {
            this.dssCorrelationID_ = nextCorrelationID;
        }
        this.dssLength_ -= 6;
        if ((gdsFormatter & 4) == 4) {
            this.decryptData(gdsFormatter, oldDssLength);
        }
    }

    private final void decryptData(int gdsFormatter, int oldDssLength) throws DisconnectException {
        if (this.dssLength_ == 32761) {
            boolean readHeader;
            int copySize = 0;
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            copySize = this.dssLength_;
            do {
                readHeader = this.dssIsContinued_;
                this.ensureALayerDataInBuffer(copySize);
                this.adjustLengths(copySize);
                baos.write(this.buffer_, this.pos_, copySize);
                this.pos_ += copySize;
                if (readHeader) {
                    this.readDSSContinuationHeader();
                }
                copySize = this.dssLength_;
            } while (readHeader);
            byte[] cipherBytes = baos.toByteArray();
            byte[] clearedByte = null;
            try {
                clearedByte = this.netAgent_.netConnection_.getEncryptionManager().decryptData(cipherBytes, 9, this.netAgent_.netConnection_.getTargetPublicKey(), this.netAgent_.netConnection_.getTargetPublicKey());
            }
            catch (SqlException e) {
                // empty catch block
            }
            this.longBufferForDecryption_ = new byte[this.buffer_.length - this.pos_];
            this.longPosForDecryption_ = 0;
            this.count_ -= this.pos_;
            this.longCountForDecryption_ = this.count_;
            System.arraycopy(this.buffer_, this.pos_, this.longBufferForDecryption_, 0, this.buffer_.length - this.pos_);
            if (clearedByte.length >= Short.MAX_VALUE) {
                System.arraycopy(clearedByte, 0, this.buffer_, 0, Short.MAX_VALUE);
            } else {
                System.arraycopy(clearedByte, 0, this.buffer_, 0, clearedByte.length);
            }
            this.pos_ = 0;
            this.dssLength_ = this.buffer_.length;
            int lobLength = 0;
            if (clearedByte.length > Short.MAX_VALUE) {
                lobLength = ((clearedByte[4] & 0xFF) << 24) + ((clearedByte[5] & 0xFF) << 16) + ((clearedByte[6] & 0xFF) << 8) + ((clearedByte[7] & 0xFF) << 0);
                this.longValueForDecryption_ = new byte[lobLength];
                System.arraycopy(clearedByte, 8, this.longValueForDecryption_, 0, clearedByte.length - 8);
            } else {
                lobLength = ((clearedByte[0] & 0xFF) << 8) + ((clearedByte[1] & 0xFF) << 0);
                this.longValueForDecryption_ = new byte[lobLength - 4];
                System.arraycopy(clearedByte, 4, this.longValueForDecryption_, 0, clearedByte.length - 4);
            }
        } else {
            int bytesRead = this.ensureALayerDataInBuffer(this.dssLength_);
            if (bytesRead > 0) {
                this.ensuredLengthForDecryption_ = true;
            }
            byte[] encryptedByte = new byte[this.dssLength_];
            System.arraycopy(this.buffer_, this.pos_, encryptedByte, 0, this.dssLength_);
            byte[] array1 = new byte[this.pos_];
            System.arraycopy(this.buffer_, 0, array1, 0, this.pos_);
            byte[] array3 = new byte[this.buffer_.length - this.dssLength_ - this.pos_];
            System.arraycopy(this.buffer_, this.pos_ + this.dssLength_, array3, 0, this.buffer_.length - this.dssLength_ - this.pos_);
            byte[] clearedByte = null;
            try {
                clearedByte = this.netAgent_.netConnection_.getEncryptionManager().decryptData(encryptedByte, 9, this.netAgent_.netConnection_.getTargetPublicKey(), this.netAgent_.netConnection_.getTargetPublicKey());
            }
            catch (SqlException e) {
                // empty catch block
            }
            this.dssLength_ -= encryptedByte.length - clearedByte.length;
            byte[] buffer = new byte[array1.length + clearedByte.length + array3.length];
            System.arraycopy(array1, 0, buffer, 0, array1.length);
            System.arraycopy(clearedByte, 0, buffer, array1.length, clearedByte.length);
            System.arraycopy(array3, 0, buffer, array1.length + clearedByte.length, array3.length);
            this.buffer_ = buffer;
            int oldCount = this.count_;
            this.count_ -= encryptedByte.length - clearedByte.length;
            if (((clearedByte[2] & 0xFF) << 8) + ((clearedByte[3] & 0xFF) << 0) == 5228) {
                int firstLobLength = ((clearedByte[0] & 0xFF) << 8) + ((clearedByte[1] & 0xFF) << 0);
                boolean flag = false;
                if (gdsFormatter == 84) {
                    flag = true;
                }
                if (flag) {
                    if (oldCount - oldDssLength < 6) {
                        int totalBytesRead = this.fill(6);
                        if (totalBytesRead > 0) {
                            this.longBufferForDecryption_ = new byte[totalBytesRead];
                            this.longPosForDecryption_ = 0;
                            System.arraycopy(this.buffer_, this.pos_ + firstLobLength, this.longBufferForDecryption_, 0, totalBytesRead);
                        }
                    } else {
                        this.longBufferForDecryption_ = new byte[this.count_ - this.pos_ - firstLobLength];
                        this.longPosForDecryption_ = 0;
                        System.arraycopy(this.buffer_, this.pos_ + firstLobLength, this.longBufferForDecryption_, 0, this.longBufferForDecryption_.length);
                    }
                }
                int lobLength = ((clearedByte[0] & 0xFF) << 8) + ((clearedByte[1] & 0xFF) << 0) - 4;
                this.longValueForDecryption_ = new byte[lobLength];
                System.arraycopy(clearedByte, 4, this.longValueForDecryption_, 0, clearedByte.length - 4);
            } else if (((clearedByte[2] & 0xFF) << 8) + ((clearedByte[3] & 0xFF) << 0) == 9243) {
                int length = ((clearedByte[0] & 0xFF) << 8) + ((clearedByte[1] & 0xFF) << 0);
                boolean noData = false;
                if (clearedByte[4] == -1 && clearedByte[5] == -1) {
                    noData = true;
                }
                if (!noData) {
                    if (length == 32776) {
                        length = ((clearedByte[4] & 0xFF) << 24) + ((clearedByte[5] & 0xFF) << 16) + ((clearedByte[6] & 0xFF) << 8) + ((clearedByte[7] & 0xFF) << 0);
                        this.longValueForDecryption_ = new byte[length];
                        System.arraycopy(clearedByte, 8, this.longValueForDecryption_, 0, clearedByte.length - 8);
                        this.longCountForDecryption_ = this.count_ - (this.pos_ + length + 8);
                        this.longBufferForDecryption_ = new byte[this.buffer_.length - this.pos_ - length - 8];
                        System.arraycopy(this.buffer_, this.pos_ + length + 8, this.longBufferForDecryption_, 0, this.longBufferForDecryption_.length);
                    } else {
                        this.longPosForDecryption_ = 0;
                        this.longCountForDecryption_ = this.count_ - (this.pos_ + length);
                        this.longBufferForDecryption_ = new byte[this.buffer_.length - this.pos_ - length];
                        System.arraycopy(this.buffer_, this.pos_ + length, this.longBufferForDecryption_, 0, this.longBufferForDecryption_.length);
                        this.longValueForDecryption_ = new byte[length - 4];
                        System.arraycopy(clearedByte, 4, this.longValueForDecryption_, 0, clearedByte.length - 4);
                    }
                }
            }
        }
    }

    final int readUnsignedShort() throws DisconnectException {
        this.ensureBLayerDataInBuffer(2);
        this.adjustLengths(2);
        return ((this.buffer_[this.pos_++] & 0xFF) << 8) + ((this.buffer_[this.pos_++] & 0xFF) << 0);
    }

    final short readShort() throws DisconnectException {
        this.ensureBLayerDataInBuffer(2);
        this.adjustLengths(2);
        short s = SignedBinary.getShort(this.buffer_, this.pos_);
        this.pos_ += 2;
        return s;
    }

    final int readInt() throws DisconnectException {
        this.ensureBLayerDataInBuffer(4);
        this.adjustLengths(4);
        int i = SignedBinary.getInt(this.buffer_, this.pos_);
        this.pos_ += 4;
        return i;
    }

    final void readIntArray(int[] array) throws DisconnectException {
        this.ensureBLayerDataInBuffer(array.length * 4);
        this.adjustLengths(array.length * 4);
        for (int i = 0; i < array.length; ++i) {
            array[i] = SignedBinary.getInt(this.buffer_, this.pos_);
            this.pos_ += 4;
        }
    }

    final long readLong() throws DisconnectException {
        this.ensureBLayerDataInBuffer(8);
        this.adjustLengths(8);
        long l = SignedBinary.getLong(this.buffer_, this.pos_);
        this.pos_ += 8;
        return l;
    }

    final int[] readUnsignedShortList() throws DisconnectException {
        int len = this.ddmScalarLen_;
        this.ensureBLayerDataInBuffer(len);
        this.adjustLengths(len);
        int count = len / 2;
        int[] list = new int[count];
        for (int i = 0; i < count; ++i) {
            list[i] = ((this.buffer_[this.pos_++] & 0xFF) << 8) + ((this.buffer_[this.pos_++] & 0xFF) << 0);
        }
        return list;
    }

    final int readUnsignedByte() throws DisconnectException {
        this.ensureBLayerDataInBuffer(1);
        this.adjustLengths(1);
        return this.buffer_[this.pos_++] & 0xFF;
    }

    final byte readByte() throws DisconnectException {
        this.ensureBLayerDataInBuffer(1);
        this.adjustLengths(1);
        return (byte)(this.buffer_[this.pos_++] & 0xFF);
    }

    final boolean readBoolean() throws DisconnectException {
        this.ensureBLayerDataInBuffer(1);
        this.adjustLengths(1);
        return this.buffer_[this.pos_++] != 0;
    }

    final String readString(int length) throws DisconnectException {
        this.ensureBLayerDataInBuffer(length);
        this.adjustLengths(length);
        String result = this.ccsidManager_.convertToUCS2(this.buffer_, this.pos_, length);
        this.pos_ += length;
        return result;
    }

    final String readString(int length, String encoding) throws DisconnectException {
        this.ensureBLayerDataInBuffer(length);
        this.adjustLengths(length);
        String s = null;
        try {
            s = new String(this.buffer_, this.pos_, length, encoding);
        }
        catch (UnsupportedEncodingException e) {
            this.agent_.accumulateChainBreakingReadExceptionAndThrow(new DisconnectException(this.agent_, new ClientMessageId("58009.C.11"), (Object)e));
        }
        this.pos_ += length;
        return s;
    }

    final String readString() throws DisconnectException {
        int len = this.ddmScalarLen_;
        this.ensureBLayerDataInBuffer(len);
        this.adjustLengths(len);
        String result = this.ccsidManager_.convertToUCS2(this.buffer_, this.pos_, len);
        this.pos_ += len;
        return result;
    }

    final byte[] readBytes(int length) throws DisconnectException {
        this.ensureBLayerDataInBuffer(length);
        this.adjustLengths(length);
        byte[] b = new byte[length];
        System.arraycopy(this.buffer_, this.pos_, b, 0, length);
        this.pos_ += length;
        return b;
    }

    final byte[] readBytes() throws DisconnectException {
        int len = this.ddmScalarLen_;
        this.ensureBLayerDataInBuffer(len);
        this.adjustLengths(len);
        byte[] b = new byte[len];
        System.arraycopy(this.buffer_, this.pos_, b, 0, len);
        this.pos_ += len;
        return b;
    }

    final byte[] readLDBytes() throws DisconnectException {
        this.ensureBLayerDataInBuffer(2);
        int len = ((this.buffer_[this.pos_++] & 0xFF) << 8) + ((this.buffer_[this.pos_++] & 0xFF) << 0);
        if (len == 0) {
            this.adjustLengths(2);
            return null;
        }
        this.ensureBLayerDataInBuffer(len);
        this.adjustLengths(len + 2);
        byte[] b = new byte[len];
        System.arraycopy(this.buffer_, this.pos_, b, 0, len);
        this.pos_ += len;
        return b;
    }

    final void skipBytes(int length) throws DisconnectException {
        this.ensureBLayerDataInBuffer(length);
        this.adjustLengths(length);
        this.pos_ += length;
    }

    final void skipBytes() throws DisconnectException {
        int len = this.ddmScalarLen_;
        this.ensureBLayerDataInBuffer(len);
        this.adjustLengths(len);
        this.pos_ += len;
    }

    final ByteArrayOutputStream getData(ByteArrayOutputStream existingBuffer) throws DisconnectException {
        boolean readHeader;
        ByteArrayOutputStream baos = existingBuffer != null ? existingBuffer : (this.ddmScalarLen_ != -1 ? new ByteArrayOutputStream(this.ddmScalarLen_) : new ByteArrayOutputStream());
        int copySize = this.dssLength_;
        do {
            readHeader = this.dssIsContinued_;
            this.ensureALayerDataInBuffer(copySize);
            this.adjustLengths(copySize);
            baos.write(this.buffer_, this.pos_, copySize);
            this.pos_ += copySize;
            if (readHeader) {
                this.readDSSContinuationHeader();
            }
            copySize = this.dssLength_;
        } while (readHeader);
        return baos;
    }

    protected final void readDSSContinuationHeader() throws DisconnectException {
        this.ensureALayerDataInBuffer(2);
        this.dssLength_ = ((this.buffer_[this.pos_++] & 0xFF) << 8) + ((this.buffer_[this.pos_++] & 0xFF) << 0);
        if ((this.dssLength_ & 0x8000) == 32768) {
            this.dssLength_ = Short.MAX_VALUE;
            this.dssIsContinued_ = true;
        } else {
            this.dssIsContinued_ = false;
        }
        if (this.dssLength_ <= 2) {
            this.doSyntaxrmSemantics(CodePoint.SYNERRCD_DSS_CONT_LESS_OR_EQUAL_2);
        }
        this.dssLength_ -= 2;
    }

    final void doSyntaxrmSemantics(int syntaxErrorCode) throws DisconnectException {
        DisconnectException e = new DisconnectException(this.agent_, new ClientMessageId("08006.C"), (Object)SqlException.getMessageUtil().getTextMessage("J131", new Integer(syntaxErrorCode)));
        if (this.netAgent_.exceptionConvertingRdbnam != null) {
            e.setNextException(this.netAgent_.exceptionConvertingRdbnam);
            this.netAgent_.exceptionConvertingRdbnam = null;
        }
        this.agent_.accumulateChainBreakingReadExceptionAndThrow(e);
    }

    protected final void pushLengthOnCollectionStack() {
        this.ddmCollectionLenStack_[++this.topDdmCollectionStack_] = this.ddmScalarLen_;
        this.ddmScalarLen_ = 0;
    }

    protected final void adjustLengths(int length) {
        this.ddmScalarLen_ -= length;
        this.adjustCollectionAndDssLengths(length);
    }

    protected int adjustDdmLength(int ddmLength, int length) {
        if ((ddmLength -= length) == 0) {
            this.adjustLengths(this.getDdmLength());
        }
        return ddmLength;
    }

    protected final void popCollectionStack() {
        --this.topDdmCollectionStack_;
    }

    protected final int peekCodePoint() throws DisconnectException {
        if (this.topDdmCollectionStack_ != -1) {
            if (this.ddmCollectionLenStack_[this.topDdmCollectionStack_] == 0) {
                return -1;
            }
            if (this.ddmCollectionLenStack_[this.topDdmCollectionStack_] < 4) {
                // empty if block
            }
        }
        if (this.dssLength_ == 0 && !this.dssIsContinued_) {
            if (!this.dssIsChainedWithSameID_) {
                return -2;
            }
            this.readDssHeader();
        }
        if (this.longBufferForDecryption_ == null) {
            this.ensureBLayerDataInBuffer(4);
        }
        this.peekedLength_ = ((this.buffer_[this.pos_] & 0xFF) << 8) + ((this.buffer_[this.pos_ + 1] & 0xFF) << 0);
        this.peekedCodePoint_ = ((this.buffer_[this.pos_ + 2] & 0xFF) << 8) + ((this.buffer_[this.pos_ + 3] & 0xFF) << 0);
        if ((this.peekedLength_ & 0x8000) == 32768) {
            this.peekExtendedLength();
        } else {
            this.peekedNumOfExtendedLenBytes_ = 0;
        }
        return this.peekedCodePoint_;
    }

    protected final int peekLength() throws DisconnectException {
        this.ensureBLayerDataInBuffer(2);
        return ((this.buffer_[this.pos_] & 0xFF) << 8) + ((this.buffer_[this.pos_ + 1] & 0xFF) << 0);
    }

    protected final int peekFastBytes(byte[] b, int offset, int length) throws DisconnectException {
        for (int i = 0; i < length; ++i) {
            b[offset + i] = this.buffer_[this.pos_ + i];
        }
        return offset + length;
    }

    protected final void parseLengthAndMatchCodePoint(int expectedCodePoint) throws DisconnectException {
        int actualCodePoint = 0;
        if (this.peekedCodePoint_ == -1) {
            actualCodePoint = this.readLengthAndCodePoint();
        } else {
            actualCodePoint = this.peekedCodePoint_;
            this.pos_ += 4 + this.peekedNumOfExtendedLenBytes_;
            this.ddmScalarLen_ = this.peekedLength_;
            if (this.peekedNumOfExtendedLenBytes_ == 0 && this.ddmScalarLen_ != -1) {
                this.adjustLengths(4);
            } else {
                this.adjustCollectionAndDssLengths(4 + this.peekedNumOfExtendedLenBytes_);
            }
            this.peekedLength_ = 0;
            this.peekedCodePoint_ = -1;
            this.peekedNumOfExtendedLenBytes_ = 0;
        }
        if (actualCodePoint != expectedCodePoint) {
            this.agent_.accumulateChainBreakingReadExceptionAndThrow(new DisconnectException(this.agent_, new ClientMessageId("58009.C.12"), (Object)new Integer(actualCodePoint), (Object)new Integer(expectedCodePoint)));
        }
    }

    protected final int readLengthAndCodePoint() throws DisconnectException {
        if (this.topDdmCollectionStack_ != -1) {
            if (this.ddmCollectionLenStack_[this.topDdmCollectionStack_] == 0) {
                return -1;
            }
            if (this.ddmCollectionLenStack_[this.topDdmCollectionStack_] < 4) {
                this.agent_.accumulateChainBreakingReadExceptionAndThrow(new DisconnectException(this.agent_, new ClientMessageId("58009.C.13")));
            }
        }
        if (this.dssLength_ == 0 && !this.dssIsContinued_) {
            if (!this.dssIsChainedWithSameID_) {
                return -2;
            }
            this.readDssHeader();
        }
        this.ensureBLayerDataInBuffer(4);
        this.ddmScalarLen_ = ((this.buffer_[this.pos_++] & 0xFF) << 8) + ((this.buffer_[this.pos_++] & 0xFF) << 0);
        int codePoint = ((this.buffer_[this.pos_++] & 0xFF) << 8) + ((this.buffer_[this.pos_++] & 0xFF) << 0);
        this.adjustLengths(4);
        if ((this.ddmScalarLen_ & 0x8000) == 32768) {
            this.readExtendedLength();
        }
        return codePoint;
    }

    private final void readExtendedLength() throws DisconnectException {
        int numberOfExtendedLenBytes = this.ddmScalarLen_ - 32768;
        int adjustSize = 0;
        switch (numberOfExtendedLenBytes) {
            case 4: {
                this.ensureBLayerDataInBuffer(4);
                this.ddmScalarLen_ = ((this.buffer_[this.pos_++] & 0xFF) << 24) + ((this.buffer_[this.pos_++] & 0xFF) << 16) + ((this.buffer_[this.pos_++] & 0xFF) << 8) + ((this.buffer_[this.pos_++] & 0xFF) << 0);
                adjustSize = 4;
                break;
            }
            case 0: {
                this.ddmScalarLen_ = -1;
                adjustSize = 0;
                break;
            }
            default: {
                this.doSyntaxrmSemantics(CodePoint.SYNERRCD_INCORRECT_EXTENDED_LEN);
            }
        }
        this.adjustCollectionAndDssLengths(adjustSize);
    }

    private final void adjustCollectionAndDssLengths(int length) {
        int i = 0;
        while (i <= this.topDdmCollectionStack_) {
            int n = i++;
            this.ddmCollectionLenStack_[n] = this.ddmCollectionLenStack_[n] - length;
        }
        this.dssLength_ -= length;
    }

    protected final void startSameIdChainParse() throws DisconnectException {
        this.readDssHeader();
        this.netAgent_.clearSvrcod();
    }

    protected final void endOfSameIdChainData() throws DisconnectException {
        this.netAgent_.targetTypdef_ = this.netAgent_.originalTargetTypdef_;
        this.netAgent_.targetSqlam_ = this.netAgent_.orignalTargetSqlam_;
        if (this.topDdmCollectionStack_ != -1) {
            this.agent_.accumulateChainBreakingReadExceptionAndThrow(new DisconnectException(this.agent_, new ClientMessageId("58009.C.14")));
        }
        if (this.dssLength_ != 0) {
            this.agent_.accumulateChainBreakingReadExceptionAndThrow(new DisconnectException(this.agent_, new ClientMessageId("58009.C.15")));
        }
        if (this.dssIsChainedWithSameID_) {
            this.agent_.accumulateChainBreakingReadExceptionAndThrow(new DisconnectException(this.agent_, new ClientMessageId("58009.C.16")));
        }
    }

    protected final int peekTotalColumnCount(int tripletLength) throws DisconnectException {
        int columnCount = 0;
        int offset = 0;
        int tripletType = 127;
        while (tripletType == 127) {
            columnCount += (tripletLength - 3) / 3;
            this.ensureBLayerDataInBuffer(tripletLength - 3);
            offset += tripletLength - 3;
            tripletLength = this.buffer_[this.pos_ + offset++] & 0xFF;
            tripletType = this.buffer_[this.pos_ + offset++] & 0xFF;
            ++offset;
        }
        return columnCount;
    }

    private final void peekExtendedLength() throws DisconnectException {
        this.peekedNumOfExtendedLenBytes_ = this.peekedLength_ - 32772;
        switch (this.peekedNumOfExtendedLenBytes_) {
            case 4: {
                if (this.longBufferForDecryption_ == null) {
                    this.ensureBLayerDataInBuffer(8);
                }
                this.peekedLength_ = ((this.buffer_[this.pos_ + 4] & 0xFF) << 24) + ((this.buffer_[this.pos_ + 5] & 0xFF) << 16) + ((this.buffer_[this.pos_ + 6] & 0xFF) << 8) + ((this.buffer_[this.pos_ + 7] & 0xFF) << 0);
                break;
            }
            case 0: {
                this.peekedLength_ = -1;
                break;
            }
            default: {
                this.doSyntaxrmSemantics(CodePoint.SYNERRCD_INCORRECT_EXTENDED_LEN);
            }
        }
    }

    final int readFastUnsignedByte() throws DisconnectException {
        return this.buffer_[this.pos_++] & 0xFF;
    }

    final short readFastShort() throws DisconnectException {
        short s = SignedBinary.getShort(this.buffer_, this.pos_);
        this.pos_ += 2;
        return s;
    }

    final int readFastUnsignedShort() throws DisconnectException {
        return ((this.buffer_[this.pos_++] & 0xFF) << 8) + ((this.buffer_[this.pos_++] & 0xFF) << 0);
    }

    final int readFastInt() throws DisconnectException {
        int i = SignedBinary.getInt(this.buffer_, this.pos_);
        this.pos_ += 4;
        return i;
    }

    final String readFastString(int length) throws DisconnectException {
        String result = this.ccsidManager_.convertToUCS2(this.buffer_, this.pos_, length);
        this.pos_ += length;
        return result;
    }

    final byte[] readFastBytes(int length) throws DisconnectException {
        byte[] b = new byte[length];
        System.arraycopy(this.buffer_, this.pos_, b, 0, length);
        this.pos_ += length;
        return b;
    }

    protected final int peekFastLength() throws DisconnectException {
        return ((this.buffer_[this.pos_] & 0xFF) << 8) + ((this.buffer_[this.pos_ + 1] & 0xFF) << 0);
    }

    final void skipFastBytes(int length) throws DisconnectException {
        this.pos_ += length;
    }

    final void readFastIntArray(int[] array) throws DisconnectException {
        for (int i = 0; i < array.length; ++i) {
            array[i] = SignedBinary.getInt(this.buffer_, this.pos_);
            this.pos_ += 4;
        }
    }

    final String readFastString(int length, String encoding) throws DisconnectException {
        String s = null;
        try {
            s = new String(this.buffer_, this.pos_, length, encoding);
        }
        catch (UnsupportedEncodingException e) {
            this.agent_.accumulateChainBreakingReadExceptionAndThrow(new DisconnectException(this.agent_, new ClientMessageId("58009.C.11"), (Object)e));
        }
        this.pos_ += length;
        return s;
    }

    final byte[] readFastLDBytes() throws DisconnectException {
        int len;
        if ((len = ((this.buffer_[this.pos_++] & 0xFF) << 8) + ((this.buffer_[this.pos_++] & 0xFF) << 0)) == 0) {
            return null;
        }
        byte[] b = new byte[len];
        System.arraycopy(this.buffer_, this.pos_, b, 0, len);
        this.pos_ += len;
        return b;
    }

    final long readFastLong() throws DisconnectException {
        long l = SignedBinary.getLong(this.buffer_, this.pos_);
        this.pos_ += 8;
        return l;
    }

    final byte readFastByte() throws DisconnectException {
        return (byte)(this.buffer_[this.pos_++] & 0xFF);
    }

    final void mark() {
        this.currentPos_ = this.pos_;
    }

    final int popMark() {
        return this.currentPos_;
    }

    final int getFastSkipSQLCARDrowLength() {
        return this.pos_ - this.popMark();
    }

    final ByteArrayOutputStream getFastData(ByteArrayOutputStream existingBuffer) throws DisconnectException {
        boolean readHeader;
        ByteArrayOutputStream baos = existingBuffer != null ? existingBuffer : (this.ddmScalarLen_ != -1 ? new ByteArrayOutputStream(this.ddmScalarLen_) : new ByteArrayOutputStream());
        int copySize = this.dssLength_;
        do {
            readHeader = this.dssIsContinued_;
            this.adjustLengths(copySize);
            baos.write(this.buffer_, this.pos_, copySize);
            this.pos_ += copySize;
            if (readHeader) {
                this.readDSSContinuationHeader();
            }
            copySize = this.dssLength_;
        } while (readHeader);
        return baos;
    }

    protected final void matchCodePoint(int expectedCodePoint) throws DisconnectException {
        int actualCodePoint = 0;
        actualCodePoint = this.peekedCodePoint_;
        this.pos_ += 4;
        if (actualCodePoint != expectedCodePoint) {
            this.agent_.accumulateChainBreakingReadExceptionAndThrow(new DisconnectException(this.agent_, new ClientMessageId("58009.C.12"), (Object)new Integer(actualCodePoint), (Object)new Integer(expectedCodePoint)));
        }
    }

    protected final int peekNumOfColumns() throws DisconnectException {
        int offset = 4 + this.peekedNumOfExtendedLenBytes_ + 1;
        offset = this.skipSQLDHROW(offset);
        return SignedBinary.getShort(this.buffer_, this.pos_ + offset);
    }

    protected final boolean peekForNullSqlcagrp() {
        int offset = 4 + this.peekedNumOfExtendedLenBytes_;
        int nullInd = this.buffer_[this.pos_ + offset] & 0xFF;
        return nullInd == 255;
    }

    private final int skipSQLDHROW(int offset) throws DisconnectException {
        int sqldhrowgrpNullInd;
        if ((sqldhrowgrpNullInd = this.buffer_[this.pos_ + offset++] & 0xFF) == 255) {
            return offset;
        }
        offset += 12;
        int stringLength = ((this.buffer_[this.pos_ + offset++] & 0xFF) << 8) + ((this.buffer_[this.pos_ + offset++] & 0xFF) << 0);
        offset += stringLength;
        stringLength = ((this.buffer_[this.pos_ + offset++] & 0xFF) << 8) + ((this.buffer_[this.pos_ + offset++] & 0xFF) << 0);
        offset += stringLength;
        stringLength = ((this.buffer_[this.pos_ + offset++] & 0xFF) << 8) + ((this.buffer_[this.pos_ + offset++] & 0xFF) << 0);
        return offset += stringLength;
    }
}

