/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.iapi.sql.dictionary;

import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.WeakHashMap;
import org.apache.derby.catalog.DependableFinder;
import org.apache.derby.catalog.UUID;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.io.FormatableBitSet;
import org.apache.derby.iapi.services.sanity.SanityManager;
import org.apache.derby.iapi.sql.depend.Provider;
import org.apache.derby.iapi.sql.dictionary.ColumnDescriptor;
import org.apache.derby.iapi.sql.dictionary.ColumnDescriptorList;
import org.apache.derby.iapi.sql.dictionary.ConglomerateDescriptor;
import org.apache.derby.iapi.sql.dictionary.ConglomerateDescriptorList;
import org.apache.derby.iapi.sql.dictionary.ConstraintDescriptor;
import org.apache.derby.iapi.sql.dictionary.ConstraintDescriptorList;
import org.apache.derby.iapi.sql.dictionary.DataDictionary;
import org.apache.derby.iapi.sql.dictionary.GenericDescriptorList;
import org.apache.derby.iapi.sql.dictionary.IndexLister;
import org.apache.derby.iapi.sql.dictionary.ReferencedKeyConstraintDescriptor;
import org.apache.derby.iapi.sql.dictionary.SchemaDescriptor;
import org.apache.derby.iapi.sql.dictionary.StatisticsDescriptor;
import org.apache.derby.iapi.sql.dictionary.TriggerDescriptor;
import org.apache.derby.iapi.sql.dictionary.TupleDescriptor;
import org.apache.derby.iapi.sql.dictionary.UniqueSQLObjectDescriptor;
import org.apache.derby.iapi.sql.dictionary.ViewDescriptor;
import org.apache.derby.iapi.sql.execute.ExecRow;
import org.apache.derby.iapi.types.DataValueDescriptor;

public class TableDescriptor
extends TupleDescriptor
implements UniqueSQLObjectDescriptor,
Provider {
    public static final int BASE_TABLE_TYPE = 0;
    public static final int SYSTEM_TABLE_TYPE = 1;
    public static final int VIEW_TYPE = 2;
    public static final int GLOBAL_TEMPORARY_TABLE_TYPE = 3;
    public static final int SYNONYM_TYPE = 4;
    public static final int VTI_TYPE = 5;
    public static final char ROW_LOCK_GRANULARITY = 'R';
    public static final char TABLE_LOCK_GRANULARITY = 'T';
    public static final char DEFAULT_LOCK_GRANULARITY = 'R';
    private char lockGranularity;
    private boolean onCommitDeleteRows;
    private boolean onRollbackDeleteRows;
    SchemaDescriptor schema;
    String tableName;
    UUID oid;
    int tableType;
    long heapConglomNumber = -1L;
    ColumnDescriptorList columnDescriptorList;
    ConglomerateDescriptorList conglomerateDescriptorList;
    ConstraintDescriptorList constraintDescriptorList;
    private GenericDescriptorList triggerDescriptorList;
    ViewDescriptor viewDescriptor;
    private static ThreadLocal referencedColumnMap = new ThreadLocal(){

        protected Object initialValue() {
            return new WeakHashMap();
        }
    };
    private List statisticsDescriptorList;

    private FormatableBitSet referencedColumnMapGet() {
        WeakHashMap map = (WeakHashMap)referencedColumnMap.get();
        return (FormatableBitSet)map.get(this);
    }

    private void referencedColumnMapPut(FormatableBitSet newReferencedColumnMap) {
        WeakHashMap map = (WeakHashMap)referencedColumnMap.get();
        map.put(this, newReferencedColumnMap);
    }

    public TableDescriptor(DataDictionary dataDictionary, String tableName, SchemaDescriptor schema, int tableType, boolean onCommitDeleteRows, boolean onRollbackDeleteRows) {
        this(dataDictionary, tableName, schema, tableType, '\u0000');
        this.onCommitDeleteRows = onCommitDeleteRows;
        this.onRollbackDeleteRows = onRollbackDeleteRows;
    }

    public TableDescriptor(DataDictionary dataDictionary, String tableName, SchemaDescriptor schema, int tableType, char lockGranularity) {
        super(dataDictionary);
        this.schema = schema;
        this.tableName = tableName;
        this.tableType = tableType;
        this.lockGranularity = lockGranularity;
        this.conglomerateDescriptorList = new ConglomerateDescriptorList();
        this.columnDescriptorList = new ColumnDescriptorList();
        this.constraintDescriptorList = new ConstraintDescriptorList();
        this.triggerDescriptorList = new GenericDescriptorList();
    }

    public String getSchemaName() {
        return this.schema.getSchemaName();
    }

    public SchemaDescriptor getSchemaDescriptor() {
        return this.schema;
    }

    public String getName() {
        return this.tableName;
    }

    public void setTableName(String newTableName) {
        this.tableName = newTableName;
    }

    public String getQualifiedName() {
        return this.quoteProtectName(this.getSchemaName()) + "." + this.quoteProtectName(this.getName());
    }

    private String quoteProtectName(String name) {
        String quotedString = name;
        int quotePos = name.indexOf("\"");
        if (quotePos == -1) {
            return "\"" + name + "\"";
        }
        while (quotePos != -1) {
            quotedString = quotedString.substring(0, quotePos) + "\"" + quotedString.substring(quotePos);
            quotePos = quotedString.indexOf("\"", quotePos + 2);
        }
        return "\"" + quotedString + "\"";
    }

    public UUID getUUID() {
        return this.oid;
    }

    public int getTableType() {
        return this.tableType;
    }

    public long getHeapConglomerateId() throws StandardException {
        DataDictionary dd = this.getDataDictionary();
        ConglomerateDescriptor cd = null;
        if (this.heapConglomNumber != -1L) {
            return this.heapConglomNumber;
        }
        ConglomerateDescriptor[] cds = this.getConglomerateDescriptors();
        for (int index = 0; index < cds.length && (cd = cds[index]).isIndex(); ++index) {
        }
        if (cd == null) {
            SanityManager.THROWASSERT("cd is expected to be non-null for " + this.tableName);
        }
        if (cd.isIndex()) {
            SanityManager.THROWASSERT("Did not find heap conglomerate for " + this.tableName);
        }
        this.heapConglomNumber = cd.getConglomerateNumber();
        return this.heapConglomNumber;
    }

    public int getNumberOfColumns() {
        return this.getColumnDescriptorList().size();
    }

    public FormatableBitSet getReferencedColumnMap() {
        return this.referencedColumnMapGet();
    }

    public void setReferencedColumnMap(FormatableBitSet referencedColumnMap) {
        this.referencedColumnMapPut(referencedColumnMap);
    }

    public FormatableBitSet makeColumnMap(ColumnDescriptorList cdl) {
        FormatableBitSet result = new FormatableBitSet(this.columnDescriptorList.size() + 1);
        int count = cdl.size();
        for (int i = 0; i < count; ++i) {
            ColumnDescriptor cd = cdl.elementAt(i);
            result.set(cd.getPosition());
        }
        return result;
    }

    public int getMaxColumnID() throws StandardException {
        int maxColumnID = 1;
        int cdlSize = this.getColumnDescriptorList().size();
        for (int index = 0; index < cdlSize; ++index) {
            ColumnDescriptor cd = this.columnDescriptorList.elementAt(index);
            maxColumnID = Math.max(maxColumnID, cd.getPosition());
        }
        return maxColumnID;
    }

    public void setUUID(UUID oid) {
        this.oid = oid;
    }

    public char getLockGranularity() {
        return this.lockGranularity;
    }

    public void setLockGranularity(char lockGranularity) {
        this.lockGranularity = lockGranularity;
    }

    public boolean isOnRollbackDeleteRows() {
        return this.onRollbackDeleteRows;
    }

    public boolean isOnCommitDeleteRows() {
        return this.onCommitDeleteRows;
    }

    public void resetHeapConglomNumber() {
        if (this.tableType != 3) {
            SanityManager.THROWASSERT("tableType expected to be TableDescriptor.GLOBAL_TEMPORARY_TABLE_TYPE, not " + this.tableType);
        }
        this.heapConglomNumber = -1L;
    }

    public ExecRow getEmptyExecRow() throws StandardException {
        int columnCount = this.getNumberOfColumns();
        ExecRow result = this.getDataDictionary().getExecutionFactory().getValueRow(columnCount);
        for (int index = 0; index < columnCount; ++index) {
            ColumnDescriptor cd = this.columnDescriptorList.elementAt(index);
            DataValueDescriptor dataValue = cd.getType().getNull();
            result.setColumn(index + 1, dataValue);
        }
        return result;
    }

    public int[] getColumnCollationIds() throws StandardException {
        int[] collation_ids = new int[this.getNumberOfColumns()];
        for (int index = 0; index < collation_ids.length; ++index) {
            ColumnDescriptor cd = this.columnDescriptorList.elementAt(index);
            collation_ids[index] = cd.getType().getCollationType();
        }
        return collation_ids;
    }

    public ConglomerateDescriptorList getConglomerateDescriptorList() {
        return this.conglomerateDescriptorList;
    }

    public ViewDescriptor getViewDescriptor() {
        return this.viewDescriptor;
    }

    public void setViewDescriptor(ViewDescriptor viewDescriptor) {
        if (this.tableType != 2) {
            SanityManager.THROWASSERT("tableType expected to be TableDescriptor.VIEW_TYPE, not " + this.tableType);
        }
        this.viewDescriptor = viewDescriptor;
    }

    public boolean isPersistent() {
        if (this.tableType == 3) {
            return false;
        }
        return super.isPersistent();
    }

    public boolean isSynonymDescriptor() {
        return this.tableType == 4;
    }

    public int getTotalNumberOfIndexes() throws StandardException {
        int totalNumberOfIndexes = 0;
        ConglomerateDescriptor[] cds = this.getConglomerateDescriptors();
        for (int index = 0; index < cds.length; ++index) {
            if (!cds[index].isIndex()) continue;
            ++totalNumberOfIndexes;
        }
        return totalNumberOfIndexes;
    }

    public void getAllRelevantTriggers(int statementType, int[] changedColumnIds, GenericDescriptorList relevantTriggers) throws StandardException {
        SanityManager.ASSERT(statementType == 1 || statementType == 2 || statementType == 3 || statementType == 4, "invalid statement type " + statementType);
        DataDictionary dd = this.getDataDictionary();
        Enumeration descs = dd.getTriggerDescriptors(this).elements();
        while (descs.hasMoreElements()) {
            TriggerDescriptor tgr = (TriggerDescriptor)descs.nextElement();
            if (!tgr.needsToFire(statementType, changedColumnIds)) continue;
            relevantTriggers.add(tgr);
        }
    }

    public void getAllRelevantConstraints(int statementType, boolean skipCheckConstraints, int[] changedColumnIds, boolean[] needsDeferredProcessing, ConstraintDescriptorList relevantConstraints) throws StandardException {
        SanityManager.ASSERT(statementType == 1 || statementType == 2 || statementType == 3 || statementType == 4, "invalid statement type " + statementType);
        DataDictionary dd = this.getDataDictionary();
        ConstraintDescriptorList cdl = dd.getConstraintDescriptors(this);
        int cdlSize = cdl.size();
        for (int index = 0; index < cdlSize; ++index) {
            ConstraintDescriptor cd = cdl.elementAt(index);
            if (skipCheckConstraints && cd.getConstraintType() == 4) continue;
            if (!needsDeferredProcessing[0] && cd instanceof ReferencedKeyConstraintDescriptor && statementType != 3 && statementType != 2) {
                needsDeferredProcessing[0] = ((ReferencedKeyConstraintDescriptor)cd).hasSelfReferencingFK(cdl, 1);
            }
            if (!cd.needsToFire(statementType, changedColumnIds)) continue;
            if (cd instanceof ReferencedKeyConstraintDescriptor && (statementType == 3 || statementType == 2)) {
                needsDeferredProcessing[0] = true;
            }
            relevantConstraints.add(cd);
        }
    }

    public DependableFinder getDependableFinder() {
        if (this.referencedColumnMapGet() == null) {
            return this.getDependableFinder(137);
        }
        return this.getColumnDependableFinder(393, this.referencedColumnMapGet().getByteArray());
    }

    public String getObjectName() {
        if (this.referencedColumnMapGet() == null) {
            return this.tableName;
        }
        String name = new String(this.tableName);
        boolean first = true;
        for (int i = 0; i < this.columnDescriptorList.size(); ++i) {
            ColumnDescriptor cd = this.columnDescriptorList.elementAt(i);
            if (!this.referencedColumnMapGet().isSet(cd.getPosition())) continue;
            if (first) {
                name = name + "(" + cd.getColumnName();
                first = false;
                continue;
            }
            name = name + ", " + cd.getColumnName();
        }
        if (!first) {
            name = name + ")";
        }
        return name;
    }

    public UUID getObjectID() {
        return this.oid;
    }

    public String getClassType() {
        return "Table";
    }

    public String toString() {
        String tempString = "SCHEMA:\n" + this.schema + "\ntableName: " + this.tableName + "\n" + "oid: " + this.oid + " tableType: " + this.tableType + "\n" + "conglomerateDescriptorList: " + this.conglomerateDescriptorList + "\n" + "columnDescriptorList: " + this.columnDescriptorList + "\n" + "constraintDescriptorList: " + this.constraintDescriptorList + "\n" + "heapConglomNumber: " + this.heapConglomNumber + "\n";
        if (this.tableType == 3) {
            tempString = tempString + "onCommitDeleteRows: " + "\n" + this.onCommitDeleteRows + "\n";
            tempString = tempString + "onRollbackDeleteRows: " + "\n" + this.onRollbackDeleteRows + "\n";
        } else {
            tempString = tempString + "lockGranularity: " + this.lockGranularity + "\n";
        }
        return tempString;
    }

    public ColumnDescriptorList getColumnDescriptorList() {
        return this.columnDescriptorList;
    }

    public ColumnDescriptorList getGeneratedColumns() {
        ColumnDescriptorList fullList = this.getColumnDescriptorList();
        ColumnDescriptorList result = new ColumnDescriptorList();
        int count = fullList.size();
        for (int i = 0; i < count; ++i) {
            ColumnDescriptor cd = fullList.elementAt(i);
            if (!cd.hasGenerationClause()) continue;
            result.add(this.oid, cd);
        }
        return result;
    }

    public int[] getColumnIDs(String[] names) {
        int count = names.length;
        int[] result = new int[count];
        for (int i = 0; i < count; ++i) {
            result[i] = this.getColumnDescriptor(names[i]).getPosition();
        }
        return result;
    }

    public ConstraintDescriptorList getConstraintDescriptorList() throws StandardException {
        return this.constraintDescriptorList;
    }

    public void setConstraintDescriptorList(ConstraintDescriptorList newCDL) {
        this.constraintDescriptorList = newCDL;
    }

    public void emptyConstraintDescriptorList() throws StandardException {
        this.constraintDescriptorList = new ConstraintDescriptorList();
    }

    public ReferencedKeyConstraintDescriptor getPrimaryKey() throws StandardException {
        ConstraintDescriptorList cdl = this.getDataDictionary().getConstraintDescriptors(this);
        return cdl.getPrimaryKey();
    }

    public GenericDescriptorList getTriggerDescriptorList() throws StandardException {
        return this.triggerDescriptorList;
    }

    public void setTriggerDescriptorList(GenericDescriptorList newCDL) {
        this.triggerDescriptorList = newCDL;
    }

    public void emptyTriggerDescriptorList() throws StandardException {
        this.triggerDescriptorList = new GenericDescriptorList();
    }

    public boolean tableNameEquals(String otherTableName, String otherSchemaName) {
        String schemaName = this.getSchemaName();
        if (schemaName == null || otherSchemaName == null) {
            return this.tableName.equals(otherTableName);
        }
        return schemaName.equals(otherSchemaName) && this.tableName.equals(otherTableName);
    }

    public void removeConglomerateDescriptor(ConglomerateDescriptor cd) throws StandardException {
        this.conglomerateDescriptorList.dropConglomerateDescriptor(this.getUUID(), cd);
    }

    public void removeConstraintDescriptor(ConstraintDescriptor cd) throws StandardException {
        this.constraintDescriptorList.remove(cd);
    }

    public ColumnDescriptor getColumnDescriptor(String columnName) {
        return this.columnDescriptorList.getColumnDescriptor(this.oid, columnName);
    }

    public ColumnDescriptor getColumnDescriptor(int columnNumber) {
        return this.columnDescriptorList.getColumnDescriptor(this.oid, columnNumber);
    }

    public ConglomerateDescriptor[] getConglomerateDescriptors() {
        int size = this.conglomerateDescriptorList.size();
        ConglomerateDescriptor[] cdls = new ConglomerateDescriptor[size];
        this.conglomerateDescriptorList.toArray(cdls);
        return cdls;
    }

    public ConglomerateDescriptor getConglomerateDescriptor(long conglomerateNumber) throws StandardException {
        return this.conglomerateDescriptorList.getConglomerateDescriptor(conglomerateNumber);
    }

    public ConglomerateDescriptor[] getConglomerateDescriptors(long conglomerateNumber) throws StandardException {
        return this.conglomerateDescriptorList.getConglomerateDescriptors(conglomerateNumber);
    }

    public ConglomerateDescriptor getConglomerateDescriptor(UUID conglomerateUUID) throws StandardException {
        return this.conglomerateDescriptorList.getConglomerateDescriptor(conglomerateUUID);
    }

    public ConglomerateDescriptor[] getConglomerateDescriptors(UUID conglomerateUUID) throws StandardException {
        return this.conglomerateDescriptorList.getConglomerateDescriptors(conglomerateUUID);
    }

    public IndexLister getIndexLister() throws StandardException {
        return new IndexLister(this);
    }

    public boolean tableHasAutoincrement() {
        int cdlSize = this.getColumnDescriptorList().size();
        for (int index = 0; index < cdlSize; ++index) {
            ColumnDescriptor cd = this.columnDescriptorList.elementAt(index);
            if (!cd.isAutoincrement()) continue;
            return true;
        }
        return false;
    }

    public String[] getColumnNamesArray() {
        int size = this.getNumberOfColumns();
        String[] s = new String[size];
        for (int i = 0; i < size; ++i) {
            s[i] = this.getColumnDescriptor(i + 1).getColumnName();
        }
        return s;
    }

    public long[] getAutoincIncrementArray() {
        if (!this.tableHasAutoincrement()) {
            return null;
        }
        int size = this.getNumberOfColumns();
        long[] inc = new long[size];
        for (int i = 0; i < size; ++i) {
            ColumnDescriptor cd = this.getColumnDescriptor(i + 1);
            if (!cd.isAutoincrement()) continue;
            inc[i] = cd.getAutoincInc();
        }
        return inc;
    }

    private synchronized List getStatistics() throws StandardException {
        if (this.statisticsDescriptorList != null) {
            return this.statisticsDescriptorList;
        }
        DataDictionary dd = this.getDataDictionary();
        this.statisticsDescriptorList = dd.getStatisticsDescriptors(this);
        return this.statisticsDescriptorList;
    }

    public boolean statisticsExist(ConglomerateDescriptor cd) throws StandardException {
        List sdl = this.getStatistics();
        if (cd == null) {
            return sdl.size() > 0;
        }
        UUID cdUUID = cd.getUUID();
        Iterator li = sdl.iterator();
        while (li.hasNext()) {
            StatisticsDescriptor statDesc = (StatisticsDescriptor)li.next();
            if (!cdUUID.equals(statDesc.getReferenceID())) continue;
            return true;
        }
        return false;
    }

    public double selectivityForConglomerate(ConglomerateDescriptor cd, int numKeys) throws StandardException {
        if (!this.statisticsExist(cd)) {
            SanityManager.THROWASSERT("no statistics exist for conglomerate" + cd);
        }
        UUID referenceUUID = cd.getUUID();
        List sdl = this.getStatistics();
        Iterator li = sdl.iterator();
        while (li.hasNext()) {
            StatisticsDescriptor statDesc = (StatisticsDescriptor)li.next();
            if (!referenceUUID.equals(statDesc.getReferenceID()) || statDesc.getColumnCount() != numKeys) continue;
            return statDesc.getStatistic().selectivity(null);
        }
        SanityManager.THROWASSERT("Internal Error-- statistics not found in selectivityForConglomerate.\n cd = " + cd + "\nnumKeys = " + numKeys);
        return 0.1;
    }

    public String getDescriptorName() {
        return this.tableName;
    }

    public String getDescriptorType() {
        return this.tableType == 4 ? "Synonym" : "Table/View";
    }
}

