/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.services.reflect;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectStreamClass;
import java.util.Properties;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.compiler.ClassBuilder;
import org.apache.derby.iapi.services.compiler.JavaFactory;
import org.apache.derby.iapi.services.compiler.MethodBuilder;
import org.apache.derby.iapi.services.i18n.MessageService;
import org.apache.derby.iapi.services.io.FileUtil;
import org.apache.derby.iapi.services.loader.ClassFactory;
import org.apache.derby.iapi.services.loader.ClassInspector;
import org.apache.derby.iapi.services.loader.GeneratedClass;
import org.apache.derby.iapi.services.monitor.ModuleControl;
import org.apache.derby.iapi.services.monitor.Monitor;
import org.apache.derby.iapi.services.sanity.SanityManager;
import org.apache.derby.iapi.services.stream.HeaderPrintWriter;
import org.apache.derby.iapi.util.ByteArray;
import org.apache.derby.impl.services.reflect.JarLoader;
import org.apache.derby.impl.services.reflect.LoadedGeneratedClass;
import org.apache.derby.impl.services.reflect.UpdateLoader;

abstract class DatabaseClasses
implements ClassFactory,
ModuleControl {
    private ClassInspector classInspector;
    private JavaFactory javaFactory;
    private UpdateLoader applicationLoader;

    DatabaseClasses() {
    }

    public void boot(boolean create, Properties startParams) throws StandardException {
        this.classInspector = new ClassInspector(this);
        String classpath = null;
        if (startParams != null) {
            classpath = startParams.getProperty("derby.__rt.database.classpath");
        }
        if (classpath != null) {
            this.applicationLoader = new UpdateLoader(classpath, this, true, true);
        }
        this.javaFactory = (JavaFactory)Monitor.startSystemModule("org.apache.derby.iapi.services.compiler.JavaFactory");
    }

    public void stop() {
        if (this.applicationLoader != null) {
            this.applicationLoader.close();
        }
    }

    public final GeneratedClass loadGeneratedClass(String fullyQualifiedName, ByteArray classDump) throws StandardException {
        try {
            return this.loadGeneratedClassFromData(fullyQualifiedName, classDump);
        }
        catch (LinkageError le) {
            DatabaseClasses.WriteClassFile(fullyQualifiedName, classDump, le);
            throw StandardException.newException("XBCM1.S", le, (Object)fullyQualifiedName);
        }
        catch (VirtualMachineError vme) {
            DatabaseClasses.WriteClassFile(fullyQualifiedName, classDump, vme);
            throw vme;
        }
    }

    private static void WriteClassFile(String fullyQualifiedName, ByteArray bytecode, Throwable t) {
        int lastDot = fullyQualifiedName.lastIndexOf(46);
        String filename = fullyQualifiedName.substring(lastDot + 1, fullyQualifiedName.length()).concat(".class");
        Object env = Monitor.getMonitor().getEnvironment();
        File dir = env instanceof File ? (File)env : null;
        File classFile = FileUtil.newFile(dir, filename);
        HeaderPrintWriter errorStream = Monitor.getStream();
        try {
            FileOutputStream fis = new FileOutputStream(classFile);
            fis.write(bytecode.getArray(), bytecode.getOffset(), bytecode.getLength());
            fis.flush();
            if (t != null) {
                errorStream.printlnWithHeader(MessageService.getTextMessage("C000", fullyQualifiedName, classFile, t));
            }
            fis.close();
        }
        catch (IOException e) {
            SanityManager.THROWASSERT("Unable to write .class file");
        }
    }

    public ClassInspector getClassInspector() {
        return this.classInspector;
    }

    public final Class loadApplicationClass(String className) throws ClassNotFoundException {
        Throwable loadError;
        if (className.startsWith("org.apache.derby.")) {
            try {
                return Class.forName(className);
            }
            catch (ClassNotFoundException cnfe) {
                // empty catch block
            }
        }
        try {
            try {
                return this.loadClassNotInDatabaseJar(className);
            }
            catch (ClassNotFoundException cnfe) {
                if (this.applicationLoader == null) {
                    throw cnfe;
                }
                Class c = this.applicationLoader.loadClass(className, true);
                if (c == null) {
                    throw cnfe;
                }
                return c;
            }
        }
        catch (SecurityException se) {
            loadError = se;
        }
        catch (LinkageError le) {
            loadError = le;
        }
        throw new ClassNotFoundException(className + " : " + loadError.getMessage());
    }

    abstract Class loadClassNotInDatabaseJar(String var1) throws ClassNotFoundException;

    public final Class loadApplicationClass(ObjectStreamClass classDescriptor) throws ClassNotFoundException {
        return this.loadApplicationClass(classDescriptor.getName());
    }

    public boolean isApplicationClass(Class theClass) {
        return theClass.getClassLoader() instanceof JarLoader;
    }

    public void notifyModifyJar(boolean reload) throws StandardException {
        if (this.applicationLoader != null) {
            this.applicationLoader.modifyJar(reload);
        }
    }

    public void notifyModifyClasspath(String classpath) throws StandardException {
        if (this.applicationLoader != null) {
            this.applicationLoader.modifyClasspath(classpath);
        }
    }

    public int getClassLoaderVersion() {
        if (this.applicationLoader != null) {
            return this.applicationLoader.getClassLoaderVersion();
        }
        return -1;
    }

    public ByteArray buildSpecificFactory(String className, String factoryName) throws StandardException {
        ClassBuilder cb = this.javaFactory.newClassBuilder(this, "org.apache.derby.exe.", 17, factoryName, "org.apache.derby.impl.services.reflect.GCInstanceFactory");
        MethodBuilder constructor = cb.newConstructorBuilder(1);
        constructor.callSuper();
        constructor.methodReturn();
        constructor.complete();
        constructor = null;
        MethodBuilder noArg = cb.newMethodBuilder(1, "org.apache.derby.iapi.services.loader.GeneratedByteCode", "getNewInstance");
        noArg.pushNewStart(className);
        noArg.pushNewComplete(0);
        noArg.methodReturn();
        noArg.complete();
        noArg = null;
        return cb.getClassBytecode();
    }

    abstract LoadedGeneratedClass loadGeneratedClassFromData(String var1, ByteArray var2);
}

