/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.compile;

import java.util.Vector;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.types.TypeId;
import org.apache.derby.impl.sql.compile.FromList;
import org.apache.derby.impl.sql.compile.OrderedColumn;
import org.apache.derby.impl.sql.compile.SubqueryList;
import org.apache.derby.impl.sql.compile.ValueNode;

public class GroupByColumn
extends OrderedColumn {
    private ValueNode columnExpression;

    public void init(Object colRef) {
        this.columnExpression = (ValueNode)colRef;
    }

    public String toString() {
        return "Column Expression: " + this.columnExpression + super.toString();
    }

    public void printSubNodes(int depth) {
        super.printSubNodes(depth);
        if (this.columnExpression != null) {
            this.printLabel(depth, "colRef: ");
            this.columnExpression.treePrint(depth + 1);
        }
    }

    public String getColumnName() {
        return this.columnExpression.getColumnName();
    }

    public void bindExpression(FromList fromList, SubqueryList subqueryList, Vector aggregateVector) throws StandardException {
        this.columnExpression = this.columnExpression.bindExpression(fromList, subqueryList, aggregateVector);
        if (this.columnExpression.isParameterNode()) {
            throw StandardException.newException("42Y36", this.columnExpression);
        }
        TypeId ctid = this.columnExpression.getTypeId();
        if (!ctid.orderable(this.getClassFactory())) {
            throw StandardException.newException("X0X67.S", ctid.getSQLTypeName());
        }
    }

    public ValueNode getColumnExpression() {
        return this.columnExpression;
    }

    public void setColumnExpression(ValueNode cexpr) {
        this.columnExpression = cexpr;
    }
}

