/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.compile;

import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.sql.compile.CompilerContext;
import org.apache.derby.iapi.sql.dictionary.ConglomerateDescriptor;
import org.apache.derby.iapi.sql.dictionary.DataDictionary;
import org.apache.derby.iapi.sql.dictionary.SchemaDescriptor;
import org.apache.derby.iapi.sql.dictionary.TableDescriptor;
import org.apache.derby.iapi.sql.execute.ConstantAction;
import org.apache.derby.impl.sql.compile.MiscellaneousStatementNode;
import org.apache.derby.impl.sql.compile.TableName;

public class LockTableNode
extends MiscellaneousStatementNode {
    private TableName tableName;
    private boolean exclusiveMode;
    private long conglomerateNumber;
    private TableDescriptor lockTableDescriptor;

    public void init(Object tableName, Object exclusiveMode) {
        this.tableName = (TableName)tableName;
        this.exclusiveMode = (Boolean)exclusiveMode;
    }

    public String toString() {
        return "tableName: " + this.tableName + "\n" + "exclusiveMode: " + this.exclusiveMode + "\n" + "conglomerateNumber: " + this.conglomerateNumber + "\n" + super.toString();
    }

    public String statementToString() {
        return "LOCK TABLE";
    }

    public void bindStatement() throws StandardException {
        CompilerContext cc = this.getCompilerContext();
        DataDictionary dd = this.getDataDictionary();
        String schemaName = this.tableName.getSchemaName();
        SchemaDescriptor sd = this.getSchemaDescriptor(schemaName);
        if (sd.isSystemSchema()) {
            throw StandardException.newException("42X62", (Object)this.statementToString(), (Object)schemaName);
        }
        this.lockTableDescriptor = this.getTableDescriptor(this.tableName.getTableName(), sd);
        if (this.lockTableDescriptor == null) {
            TableName synonymTab = this.resolveTableToSynonym(this.tableName);
            if (synonymTab == null) {
                throw StandardException.newException("42X05", this.tableName);
            }
            this.tableName = synonymTab;
            sd = this.getSchemaDescriptor(this.tableName.getSchemaName());
            this.lockTableDescriptor = this.getTableDescriptor(synonymTab.getTableName(), sd);
            if (this.lockTableDescriptor == null) {
                throw StandardException.newException("42X05", this.tableName);
            }
        }
        if (this.lockTableDescriptor.getTableType() == 3) {
            throw StandardException.newException("42995");
        }
        this.conglomerateNumber = this.lockTableDescriptor.getHeapConglomerateId();
        ConglomerateDescriptor cd = this.lockTableDescriptor.getConglomerateDescriptor(this.conglomerateNumber);
        cc.createDependency(this.lockTableDescriptor);
        cc.createDependency(cd);
        if (this.isPrivilegeCollectionRequired()) {
            cc.pushCurrentPrivType(0);
            cc.addRequiredTablePriv(this.lockTableDescriptor);
            cc.popCurrentPrivType();
        }
    }

    public boolean referencesSessionSchema() throws StandardException {
        return this.isSessionSchema(this.lockTableDescriptor.getSchemaName());
    }

    public ConstantAction makeConstantAction() throws StandardException {
        return this.getGenericConstantActionFactory().getLockTableConstantAction(this.tableName.getFullTableName(), this.conglomerateNumber, this.exclusiveMode);
    }
}

