/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.compile;

import java.util.Vector;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.compiler.LocalField;
import org.apache.derby.iapi.services.compiler.MethodBuilder;
import org.apache.derby.iapi.sql.compile.Visitable;
import org.apache.derby.iapi.sql.compile.Visitor;
import org.apache.derby.iapi.types.DataTypeDescriptor;
import org.apache.derby.iapi.types.JSQLType;
import org.apache.derby.iapi.util.JBitSet;
import org.apache.derby.impl.sql.compile.ExpressionClassBuilder;
import org.apache.derby.impl.sql.compile.FromList;
import org.apache.derby.impl.sql.compile.JavaValueNode;
import org.apache.derby.impl.sql.compile.ParameterNode;
import org.apache.derby.impl.sql.compile.PredicateList;
import org.apache.derby.impl.sql.compile.SubqueryList;
import org.apache.derby.impl.sql.compile.UnaryOperatorNode;
import org.apache.derby.impl.sql.compile.ValueNode;

public class SQLToJavaValueNode
extends JavaValueNode {
    ValueNode value;
    LocalField returnsNullOnNullState;

    public void init(Object value) {
        this.value = (ValueNode)value;
    }

    public void printSubNodes(int depth) {
        super.printSubNodes(depth);
        if (this.value != null) {
            this.printLabel(depth, "value: ");
            this.value.treePrint(depth + 1);
        }
    }

    public String getJavaTypeName() throws StandardException {
        JSQLType myType = this.getJSQLType();
        if (myType == null) {
            return "";
        }
        return this.mapToTypeID(myType).getCorrespondingJavaTypeName();
    }

    public String getPrimitiveTypeName() throws StandardException {
        JSQLType myType = this.getJSQLType();
        if (myType == null) {
            return "";
        }
        return this.getTypeCompiler(this.mapToTypeID(myType)).getCorrespondingPrimitiveTypeName();
    }

    public JSQLType getJSQLType() throws StandardException {
        if (this.jsqlType == null) {
            if (this.value.requiresTypeFromContext()) {
                ParameterNode pn = this.value instanceof UnaryOperatorNode ? ((UnaryOperatorNode)this.value).getParameterOperand() : (ParameterNode)this.value;
                this.jsqlType = pn.getJSQLType();
            } else {
                DataTypeDescriptor dtd = this.value.getTypeServices();
                if (dtd != null) {
                    this.jsqlType = new JSQLType(dtd);
                }
            }
        }
        return this.jsqlType;
    }

    public JavaValueNode bindExpression(FromList fromList, SubqueryList subqueryList, Vector aggregateVector) throws StandardException {
        this.value = this.value.bindExpression(fromList, subqueryList, aggregateVector);
        return this;
    }

    public JavaValueNode remapColumnReferencesToExpressions() throws StandardException {
        this.value = this.value.remapColumnReferencesToExpressions();
        return this;
    }

    public boolean categorize(JBitSet referencedTabs, boolean simplePredsOnly) throws StandardException {
        return this.value.categorize(referencedTabs, simplePredsOnly);
    }

    public void preprocess(int numTables, FromList outerFromList, SubqueryList outerSubqueryList, PredicateList outerPredicateList) throws StandardException {
        this.value.preprocess(numTables, outerFromList, outerSubqueryList, outerPredicateList);
    }

    protected int getOrderableVariantType() throws StandardException {
        return this.value.getOrderableVariantType();
    }

    public void generateExpression(ExpressionClassBuilder acb, MethodBuilder mb) throws StandardException {
        this.generateSQLValue(acb, mb);
        this.generateJavaValue(acb, mb);
    }

    private void generateSQLValue(ExpressionClassBuilder acb, MethodBuilder mb) throws StandardException {
        this.value.generateExpression(acb, mb);
    }

    private void generateJavaValue(ExpressionClassBuilder acb, MethodBuilder mbex) throws StandardException {
        if (this.isPrimitiveType() || this.mustCastToPrimitive()) {
            String primitiveTN = this.value.getTypeCompiler().getCorrespondingPrimitiveTypeName();
            String[] pd = new String[]{this.getSQLValueInterfaceName()};
            MethodBuilder mb = acb.newGeneratedFun(primitiveTN, 2, pd);
            mb.getParameter(0);
            if (this.returnsNullOnNullState != null) {
                this.generateReturnsNullOnNullCheck(mb);
            } else {
                mb.dup();
                mb.upCast("org.apache.derby.iapi.types.DataValueDescriptor");
                mb.push(primitiveTN);
                mb.callMethod((short)184, "org.apache.derby.impl.sql.execute.BaseActivation", "nullToPrimitiveTest", "void", 2);
            }
            mb.callMethod((short)185, "org.apache.derby.iapi.types.DataValueDescriptor", this.value.getTypeCompiler().getPrimitiveMethodName(), primitiveTN, 0);
            mb.methodReturn();
            mb.complete();
            mbex.pushThis();
            mbex.swap();
            mbex.callMethod((short)182, null, mb.getName(), primitiveTN, 1);
        } else {
            if (this.returnsNullOnNullState != null) {
                this.generateReturnsNullOnNullCheck(mbex);
            }
            mbex.callMethod((short)185, "org.apache.derby.iapi.types.DataValueDescriptor", "getObject", "java.lang.Object", 0);
            mbex.cast(this.value.getTypeId().getCorrespondingJavaTypeName());
        }
    }

    private void generateReturnsNullOnNullCheck(MethodBuilder mb) {
        mb.dup();
        mb.callMethod((short)185, "org.apache.derby.iapi.services.io.Storable", "isNull", "boolean", 0);
        mb.conditionalIf();
        mb.push(true);
        mb.startElseCode();
        mb.getField(this.returnsNullOnNullState);
        mb.completeConditional();
        mb.setField(this.returnsNullOnNullState);
    }

    private String getSQLValueInterfaceName() throws StandardException {
        return this.value.getTypeCompiler().interfaceName();
    }

    ValueNode getSQLValueNode() {
        return this.value;
    }

    Object getConstantValueAsObject() throws StandardException {
        return this.value.getConstantValueAsObject();
    }

    public Visitable accept(Visitor v) throws StandardException {
        Visitable returnNode = v.visit(this);
        if (v.skipChildren(this)) {
            return returnNode;
        }
        if (this.value != null && !v.stopTraversal()) {
            this.value = (ValueNode)this.value.accept(v);
        }
        return returnNode;
    }
}

