/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.execute;

import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.jdbc.AuthenticationService;
import org.apache.derby.iapi.services.property.PropertyUtil;
import org.apache.derby.iapi.sql.Activation;
import org.apache.derby.iapi.sql.conn.LanguageConnectionContext;
import org.apache.derby.iapi.sql.dictionary.DataDescriptorGenerator;
import org.apache.derby.iapi.sql.dictionary.DataDictionary;
import org.apache.derby.iapi.sql.dictionary.RoleGrantDescriptor;
import org.apache.derby.iapi.store.access.TransactionController;
import org.apache.derby.impl.jdbc.authentication.BasicAuthenticationServiceImpl;
import org.apache.derby.impl.sql.execute.DDLConstantAction;

class CreateRoleConstantAction
extends DDLConstantAction {
    private String roleName;

    public CreateRoleConstantAction(String roleName) {
        this.roleName = roleName;
    }

    public void executeConstantAction(Activation activation) throws StandardException {
        LanguageConnectionContext lcc = activation.getLanguageConnectionContext();
        DataDictionary dd = lcc.getDataDictionary();
        TransactionController tc = lcc.getTransactionExecute();
        DataDescriptorGenerator ddg = dd.getDataDescriptorGenerator();
        if (this.roleName.equals("PUBLIC")) {
            throw StandardException.newException("4251B");
        }
        String currentAuthId = lcc.getAuthorizationId();
        dd.startWriting(lcc);
        RoleGrantDescriptor rdDef = dd.getRoleDefinitionDescriptor(this.roleName);
        if (rdDef != null) {
            throw StandardException.newException("X0Y68.S", (Object)rdDef.getDescriptorType(), (Object)this.roleName);
        }
        if (this.knownUser(this.roleName, currentAuthId, lcc, dd, tc)) {
            throw StandardException.newException("X0Y68.S", (Object)"User", (Object)this.roleName);
        }
        rdDef = ddg.newRoleGrantDescriptor(dd.getUUIDFactory().createUUID(), this.roleName, currentAuthId, "_SYSTEM", true, true);
        dd.addDescriptor(rdDef, null, 19, false, tc);
    }

    public String toString() {
        return "CREATE ROLE " + this.roleName;
    }

    private boolean knownUser(String roleName, String currentUser, LanguageConnectionContext lcc, DataDictionary dd, TransactionController tc) throws StandardException {
        AuthenticationService s = lcc.getDatabase().getAuthenticationService();
        if (currentUser.equals(roleName)) {
            return true;
        }
        if (s instanceof BasicAuthenticationServiceImpl && PropertyUtil.existsBuiltinUser(tc, roleName)) {
            return true;
        }
        if (dd.existsGrantToAuthid(roleName, tc)) {
            return true;
        }
        return dd.existsSchemaOwnedBy(roleName, tc);
    }
}

