/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.store.raw.data;

import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.daemon.DaemonService;
import org.apache.derby.iapi.services.sanity.SanityManager;
import org.apache.derby.iapi.store.raw.ContainerHandle;
import org.apache.derby.iapi.store.raw.ContainerKey;
import org.apache.derby.iapi.store.raw.LockingPolicy;
import org.apache.derby.iapi.store.raw.Page;
import org.apache.derby.iapi.store.raw.PageKey;
import org.apache.derby.iapi.store.raw.RecordHandle;
import org.apache.derby.iapi.store.raw.Transaction;
import org.apache.derby.iapi.store.raw.data.RawContainerHandle;
import org.apache.derby.iapi.store.raw.xact.RawTransaction;
import org.apache.derby.impl.store.raw.data.BaseDataFileFactory;
import org.apache.derby.impl.store.raw.data.ContainerOperation;
import org.apache.derby.impl.store.raw.data.ReclaimSpace;
import org.apache.derby.impl.store.raw.data.StoredPage;

public class ReclaimSpaceHelper {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int reclaimSpace(BaseDataFileFactory dataFactory, RawTransaction tran, ReclaimSpace work) throws StandardException {
        if (work.reclaimWhat() == 1) {
            return ReclaimSpaceHelper.reclaimContainer(dataFactory, tran, work);
        }
        LockingPolicy container_rlock = tran.newLockingPolicy(1, 5, true);
        SanityManager.ASSERT(container_rlock != null);
        ContainerHandle containerHdl = ReclaimSpaceHelper.openContainerNW(tran, container_rlock, work.getContainerId());
        if (containerHdl == null) {
            tran.abort();
            if (SanityManager.DEBUG_ON(DaemonService.DaemonTrace)) {
                SanityManager.DEBUG(DaemonService.DaemonTrace, " aborted " + work + " because container is locked or dropped");
            }
            if (work.incrAttempts() < 3) {
                return 2;
            }
            if (SanityManager.DEBUG_ON(DaemonService.DaemonTrace)) {
                SanityManager.DEBUG(DaemonService.DaemonTrace, "  gave up after 3 tries to get container lock " + work);
            }
            return 1;
        }
        if (work.reclaimWhat() == 2) {
            Page p = containerHdl.getPageNoWait(work.getPageId().getPageNumber());
            if (p != null) {
                containerHdl.removePage(p);
            }
            tran.commit();
            return 1;
        }
        RecordHandle headRecord = work.getHeadRowHandle();
        if (!container_rlock.lockRecordForWrite(tran, headRecord, false, false)) {
            tran.abort();
            if (work.incrAttempts() < 3) {
                return 2;
            }
            if (SanityManager.DEBUG_ON(DaemonService.DaemonTrace)) {
                SanityManager.DEBUG(DaemonService.DaemonTrace, "  gave up after 3 tries to get row lock " + work);
            }
            return 1;
        }
        if (work.reclaimWhat() == 3) {
            containerHdl.compactRecord(headRecord);
            tran.commitNoSync(1);
            return 1;
        }
        SanityManager.ASSERT(work.reclaimWhat() == 4);
        long headPageId = ((PageKey)headRecord.getPageId()).getPageNumber();
        StoredPage headRowPage = (StoredPage)containerHdl.getPage(headPageId);
        if (headRowPage == null) {
            if (SanityManager.DEBUG_ON(DaemonService.DaemonTrace)) {
                SanityManager.DEBUG(DaemonService.DaemonTrace, "gave up because hadRowPage was null" + work);
            }
            tran.abort();
            return 1;
        }
        try {
            headRowPage.removeOrphanedColumnChain(work, containerHdl);
            Object var10_9 = null;
        }
        catch (Throwable throwable) {
            Object var10_10 = null;
            headRowPage.unlatch();
            throw throwable;
        }
        headRowPage.unlatch();
        tran.commitNoSync(1);
        return 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static int reclaimContainer(BaseDataFileFactory dataFactory, RawTransaction tran, ReclaimSpace work) throws StandardException {
        LockingPolicy container_xlock = tran.newLockingPolicy(2, 5, true);
        SanityManager.ASSERT(container_xlock != null);
        RawContainerHandle containerHdl = tran.openDroppedContainer(work.getContainerId(), container_xlock);
        if (containerHdl == null || containerHdl.getContainerStatus() == 1 || containerHdl.getContainerStatus() == 4) {
            if (containerHdl != null) {
                containerHdl.close();
            }
            tran.abort();
            if (SanityManager.DEBUG_ON(DaemonService.DaemonTrace)) {
                SanityManager.DEBUG(DaemonService.DaemonTrace, "  aborted " + work);
            }
        } else {
            ContainerOperation lop = new ContainerOperation(containerHdl, 4);
            containerHdl.preDirty(true);
            try {
                tran.logAndDo(lop);
                Object var7_6 = null;
            }
            catch (Throwable throwable) {
                Object var7_7 = null;
                containerHdl.preDirty(false);
                throw throwable;
            }
            containerHdl.preDirty(false);
            containerHdl.close();
            tran.commit();
            if (SanityManager.DEBUG_ON(DaemonService.DaemonTrace)) {
                SanityManager.DEBUG(DaemonService.DaemonTrace, "  committed " + work);
            }
        }
        return 1;
    }

    private static ContainerHandle openContainerNW(Transaction tran, LockingPolicy rlock, ContainerKey containerId) throws StandardException {
        ContainerHandle containerHdl;
        block2: {
            containerHdl = null;
            try {
                containerHdl = tran.openContainer(containerId, rlock, 132);
            }
            catch (StandardException se) {
                if (se.getSQLState().equals("40XL1")) break block2;
                throw se;
            }
        }
        return containerHdl;
    }
}

