/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hssf.dev;

import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStreamWriter;
import java.io.PrintStream;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import org.apache.poi.hssf.record.AreaFormatRecord;
import org.apache.poi.hssf.record.AreaRecord;
import org.apache.poi.hssf.record.ArrayRecord;
import org.apache.poi.hssf.record.AxisLineFormatRecord;
import org.apache.poi.hssf.record.AxisOptionsRecord;
import org.apache.poi.hssf.record.AxisParentRecord;
import org.apache.poi.hssf.record.AxisRecord;
import org.apache.poi.hssf.record.AxisUsedRecord;
import org.apache.poi.hssf.record.BOFRecord;
import org.apache.poi.hssf.record.BackupRecord;
import org.apache.poi.hssf.record.BarRecord;
import org.apache.poi.hssf.record.BeginRecord;
import org.apache.poi.hssf.record.BlankRecord;
import org.apache.poi.hssf.record.BookBoolRecord;
import org.apache.poi.hssf.record.BoolErrRecord;
import org.apache.poi.hssf.record.BottomMarginRecord;
import org.apache.poi.hssf.record.BoundSheetRecord;
import org.apache.poi.hssf.record.CFHeaderRecord;
import org.apache.poi.hssf.record.CFRuleRecord;
import org.apache.poi.hssf.record.CalcCountRecord;
import org.apache.poi.hssf.record.CalcModeRecord;
import org.apache.poi.hssf.record.CategorySeriesAxisRecord;
import org.apache.poi.hssf.record.ChartFormatRecord;
import org.apache.poi.hssf.record.ChartRecord;
import org.apache.poi.hssf.record.CodepageRecord;
import org.apache.poi.hssf.record.ColumnInfoRecord;
import org.apache.poi.hssf.record.ContinueRecord;
import org.apache.poi.hssf.record.CountryRecord;
import org.apache.poi.hssf.record.DBCellRecord;
import org.apache.poi.hssf.record.DSFRecord;
import org.apache.poi.hssf.record.DVALRecord;
import org.apache.poi.hssf.record.DVRecord;
import org.apache.poi.hssf.record.DatRecord;
import org.apache.poi.hssf.record.DataFormatRecord;
import org.apache.poi.hssf.record.DateWindow1904Record;
import org.apache.poi.hssf.record.DefaultColWidthRecord;
import org.apache.poi.hssf.record.DefaultDataLabelTextPropertiesRecord;
import org.apache.poi.hssf.record.DefaultRowHeightRecord;
import org.apache.poi.hssf.record.DeltaRecord;
import org.apache.poi.hssf.record.DimensionsRecord;
import org.apache.poi.hssf.record.DrawingGroupRecord;
import org.apache.poi.hssf.record.DrawingRecordForBiffViewer;
import org.apache.poi.hssf.record.DrawingSelectionRecord;
import org.apache.poi.hssf.record.EOFRecord;
import org.apache.poi.hssf.record.EndRecord;
import org.apache.poi.hssf.record.ExtSSTRecord;
import org.apache.poi.hssf.record.ExtendedFormatRecord;
import org.apache.poi.hssf.record.ExternSheetRecord;
import org.apache.poi.hssf.record.FilePassRecord;
import org.apache.poi.hssf.record.FileSharingRecord;
import org.apache.poi.hssf.record.FnGroupCountRecord;
import org.apache.poi.hssf.record.FontBasisRecord;
import org.apache.poi.hssf.record.FontIndexRecord;
import org.apache.poi.hssf.record.FontRecord;
import org.apache.poi.hssf.record.FooterRecord;
import org.apache.poi.hssf.record.FormatRecord;
import org.apache.poi.hssf.record.FormulaRecord;
import org.apache.poi.hssf.record.FrameRecord;
import org.apache.poi.hssf.record.GridsetRecord;
import org.apache.poi.hssf.record.GutsRecord;
import org.apache.poi.hssf.record.HCenterRecord;
import org.apache.poi.hssf.record.HeaderRecord;
import org.apache.poi.hssf.record.HideObjRecord;
import org.apache.poi.hssf.record.HorizontalPageBreakRecord;
import org.apache.poi.hssf.record.HyperlinkRecord;
import org.apache.poi.hssf.record.IndexRecord;
import org.apache.poi.hssf.record.InterfaceEndRecord;
import org.apache.poi.hssf.record.InterfaceHdrRecord;
import org.apache.poi.hssf.record.IterationRecord;
import org.apache.poi.hssf.record.LabelRecord;
import org.apache.poi.hssf.record.LabelSSTRecord;
import org.apache.poi.hssf.record.LeftMarginRecord;
import org.apache.poi.hssf.record.LegendRecord;
import org.apache.poi.hssf.record.LineFormatRecord;
import org.apache.poi.hssf.record.LinkedDataRecord;
import org.apache.poi.hssf.record.MMSRecord;
import org.apache.poi.hssf.record.MergeCellsRecord;
import org.apache.poi.hssf.record.MulBlankRecord;
import org.apache.poi.hssf.record.MulRKRecord;
import org.apache.poi.hssf.record.NameRecord;
import org.apache.poi.hssf.record.NoteRecord;
import org.apache.poi.hssf.record.NumberRecord;
import org.apache.poi.hssf.record.ObjRecord;
import org.apache.poi.hssf.record.ObjectLinkRecord;
import org.apache.poi.hssf.record.PaletteRecord;
import org.apache.poi.hssf.record.PaneRecord;
import org.apache.poi.hssf.record.PasswordRecord;
import org.apache.poi.hssf.record.PasswordRev4Record;
import org.apache.poi.hssf.record.PlotAreaRecord;
import org.apache.poi.hssf.record.PlotGrowthRecord;
import org.apache.poi.hssf.record.PrecisionRecord;
import org.apache.poi.hssf.record.PrintGridlinesRecord;
import org.apache.poi.hssf.record.PrintHeadersRecord;
import org.apache.poi.hssf.record.PrintSetupRecord;
import org.apache.poi.hssf.record.ProtectRecord;
import org.apache.poi.hssf.record.ProtectionRev4Record;
import org.apache.poi.hssf.record.RKRecord;
import org.apache.poi.hssf.record.Record;
import org.apache.poi.hssf.record.RecordFormatException;
import org.apache.poi.hssf.record.RecordInputStream;
import org.apache.poi.hssf.record.RefModeRecord;
import org.apache.poi.hssf.record.RefreshAllRecord;
import org.apache.poi.hssf.record.RightMarginRecord;
import org.apache.poi.hssf.record.RowRecord;
import org.apache.poi.hssf.record.SCLRecord;
import org.apache.poi.hssf.record.SSTRecord;
import org.apache.poi.hssf.record.SaveRecalcRecord;
import org.apache.poi.hssf.record.SelectionRecord;
import org.apache.poi.hssf.record.SeriesIndexRecord;
import org.apache.poi.hssf.record.SeriesListRecord;
import org.apache.poi.hssf.record.SeriesRecord;
import org.apache.poi.hssf.record.SeriesTextRecord;
import org.apache.poi.hssf.record.SeriesToChartGroupRecord;
import org.apache.poi.hssf.record.SharedFormulaRecord;
import org.apache.poi.hssf.record.SheetPropertiesRecord;
import org.apache.poi.hssf.record.StringRecord;
import org.apache.poi.hssf.record.StyleRecord;
import org.apache.poi.hssf.record.SupBookRecord;
import org.apache.poi.hssf.record.TabIdRecord;
import org.apache.poi.hssf.record.TableRecord;
import org.apache.poi.hssf.record.TextObjectRecord;
import org.apache.poi.hssf.record.TextRecord;
import org.apache.poi.hssf.record.TickRecord;
import org.apache.poi.hssf.record.TopMarginRecord;
import org.apache.poi.hssf.record.UnitsRecord;
import org.apache.poi.hssf.record.UnknownRecord;
import org.apache.poi.hssf.record.UseSelFSRecord;
import org.apache.poi.hssf.record.VCenterRecord;
import org.apache.poi.hssf.record.ValueRangeRecord;
import org.apache.poi.hssf.record.VerticalPageBreakRecord;
import org.apache.poi.hssf.record.WSBoolRecord;
import org.apache.poi.hssf.record.WindowOneRecord;
import org.apache.poi.hssf.record.WindowProtectRecord;
import org.apache.poi.hssf.record.WindowTwoRecord;
import org.apache.poi.hssf.record.WriteAccessRecord;
import org.apache.poi.hssf.record.WriteProtectRecord;
import org.apache.poi.poifs.filesystem.DocumentInputStream;
import org.apache.poi.poifs.filesystem.POIFSFileSystem;
import org.apache.poi.util.HexDump;
import org.apache.poi.util.LittleEndian;

public final class BiffViewer {
    static final char[] NEW_LINE_CHARS = System.getProperty("line.separator").toCharArray();
    private static final int DUMP_LINE_LEN = 16;
    private static final char[] COLUMN_SEPARATOR = " | ".toCharArray();

    private BiffViewer() {
    }

    public static Record[] createRecords(InputStream is, PrintStream ps, BiffRecordListener recListener, boolean dumpInterpretedRecords) throws RecordFormatException {
        ArrayList<Record> temp = new ArrayList<Record>();
        RecordInputStream recStream = new RecordInputStream(is);
        while (recStream.hasNextRecord()) {
            Record record;
            recStream.nextRecord();
            if (recStream.getSid() == 0 || (record = BiffViewer.createRecord(recStream)).getSid() == 60) continue;
            temp.add(record);
            if (dumpInterpretedRecords) {
                String[] headers = recListener.getRecentHeaders();
                int i = 0;
                while (i < headers.length) {
                    ps.println(headers[i]);
                    ++i;
                }
                ps.print(record.toString());
            }
            ps.println();
        }
        Record[] result = new Record[temp.size()];
        temp.toArray(result);
        return result;
    }

    private static Record createRecord(RecordInputStream in) {
        switch (in.getSid()) {
            case 4106: {
                return new AreaFormatRecord(in);
            }
            case 4122: {
                return new AreaRecord(in);
            }
            case 545: {
                return new ArrayRecord(in);
            }
            case 4129: {
                return new AxisLineFormatRecord(in);
            }
            case 4194: {
                return new AxisOptionsRecord(in);
            }
            case 4161: {
                return new AxisParentRecord(in);
            }
            case 4125: {
                return new AxisRecord(in);
            }
            case 4166: {
                return new AxisUsedRecord(in);
            }
            case 2057: {
                return new BOFRecord(in);
            }
            case 64: {
                return new BackupRecord(in);
            }
            case 4119: {
                return new BarRecord(in);
            }
            case 4147: {
                return new BeginRecord(in);
            }
            case 513: {
                return new BlankRecord(in);
            }
            case 218: {
                return new BookBoolRecord(in);
            }
            case 517: {
                return new BoolErrRecord(in);
            }
            case 41: {
                return new BottomMarginRecord(in);
            }
            case 133: {
                return new BoundSheetRecord(in);
            }
            case 432: {
                return new CFHeaderRecord(in);
            }
            case 433: {
                return new CFRuleRecord(in);
            }
            case 12: {
                return new CalcCountRecord(in);
            }
            case 13: {
                return new CalcModeRecord(in);
            }
            case 4128: {
                return new CategorySeriesAxisRecord(in);
            }
            case 4116: {
                return new ChartFormatRecord(in);
            }
            case 4098: {
                return new ChartRecord(in);
            }
            case 66: {
                return new CodepageRecord(in);
            }
            case 125: {
                return new ColumnInfoRecord(in);
            }
            case 60: {
                return new ContinueRecord(in);
            }
            case 140: {
                return new CountryRecord(in);
            }
            case 215: {
                return new DBCellRecord(in);
            }
            case 353: {
                return new DSFRecord(in);
            }
            case 4195: {
                return new DatRecord(in);
            }
            case 4102: {
                return new DataFormatRecord(in);
            }
            case 34: {
                return new DateWindow1904Record(in);
            }
            case 85: {
                return new DefaultColWidthRecord(in);
            }
            case 4132: {
                return new DefaultDataLabelTextPropertiesRecord(in);
            }
            case 549: {
                return new DefaultRowHeightRecord(in);
            }
            case 16: {
                return new DeltaRecord(in);
            }
            case 512: {
                return new DimensionsRecord(in);
            }
            case 235: {
                return new DrawingGroupRecord(in);
            }
            case 236: {
                return new DrawingRecordForBiffViewer(in);
            }
            case 237: {
                return new DrawingSelectionRecord(in);
            }
            case 446: {
                return new DVRecord(in);
            }
            case 434: {
                return new DVALRecord(in);
            }
            case 10: {
                return new EOFRecord(in);
            }
            case 4148: {
                return new EndRecord(in);
            }
            case 255: {
                return new ExtSSTRecord(in);
            }
            case 224: {
                return new ExtendedFormatRecord(in);
            }
            case 23: {
                return new ExternSheetRecord(in);
            }
            case 47: {
                return new FilePassRecord(in);
            }
            case 91: {
                return new FileSharingRecord(in);
            }
            case 156: {
                return new FnGroupCountRecord(in);
            }
            case 4192: {
                return new FontBasisRecord(in);
            }
            case 4134: {
                return new FontIndexRecord(in);
            }
            case 49: {
                return new FontRecord(in);
            }
            case 21: {
                return new FooterRecord(in);
            }
            case 1054: {
                return new FormatRecord(in);
            }
            case 6: {
                return new FormulaRecord(in);
            }
            case 4146: {
                return new FrameRecord(in);
            }
            case 130: {
                return new GridsetRecord(in);
            }
            case 128: {
                return new GutsRecord(in);
            }
            case 131: {
                return new HCenterRecord(in);
            }
            case 20: {
                return new HeaderRecord(in);
            }
            case 141: {
                return new HideObjRecord(in);
            }
            case 27: {
                return new HorizontalPageBreakRecord(in);
            }
            case 440: {
                return new HyperlinkRecord(in);
            }
            case 523: {
                return new IndexRecord(in);
            }
            case 226: {
                return new InterfaceEndRecord(in);
            }
            case 225: {
                return new InterfaceHdrRecord(in);
            }
            case 17: {
                return new IterationRecord(in);
            }
            case 516: {
                return new LabelRecord(in);
            }
            case 253: {
                return new LabelSSTRecord(in);
            }
            case 38: {
                return new LeftMarginRecord(in);
            }
            case 4117: {
                return new LegendRecord(in);
            }
            case 4103: {
                return new LineFormatRecord(in);
            }
            case 4177: {
                return new LinkedDataRecord(in);
            }
            case 193: {
                return new MMSRecord(in);
            }
            case 229: {
                return new MergeCellsRecord(in);
            }
            case 190: {
                return new MulBlankRecord(in);
            }
            case 189: {
                return new MulRKRecord(in);
            }
            case 24: {
                return new NameRecord(in);
            }
            case 28: {
                return new NoteRecord(in);
            }
            case 515: {
                return new NumberRecord(in);
            }
            case 93: {
                return new ObjRecord(in);
            }
            case 4135: {
                return new ObjectLinkRecord(in);
            }
            case 146: {
                return new PaletteRecord(in);
            }
            case 65: {
                return new PaneRecord(in);
            }
            case 19: {
                return new PasswordRecord(in);
            }
            case 444: {
                return new PasswordRev4Record(in);
            }
            case 4149: {
                return new PlotAreaRecord(in);
            }
            case 4196: {
                return new PlotGrowthRecord(in);
            }
            case 14: {
                return new PrecisionRecord(in);
            }
            case 43: {
                return new PrintGridlinesRecord(in);
            }
            case 42: {
                return new PrintHeadersRecord(in);
            }
            case 161: {
                return new PrintSetupRecord(in);
            }
            case 18: {
                return new ProtectRecord(in);
            }
            case 431: {
                return new ProtectionRev4Record(in);
            }
            case 638: {
                return new RKRecord(in);
            }
            case 15: {
                return new RefModeRecord(in);
            }
            case 439: {
                return new RefreshAllRecord(in);
            }
            case 39: {
                return new RightMarginRecord(in);
            }
            case 520: {
                return new RowRecord(in);
            }
            case 160: {
                return new SCLRecord(in);
            }
            case 252: {
                return new SSTRecord(in);
            }
            case 95: {
                return new SaveRecalcRecord(in);
            }
            case 29: {
                return new SelectionRecord(in);
            }
            case 4197: {
                return new SeriesIndexRecord(in);
            }
            case 4118: {
                return new SeriesListRecord(in);
            }
            case 4099: {
                return new SeriesRecord(in);
            }
            case 4109: {
                return new SeriesTextRecord(in);
            }
            case 4165: {
                return new SeriesToChartGroupRecord(in);
            }
            case 1212: {
                return new SharedFormulaRecord(in);
            }
            case 4164: {
                return new SheetPropertiesRecord(in);
            }
            case 519: {
                return new StringRecord(in);
            }
            case 659: {
                return new StyleRecord(in);
            }
            case 430: {
                return new SupBookRecord(in);
            }
            case 317: {
                return new TabIdRecord(in);
            }
            case 566: {
                return new TableRecord(in);
            }
            case 438: {
                return new TextObjectRecord(in);
            }
            case 4133: {
                return new TextRecord(in);
            }
            case 4126: {
                return new TickRecord(in);
            }
            case 40: {
                return new TopMarginRecord(in);
            }
            case 4097: {
                return new UnitsRecord(in);
            }
            case 352: {
                return new UseSelFSRecord(in);
            }
            case 132: {
                return new VCenterRecord(in);
            }
            case 4127: {
                return new ValueRangeRecord(in);
            }
            case 26: {
                return new VerticalPageBreakRecord(in);
            }
            case 129: {
                return new WSBoolRecord(in);
            }
            case 61: {
                return new WindowOneRecord(in);
            }
            case 25: {
                return new WindowProtectRecord(in);
            }
            case 574: {
                return new WindowTwoRecord(in);
            }
            case 92: {
                return new WriteAccessRecord(in);
            }
            case 134: {
                return new WriteProtectRecord(in);
            }
        }
        return new UnknownRecord(in);
    }

    public static void main(String[] args) {
        System.setProperty("poi.deserialize.escher", "true");
        if (args.length == 0) {
            System.out.println("Biff viewer needs a filename");
            return;
        }
        try {
            String inFileName = args[0];
            File inputFile = new File(inFileName);
            if (!inputFile.exists()) {
                throw new RuntimeException("specified inputFile '" + inFileName + "' does not exist");
            }
            PrintStream ps = System.out;
            if (args.length > 1 && args[1].equals("bfd")) {
                POIFSFileSystem fs = new POIFSFileSystem(new FileInputStream(inputFile));
                DocumentInputStream stream = fs.createDocumentInputStream("Workbook");
                int size = ((InputStream)stream).available();
                byte[] data = new byte[size];
                ((InputStream)stream).read(data);
                HexDump.dump(data, 0L, System.out, 0);
            } else {
                boolean dumpInterpretedRecords = true;
                boolean dumpHex = args.length > 1 && args[1].equals("on");
                POIFSFileSystem fs = new POIFSFileSystem(new FileInputStream(inputFile));
                InputStream is = fs.createDocumentInputStream("Workbook");
                BiffRecordListener recListener = new BiffRecordListener(dumpHex ? new OutputStreamWriter(ps) : null);
                is = new BiffDumpingStream(is, recListener);
                BiffViewer.createRecords(is, ps, recListener, dumpInterpretedRecords);
            }
            ps.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    static void hexDumpAligned(Writer w, byte[] data, int baseDataOffset, int dumpLen, int globalOffset) {
        int globalStart = globalOffset + baseDataOffset;
        int globalEnd = globalOffset + baseDataOffset + dumpLen;
        int startDelta = globalStart % 16;
        int endDelta = globalEnd % 16;
        int startLineAddr = globalStart - startDelta;
        int endLineAddr = globalEnd - endDelta;
        int lineDataOffset = baseDataOffset - startDelta;
        int lineAddr = startLineAddr;
        if (startLineAddr == endLineAddr) {
            BiffViewer.hexDumpLine(w, data, lineAddr, lineDataOffset, startDelta, endDelta);
            return;
        }
        BiffViewer.hexDumpLine(w, data, lineAddr, lineDataOffset, startDelta, 16);
        while (true) {
            lineDataOffset += 16;
            if ((lineAddr += 16) >= endLineAddr) break;
            BiffViewer.hexDumpLine(w, data, lineAddr, lineDataOffset, 0, 16);
        }
        if (endDelta != 0) {
            BiffViewer.hexDumpLine(w, data, lineAddr, lineDataOffset, 0, endDelta);
        }
    }

    private static void hexDumpLine(Writer w, byte[] data, int lineStartAddress, int lineDataOffset, int startDelta, int endDelta) {
        if (startDelta >= endDelta) {
            throw new IllegalArgumentException("Bad start/end delta");
        }
        try {
            BiffViewer.writeHex(w, lineStartAddress, 8);
            w.write(COLUMN_SEPARATOR);
            int i = 0;
            while (i < 16) {
                if (i > 0) {
                    w.write(" ");
                }
                if (i >= startDelta && i < endDelta) {
                    BiffViewer.writeHex(w, data[lineDataOffset + i], 2);
                } else {
                    w.write("  ");
                }
                ++i;
            }
            w.write(COLUMN_SEPARATOR);
            i = 0;
            while (i < 16) {
                if (i >= startDelta && i < endDelta) {
                    w.write(BiffViewer.getPrintableChar(data[lineDataOffset + i]));
                } else {
                    w.write(" ");
                }
                ++i;
            }
            w.write(NEW_LINE_CHARS);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private static char getPrintableChar(byte b) {
        char ib = (char)(b & 0xFF);
        if (ib < ' ' || ib > '~') {
            return '.';
        }
        return ib;
    }

    private static void writeHex(Writer w, int value, int nDigits) throws IOException {
        char[] buf = new char[nDigits];
        int acc = value;
        int i = nDigits - 1;
        while (i >= 0) {
            int digit = acc & 0xF;
            buf[i] = (char)(digit < 10 ? 48 + digit : 65 + digit - 10);
            acc >>= 4;
            --i;
        }
        w.write(buf);
    }

    private static final class BiffDumpingStream
    extends InputStream {
        private final DataInputStream _is;
        private final IBiffRecordListener _listener;
        private final byte[] _data;
        private int _recordCounter;
        private int _overallStreamPos;
        private int _currentPos;
        private int _currentSize;
        private boolean _innerHasReachedEOF;

        public BiffDumpingStream(InputStream is, IBiffRecordListener listener) {
            this._is = new DataInputStream(is);
            this._listener = listener;
            this._data = new byte[8228];
            this._recordCounter = 0;
            this._overallStreamPos = 0;
            this._currentSize = 0;
            this._currentPos = 0;
        }

        public int read() throws IOException {
            if (this._currentPos >= this._currentSize) {
                this.fillNextBuffer();
            }
            if (this._currentPos >= this._currentSize) {
                return -1;
            }
            int result = this._data[this._currentPos] & 0xFF;
            ++this._currentPos;
            ++this._overallStreamPos;
            this.formatBufferIfAtEndOfRec();
            return result;
        }

        public int read(byte[] b, int off, int len) throws IOException {
            int result;
            if (this._currentPos >= this._currentSize) {
                this.fillNextBuffer();
            }
            if (this._currentPos >= this._currentSize) {
                return -1;
            }
            int availSize = this._currentSize - this._currentPos;
            if (len > availSize) {
                System.err.println("Unexpected request to read past end of current biff record");
                result = availSize;
            } else {
                result = len;
            }
            System.arraycopy(this._data, this._currentPos, b, off, result);
            this._currentPos += result;
            this._overallStreamPos += result;
            this.formatBufferIfAtEndOfRec();
            return result;
        }

        public int available() throws IOException {
            return this._currentSize - this._currentPos + this._is.available();
        }

        private void fillNextBuffer() throws IOException {
            if (this._innerHasReachedEOF) {
                return;
            }
            int b0 = this._is.read();
            if (b0 == -1) {
                this._innerHasReachedEOF = true;
                return;
            }
            this._data[0] = (byte)b0;
            this._is.readFully(this._data, 1, 3);
            short len = LittleEndian.getShort(this._data, 2);
            this._is.readFully(this._data, 4, len);
            this._currentPos = 0;
            this._currentSize = len + 4;
            ++this._recordCounter;
        }

        private void formatBufferIfAtEndOfRec() {
            if (this._currentPos != this._currentSize) {
                return;
            }
            int dataSize = this._currentSize - 4;
            short sid = LittleEndian.getShort(this._data, 0);
            int globalOffset = this._overallStreamPos - this._currentSize;
            this._listener.processRecord(globalOffset, this._recordCounter, sid, dataSize, this._data);
        }

        public void close() throws IOException {
            this._is.close();
        }
    }

    private static final class BiffRecordListener
    implements IBiffRecordListener {
        private final Writer _hexDumpWriter;
        private final List _headers;

        public BiffRecordListener(Writer hexDumpWriter) {
            this._hexDumpWriter = hexDumpWriter;
            this._headers = new ArrayList();
        }

        public void processRecord(int globalOffset, int recordCounter, int sid, int dataSize, byte[] data) {
            String header = BiffRecordListener.formatRecordDetails(globalOffset, sid, dataSize, recordCounter);
            this._headers.add(header);
            Writer w = this._hexDumpWriter;
            if (w != null) {
                try {
                    w.write(header);
                    w.write(NEW_LINE_CHARS);
                    BiffViewer.hexDumpAligned(w, data, 0, dataSize + 4, globalOffset);
                    w.flush();
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
        }

        public String[] getRecentHeaders() {
            String[] result = new String[this._headers.size()];
            this._headers.toArray(result);
            this._headers.clear();
            return result;
        }

        private static String formatRecordDetails(int globalOffset, int sid, int size, int recordCounter) {
            StringBuffer sb = new StringBuffer(64);
            sb.append("Offset=").append(HexDump.intToHex(globalOffset)).append("(").append(globalOffset).append(")");
            sb.append(" recno=").append(recordCounter);
            sb.append(" sid=").append(HexDump.shortToHex(sid));
            sb.append(" size=").append(HexDump.shortToHex(size)).append("(").append(size).append(")");
            return sb.toString();
        }
    }

    private static interface IBiffRecordListener {
        public void processRecord(int var1, int var2, int var3, int var4, byte[] var5);
    }
}

